/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;

public class StateSpaceExplorationHelper {
    private static final double MIN_FREE_MEMORY_PERC = 30.0;
    private static final int MIN_FREE_MEM_CHECK_INTERVAL = 10;
    private static final int MAX_FREE_MEM_CHECK_INTERVAL = 900;
    private final StateSpaceManager manager;
    private int expectedDuration;
    private int lastDuration;
    private long lastFreeMemCheck;
    private long nextFreeMemCheck;
    private double lastFreeMemPerc;
    private int blockSize;
    private int minBlockSize;
    private int maxBlockSize;
    private Set<State> nextStates;
    private boolean generateLocations;
    private int steps;
    private double[] lastSpeeds;

    public StateSpaceExplorationHelper(StateSpaceManager manager, int stepDuration) {
        this.lastDuration = this.expectedDuration;
        this.manager = manager;
        this.expectedDuration = stepDuration;
        this.generateLocations = false;
        this.nextStates = new LinkedHashSet<State>();
        this.lastSpeeds = new double[10];
        this.steps = 0;
        this.blockSize = 10;
        this.minBlockSize = manager.getNumThreads() * 4;
        this.maxBlockSize = 2000;
        System.gc();
        this.lastFreeMemPerc = this.getFreeMemPerc();
        this.lastFreeMemCheck = System.currentTimeMillis();
        this.nextFreeMemCheck = this.lastFreeMemCheck + 60000L;
    }

    public StateSpaceExplorationHelper(StateSpaceManager manager) {
        this(manager, 2000);
    }

    public boolean doExplorationStep() throws StateSpaceException {
        long startTime = System.currentTimeMillis();
        double speedChange = this.rangeCheck((double)this.expectedDuration / (double)this.lastDuration, 0.5, 2.0);
        this.blockSize = this.rangeCheck((int)((double)this.blockSize * speedChange), this.minBlockSize, this.maxBlockSize);
        Iterator<State> iterator = this.nextStates.iterator();
        while (iterator.hasNext()) {
            State state = iterator.next();
            if (state.isOpen()) continue;
            iterator.remove();
        }
        int maxStateDistance = this.manager.getStateSpace().getMaxStateDistance();
        if (maxStateDistance >= 0) {
            iterator = this.nextStates.iterator();
            while (iterator.hasNext()) {
                State state = iterator.next();
                if (maxStateDistance > this.manager.getStateDistance(state)) continue;
                iterator.remove();
            }
        }
        for (State open : this.manager.getStateSpace().getOpenStates()) {
            if (this.nextStates.size() >= this.blockSize) break;
            if (maxStateDistance >= 0 && maxStateDistance <= this.manager.getStateDistance(open)) continue;
            this.nextStates.add(open);
        }
        if (this.nextStates.isEmpty()) {
            return false;
        }
        int realSize = Math.min(this.blockSize, this.nextStates.size());
        ArrayList<State> exploreNow = new ArrayList<State>(realSize);
        Iterator<State> it = this.nextStates.iterator();
        int i = 0;
        while (i < realSize) {
            exploreNow.add(it.next());
            it.remove();
            ++i;
        }
        List<State> result = this.manager.exploreStates(exploreNow, this.generateLocations);
        Set<State> oldNextStates = this.nextStates;
        this.nextStates = new LinkedHashSet<State>();
        this.nextStates.addAll(result);
        it = oldNextStates.iterator();
        int maxStates = 2 * this.blockSize;
        while (it.hasNext() && this.nextStates.size() < maxStates) {
            this.nextStates.add(it.next());
        }
        long endTime = System.currentTimeMillis();
        this.lastDuration = this.rangeCheck((int)(endTime - startTime), 1, 10 * this.expectedDuration);
        this.lastSpeeds[this.steps % this.lastSpeeds.length] = 1000.0 * (double)realSize / (double)this.lastDuration;
        if (endTime >= this.nextFreeMemCheck) {
            System.gc();
            double freeMemPerc = this.getFreeMemPerc();
            double lostPerc = Math.max(this.lastFreeMemPerc - freeMemPerc, 0.0);
            double percPerSec = lostPerc / ((double)(endTime - this.lastFreeMemCheck) / 1000.0);
            System.out.print("Free memory: " + freeMemPerc + "%");
            if (freeMemPerc < 30.0) {
                System.out.print(" Clearing cache.");
                this.manager.clearCache();
                System.gc();
                freeMemPerc = this.getFreeMemPerc();
            }
            double percToLose = freeMemPerc - 15.0;
            long expectedSec = Math.min(Math.max((int)(percToLose / percPerSec), 10), 900);
            System.out.println(" (checking again in " + expectedSec + " seconds)");
            this.lastFreeMemPerc = freeMemPerc;
            this.lastFreeMemCheck = endTime;
            this.nextFreeMemCheck = endTime + expectedSec * 1000L;
        }
        ++this.steps;
        return true;
    }

    private double getFreeMemPerc() {
        return 100.0 * ((double)Runtime.getRuntime().freeMemory() / (double)Runtime.getRuntime().maxMemory());
    }

    private int rangeCheck(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    private double rangeCheck(double value, double min, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    public StateSpaceManager getStateSpaceManager() {
        return this.manager;
    }

    public void setGenerateLocations(boolean generateLocations) {
        this.generateLocations = generateLocations;
    }

    public double getCurrentSpeed() {
        if (this.steps <= 0) {
            return 0.0;
        }
        double speed = 0.0;
        int count = Math.min(this.steps, this.lastSpeeds.length);
        int i = 0;
        while (i < count) {
            speed += this.lastSpeeds[i];
            ++i;
        }
        return speed / (double)count;
    }

    public void doExploration(int maxStates, IProgressMonitor monitor) throws StateSpaceException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Exploring state space...", maxStates);
        int explored = this.manager.getStateSpace().getStateCount();
        boolean changed = true;
        monitor.worked(explored);
        while (changed && !monitor.isCanceled() && (maxStates < 0 || this.manager.getStateSpace().getStateCount() <= maxStates)) {
            changed = this.doExplorationStep();
            monitor.worked(this.manager.getStateSpace().getStateCount() - explored);
            explored = this.manager.getStateSpace().getStateCount();
        }
        monitor.done();
    }
}

