/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.ecore.part;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.ecore.part.EcoreDiagramEditorPlugin;
import org.eclipse.gmf.runtime.diagram.core.DiagramEditingDomainFactory;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.AbstractDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.internal.l10n.EditorMessages;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;

public class URIDiagramDocumentProvider
extends AbstractDocumentProvider
implements IDiagramDocumentProvider {
    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        if (!(element instanceof URIEditorInput)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.gmf.ecore.editor", 0, "Incorrect element used: " + element + " instead of org.eclipse.emf.common.ui.URIEditorInput", null));
        }
        IEditorInput editorInput = (IEditorInput)element;
        IDiagramDocument document = (IDiagramDocument)this.createDocument(editorInput);
        ResourceSetInfo info = new ResourceSetInfo(document, editorInput);
        info.setModificationStamp(this.computeModificationStamp(info));
        info.fStatus = null;
        ResourceSetModificationListener modificationListener = new ResourceSetModificationListener(info);
        info.getResourceSet().eAdapters().add((Object)modificationListener);
        return info;
    }

    protected IDocument createDocument(Object element) throws CoreException {
        if (!(element instanceof URIEditorInput)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.gmf.ecore.editor", 0, "Incorrect element used: " + element + " instead of org.eclipse.emf.common.ui.URIEditorInput", null));
        }
        IDocument document = this.createEmptyDocument();
        this.setDocumentContent(document, (IEditorInput)((URIEditorInput)element));
        this.setupDocument(element, document);
        return document;
    }

    protected void setupDocument(Object element, IDocument document) {
    }

    private long computeModificationStamp(ResourceSetInfo info) {
        int result = 0;
        for (Resource nextResource : info.getResourceSet().getResources()) {
            IFile file = WorkspaceSynchronizer.getFile((Resource)nextResource);
            if (file == null) continue;
            result = file.getLocation() != null ? (int)((long)result + file.getLocation().toFile().lastModified()) : (int)((long)result + file.getModificationStamp());
        }
        return result;
    }

    protected IDocument createEmptyDocument() {
        DiagramDocument document = new DiagramDocument();
        document.setEditingDomain(this.createEditingDomain());
        return document;
    }

    private TransactionalEditingDomain createEditingDomain() {
        TransactionalEditingDomain editingDomain = DiagramEditingDomainFactory.getInstance().createEditingDomain();
        editingDomain.setID("org.eclipse.gmf.ecore.editor.EditingDomain");
        final NotificationFilter diagramResourceModifiedFilter = NotificationFilter.createNotifierFilter((Object)editingDomain.getResourceSet()).and(NotificationFilter.createEventTypeFilter((int)3)).and(NotificationFilter.createFeatureFilter(ResourceSet.class, (int)0));
        editingDomain.getResourceSet().eAdapters().add((Object)new Adapter(){
            private Notifier myTarger;

            public Notifier getTarget() {
                return this.myTarger;
            }

            public boolean isAdapterForType(Object type) {
                return false;
            }

            public void notifyChanged(Notification notification) {
                Object value;
                if (diagramResourceModifiedFilter.matches(notification) && (value = notification.getNewValue()) instanceof Resource) {
                    ((Resource)value).setTrackingModification(true);
                }
            }

            public void setTarget(Notifier newTarget) {
                this.myTarger = newTarget;
            }
        });
        return editingDomain;
    }

    protected void setDocumentContent(IDocument document, IEditorInput element) throws CoreException {
        if (!(element instanceof URIEditorInput)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.gmf.ecore.editor", 0, "Incorrect element used: " + element + " instead of org.eclipse.emf.common.ui.URIEditorInput", null));
        }
        URI uri = ((URIEditorInput)element).getURI();
        IDiagramDocument diagramDocument = (IDiagramDocument)document;
        TransactionalEditingDomain domain = diagramDocument.getEditingDomain();
        Resource resource = null;
        try {
            resource = domain.getResourceSet().getResource(uri.trimFragment(), false);
            if (resource == null) {
                resource = domain.getResourceSet().createResource(uri.trimFragment());
            }
            if (!resource.isLoaded()) {
                try {
                    HashMap options = new HashMap(GMFResourceFactory.getDefaultLoadOptions());
                    resource.load(options);
                }
                catch (IOException e) {
                    resource.unload();
                    throw e;
                }
            }
            if (resource == null) {
                throw new RuntimeException("Unable to load diagram resource");
            }
            if (uri.fragment() != null) {
                EObject rootElement = resource.getEObject(uri.fragment());
                if (rootElement instanceof Diagram) {
                    document.setContent((Object)((Diagram)rootElement));
                    return;
                }
            } else {
                for (Object rootElement : resource.getContents()) {
                    if (!(rootElement instanceof Diagram)) continue;
                    document.setContent((Object)((Diagram)rootElement));
                    return;
                }
            }
            throw new RuntimeException("Diagram is not present in resource");
        }
        catch (Exception e) {
            String msg;
            CoreException thrownExcp = null;
            thrownExcp = e instanceof CoreException ? (CoreException)((Object)e) : new CoreException((IStatus)new Status(4, "org.eclipse.gmf.ecore.editor", 0, (msg = e.getLocalizedMessage()) != null ? msg : "Error loading diagram", (Throwable)e));
            throw thrownExcp;
        }
    }

    public long getModificationStamp(Object element) {
        ResourceSetInfo info = this.getResourceSetInfo(element);
        if (info != null) {
            return this.computeModificationStamp(info);
        }
        return super.getModificationStamp(element);
    }

    public boolean isDeleted(Object element) {
        if (element instanceof URIEditorInput) {
            File file = URIDiagramDocumentProvider.getFile((URIEditorInput)element);
            return file != null && !file.exists();
        }
        return false;
    }

    public ResourceSetInfo getResourceSetInfo(Object editorInput) {
        return (ResourceSetInfo)super.getElementInfo(editorInput);
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        if (info instanceof ResourceSetInfo) {
            ResourceSetInfo resourceSetInfo = (ResourceSetInfo)info;
            resourceSetInfo.dispose();
        }
        super.disposeElementInfo(element, info);
    }

    public boolean isReadOnly(Object element) {
        File file;
        if (element instanceof URIEditorInput && (file = URIDiagramDocumentProvider.getFile((URIEditorInput)element)) != null && file.exists()) {
            return !file.canWrite();
        }
        return false;
    }

    public boolean isModifiable(Object element) {
        File file;
        if (element instanceof URIEditorInput && (file = URIDiagramDocumentProvider.getFile((URIEditorInput)element)) != null && file.exists()) {
            return file.canWrite();
        }
        return true;
    }

    public boolean isSynchronized(Object element) {
        ResourceSetInfo info = this.getResourceSetInfo(element);
        if (info != null) {
            return info.isSynchronized();
        }
        return super.isSynchronized(element);
    }

    protected void doSynchronize(Object element, IProgressMonitor monitor) throws CoreException {
        ResourceSetInfo info = this.getResourceSetInfo(element);
        if (info != null) {
            for (Resource nextResource : info.getResourceSet().getResources()) {
                this.handleElementChanged(info, nextResource, monitor);
            }
            return;
        }
        super.doSynchronize(element, monitor);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        ResourceSetInfo info = this.getResourceSetInfo(element);
        if (info != null) {
            if (!overwrite && !info.isSynchronized()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.gmf.ecore.editor", 0, "The file has been changed on the file system", null));
            }
            info.stopResourceListening();
            this.fireElementStateChanging(element);
            EList resources = info.getResourceSet().getResources();
            try {
                try {
                    monitor.beginTask("Saving diagram", resources.size() + 1);
                    HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                    options.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
                    for (Resource nextResource : resources) {
                        monitor.setTaskName("Saving " + nextResource.getURI());
                        if (nextResource.isLoaded() && (!nextResource.isTrackingModification() || nextResource.isModified())) {
                            try {
                                nextResource.save(options);
                            }
                            catch (IOException e) {
                                this.fireElementStateChangeFailed(element);
                                throw new CoreException((IStatus)new Status(4, "org.eclipse.gmf.ecore.editor", 5, e.getLocalizedMessage(), null));
                            }
                        }
                        monitor.worked(1);
                    }
                    monitor.done();
                }
                catch (RuntimeException x) {
                    this.fireElementStateChangeFailed(element);
                    throw x;
                }
            }
            finally {
                info.startResourceListening();
            }
        }
    }

    protected void handleElementChanged(ResourceSetInfo info, Resource changedResource, IProgressMonitor monitor) {
        IFile file = WorkspaceSynchronizer.getFile((Resource)changedResource);
        if (file != null) {
            try {
                file.refreshLocal(2, monitor);
            }
            catch (CoreException ex) {
                EcoreDiagramEditorPlugin.getInstance().logError(EditorMessages.FileDocumentProvider_handleElementContentChanged, ex);
            }
        }
        changedResource.unload();
        this.fireElementContentAboutToBeReplaced(info.getEditorInput());
        this.removeUnchangedElementListeners(info.getEditorInput(), info);
        info.fStatus = null;
        try {
            this.setDocumentContent(info.fDocument, info.getEditorInput());
        }
        catch (CoreException e) {
            info.fStatus = e.getStatus();
        }
        if (!info.fCanBeSaved) {
            info.setModificationStamp(this.computeModificationStamp(info));
        }
        this.addUnchangedElementListeners(info.getEditorInput(), info);
        this.fireElementContentReplaced(info.getEditorInput());
    }

    protected void handleElementMoved(IEditorInput input, URI uri) {
        this.fireElementMoved(input, new URIEditorInput(uri));
    }

    public IEditorInput createInputWithEditingDomain(IEditorInput editorInput, TransactionalEditingDomain domain) {
        return editorInput;
    }

    public IDiagramDocument getDiagramDocument(Object element) {
        IDocument doc = this.getDocument(element);
        if (doc instanceof IDiagramDocument) {
            return (IDiagramDocument)doc;
        }
        return null;
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    public static File getFile(URIEditorInput input) {
        return URIDiagramDocumentProvider.getFile(input.getURI().trimFragment());
    }

    public static File getFile(URI resourceUri) {
        File file;
        if (resourceUri != null && resourceUri.isFile() && !(file = new File(resourceUri.toFileString())).isDirectory()) {
            return file;
        }
        return null;
    }

    protected class ResourceSetInfo
    extends AbstractDocumentProvider.ElementInfo {
        private long myModificationStamp;
        private WorkspaceSynchronizer mySynchronizer;
        private Collection myUnSynchronizedResources;
        private IDiagramDocument myDocument;
        private IEditorInput myEditorInput;
        private boolean myUpdateCache;
        private boolean myModifiable;
        private boolean myReadOnly;

        public ResourceSetInfo(IDiagramDocument document, IEditorInput editorInput) {
            super((AbstractDocumentProvider)URIDiagramDocumentProvider.this, (IDocument)document);
            this.myModificationStamp = -1L;
            this.myUnSynchronizedResources = new ArrayList();
            this.myUpdateCache = true;
            this.myModifiable = false;
            this.myReadOnly = true;
            this.myDocument = document;
            this.myEditorInput = editorInput;
            this.startResourceListening();
        }

        public long getModificationStamp() {
            return this.myModificationStamp;
        }

        public void setModificationStamp(long modificationStamp) {
            this.myModificationStamp = modificationStamp;
        }

        public ResourceSet getResourceSet() {
            return this.myDocument.getEditingDomain().getResourceSet();
        }

        public IEditorInput getEditorInput() {
            return this.myEditorInput;
        }

        public void dispose() {
            this.stopResourceListening();
            for (Resource resource : this.getResourceSet().getResources()) {
                resource.unload();
            }
        }

        public boolean isSynchronized() {
            return this.myUnSynchronizedResources.size() == 0;
        }

        public void setUnSynchronized(Resource resource) {
            this.myUnSynchronizedResources.add(resource);
        }

        public void setSynchronized(Resource resource) {
            this.myUnSynchronizedResources.remove(resource);
        }

        public final void stopResourceListening() {
            this.mySynchronizer.dispose();
            this.mySynchronizer = null;
        }

        public final void startResourceListening() {
            this.mySynchronizer = new WorkspaceSynchronizer(this.myDocument.getEditingDomain(), (WorkspaceSynchronizer.Delegate)new SynchronizerDelegate());
        }

        public boolean isUpdateCache() {
            return this.myUpdateCache;
        }

        public void setUpdateCache(boolean update) {
            this.myUpdateCache = update;
        }

        public boolean isModifiable() {
            return this.myModifiable;
        }

        public void setModifiable(boolean modifiable) {
            this.myModifiable = modifiable;
        }

        public boolean isReadOnly() {
            return this.myReadOnly;
        }

        public void setReadOnly(boolean readOnly) {
            this.myReadOnly = readOnly;
        }

        private class SynchronizerDelegate
        implements WorkspaceSynchronizer.Delegate {
            private SynchronizerDelegate() {
            }

            public void dispose() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean handleResourceChanged(final Resource resource) {
                ResourceSetInfo resourceSetInfo = ResourceSetInfo.this;
                synchronized (resourceSetInfo) {
                    if (ResourceSetInfo.this.fCanBeSaved) {
                        ResourceSetInfo.this.setUnSynchronized(resource);
                        return true;
                    }
                }
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        URIDiagramDocumentProvider.this.handleElementChanged(ResourceSetInfo.this, resource, null);
                    }
                });
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean handleResourceDeleted(Resource resource) {
                ResourceSetInfo resourceSetInfo = ResourceSetInfo.this;
                synchronized (resourceSetInfo) {
                    if (ResourceSetInfo.this.fCanBeSaved) {
                        ResourceSetInfo.this.setUnSynchronized(resource);
                        return true;
                    }
                }
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        URIDiagramDocumentProvider.this.fireElementDeleted(ResourceSetInfo.this.getEditorInput());
                    }
                });
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean handleResourceMoved(Resource resource, final URI newURI) {
                ResourceSetInfo resourceSetInfo = ResourceSetInfo.this;
                synchronized (resourceSetInfo) {
                    if (ResourceSetInfo.this.fCanBeSaved) {
                        ResourceSetInfo.this.setUnSynchronized(resource);
                        return true;
                    }
                }
                if (ResourceSetInfo.this.myDocument.getDiagram().eResource() == resource) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            URIDiagramDocumentProvider.this.handleElementMoved(ResourceSetInfo.this.getEditorInput(), newURI);
                        }
                    });
                    return true;
                }
                this.handleResourceDeleted(resource);
                return true;
            }
        }
    }

    private class ResourceSetModificationListener
    extends EContentAdapter {
        private NotificationFilter myModifiedFilter;
        private ResourceSetInfo myInfo;

        public ResourceSetModificationListener(ResourceSetInfo info) {
            this.myInfo = info;
            this.myModifiedFilter = NotificationFilter.createEventTypeFilter((int)1).or(NotificationFilter.createEventTypeFilter((int)2)).and(NotificationFilter.createFeatureFilter(Resource.class, (int)3));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyChanged(Notification notification) {
            Resource resource;
            if (notification.getNotifier() instanceof ResourceSet) {
                super.notifyChanged(notification);
            }
            if (this.myModifiedFilter.matches(notification) && notification.getNotifier() instanceof Resource && (resource = (Resource)notification.getNotifier()).isLoaded()) {
                boolean modified = false;
                Iterator it = this.myInfo.getResourceSet().getResources().iterator();
                while (it.hasNext() && !modified) {
                    Resource nextResource = (Resource)it.next();
                    if (!nextResource.isLoaded()) continue;
                    modified = nextResource.isModified();
                }
                boolean dirtyStateChanged = false;
                ResourceSetInfo resourceSetInfo = this.myInfo;
                synchronized (resourceSetInfo) {
                    if (modified != this.myInfo.fCanBeSaved) {
                        this.myInfo.fCanBeSaved = modified;
                        dirtyStateChanged = true;
                    }
                    if (!resource.isModified()) {
                        this.myInfo.setSynchronized(resource);
                    }
                }
                if (dirtyStateChanged) {
                    URIDiagramDocumentProvider.this.fireElementDirtyStateChanged(this.myInfo.getEditorInput(), modified);
                    if (!modified) {
                        this.myInfo.setModificationStamp(URIDiagramDocumentProvider.this.computeModificationStamp(this.myInfo));
                    }
                }
            }
        }
    }
}

