/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.dnd.drop;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.EnumeratedType;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.services.dnd.core.ITransferAgent;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drop.IDropTargetContext;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drop.IDropTargetEvent;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drop.IDropTargetListener;
import org.eclipse.gmf.runtime.common.ui.services.dnd.internal.CommonUIServicesDNDDebugOptions;
import org.eclipse.gmf.runtime.common.ui.services.dnd.internal.CommonUIServicesDNDPlugin;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class AbstractDropTargetListener
implements IDropTargetListener {
    private IDropTargetContext context = null;
    private ITransferAgent currentAgent = null;
    private IDropTargetEvent currentEvent = null;
    private final List transferIds = new Vector();

    public AbstractDropTargetListener(String[] transferIdArray) {
        assert (transferIdArray != null) : "transferIdArray cannot be null";
        assert (transferIdArray.length > 0) : "transferIdArray cannot be empty";
        this.transferIds.addAll((Collection)Arrays.asList(transferIdArray));
    }

    public AbstractDropTargetListener() {
    }

    public final String[] getSupportingTransferIds() {
        return this.transferIds.toArray(new String[this.transferIds.size()]);
    }

    public final void addSupportingTransferId(String transferId) {
        assert (transferId != null) : "transferId cannot be null";
        if (!this.transferIds.contains(transferId)) {
            this.transferIds.add(transferId);
        }
    }

    public void dragEnter(DropTargetEvent event) {
    }

    public void dragLeave(DropTargetEvent event) {
        this.currentAgent = null;
        this.currentEvent = null;
        this.context = null;
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
    }

    public final void drop(DropTargetEvent event) {
        if (this.getContext().getCurrentTarget() == null) {
            event.detail = 0;
            return;
        }
        final ICommand command = this.getExecutableContext(event);
        final IOperationHistory manager = (IOperationHistory)this.getContext().getActivePart().getAdapter(IOperationHistory.class);
        if (manager == null || command == null) {
            event.detail = 0;
            return;
        }
        WorkIndicatorType type = this.getWorkIndicatorType();
        if (type == WorkIndicatorType.PROGRESS_MONITOR) {
            this.runCommandInProgressMonitorDialog(command, false);
        } else if (type == WorkIndicatorType.CANCELABLE_PROGRESS_MONITOR) {
            this.runCommandInProgressMonitorDialog(command, true);
        } else if (type == WorkIndicatorType.BUSY) {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    try {
                        manager.execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
                    }
                    catch (ExecutionException e) {
                        Trace.catching((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"drop", (Throwable)e);
                        Log.error((Plugin)CommonUIServicesDNDPlugin.getDefault(), (int)1, (String)"drop", (Throwable)e);
                    }
                }
            });
        } else {
            try {
                manager.execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Trace.catching((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"drop", (Throwable)e);
                Log.error((Plugin)CommonUIServicesDNDPlugin.getDefault(), (int)1, (String)"drop", (Throwable)e);
            }
        }
        event.detail = command.getCommandResult().getStatus().isOK() ? event.detail : 0;
        this.currentAgent = null;
        this.currentEvent = null;
        this.context = null;
    }

    public void dropAccept(DropTargetEvent event) {
    }

    protected final IDropTargetContext getContext() {
        return this.context;
    }

    public ICommand getExecutableContext(DropTargetEvent event) {
        return null;
    }

    public void setFeedback(DropTargetEvent event) {
        event.feedback |= 0x18;
        switch (this.getContext().getRelativeLocation()) {
            case 1: {
                event.feedback |= 2;
                break;
            }
            case 2: {
                event.feedback |= 4;
                break;
            }
            default: {
                event.feedback |= 1;
            }
        }
    }

    public abstract boolean canSupport();

    public final boolean canSupport(IDropTargetContext cntxt, IDropTargetEvent currEvent, ITransferAgent currAgent) {
        this.context = cntxt;
        this.currentEvent = currEvent;
        this.currentAgent = currAgent;
        return this.canSupport();
    }

    protected final IDropTargetEvent getCurrentEvent() {
        return this.currentEvent;
    }

    protected final ITransferAgent getCurrentAgent() {
        return this.currentAgent;
    }

    protected final Shell getShell() {
        IWorkbenchPartSite site = this.getContext().getActivePart().getSite();
        return site != null ? site.getShell() : null;
    }

    protected WorkIndicatorType getWorkIndicatorType() {
        return WorkIndicatorType.BUSY;
    }

    private void runCommandInProgressMonitorDialog(final ICommand command, boolean cancelable) {
        final IOperationHistory manager = (IOperationHistory)this.getContext().getActivePart().getAdapter(IOperationHistory.class);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    manager.execute((IUndoableOperation)command, monitor, null);
                }
                catch (ExecutionException e) {
                    Trace.catching((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"drop", (Throwable)e);
                    Log.error((Plugin)CommonUIServicesDNDPlugin.getDefault(), (int)1, (String)"drop", (Throwable)e);
                    RuntimeException re = new RuntimeException(e);
                    Trace.throwing((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.EXCEPTIONS_THROWING, this.getClass(), (String)"runCommandInProgressMonitorDialog", (Throwable)re);
                    throw re;
                }
            }
        };
        this.runInProgressMonitorDialog(runnable, cancelable);
    }

    private void runInProgressMonitorDialog(IRunnableWithProgress runnable, boolean cancelable) {
        try {
            if (System.getProperty("RUN_PROGRESS_IN_UI_HACK") != null) {
                new ProgressMonitorDialog(null).run(false, cancelable, runnable);
            } else {
                new ProgressMonitorDialog(null).run(true, cancelable, runnable);
            }
        }
        catch (InvocationTargetException ite) {
            Trace.catching((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"runInProgressMonitorDialog", (Throwable)ite);
            Log.error((Plugin)CommonUIServicesDNDPlugin.getDefault(), (int)1, (String)"runInProgressMonitorDialog", (Throwable)ite);
            RuntimeException cre = new RuntimeException(ite.getTargetException());
            Trace.throwing((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.EXCEPTIONS_THROWING, this.getClass(), (String)"runInProgressMonitorDialog", (Throwable)cre);
            throw cre;
        }
        catch (InterruptedException ie) {
            Trace.catching((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"runInProgressMonitorDialog", (Throwable)ie);
        }
    }

    public static class WorkIndicatorType
    extends EnumeratedType {
        private static final long serialVersionUID = 1L;
        private static int nextOrdinal = 0;
        public static final WorkIndicatorType NONE = new WorkIndicatorType("None");
        public static final WorkIndicatorType BUSY = new WorkIndicatorType("Busy");
        public static final WorkIndicatorType PROGRESS_MONITOR = new WorkIndicatorType("Progress Monitor");
        public static final WorkIndicatorType CANCELABLE_PROGRESS_MONITOR = new WorkIndicatorType("Cancelable Progress Monitor");
        private static final WorkIndicatorType[] VALUES = new WorkIndicatorType[]{NONE, BUSY, PROGRESS_MONITOR, CANCELABLE_PROGRESS_MONITOR};

        protected WorkIndicatorType(String name, int ordinal) {
            super(name, ordinal);
        }

        private WorkIndicatorType(String name) {
            this(name, nextOrdinal++);
        }

        protected List getValues() {
            return Collections.unmodifiableList(Arrays.asList(VALUES));
        }
    }
}

