/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.clipboard.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;
import org.eclipse.gmf.runtime.emf.clipboard.core.CopyObjects;
import org.eclipse.gmf.runtime.emf.clipboard.core.IClipboardSupport;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.ClipboardPlugin;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.ListIndexComparator;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.SerializationEMFResource;

public class SavingEMFResource
extends SerializationEMFResource {
    private Map copy2ObjectMap;
    private EList contentList;
    private Set contentSet;
    private CopyObjects copyObjects;
    private Collection excludedObjects;

    public SavingEMFResource(URI uri, String encoding, Map defaultSaveOptions, Map copy2ObjectMap, CopyObjects copyObjects, IClipboardSupport clipboardOperationHelper) {
        super(encoding, uri, clipboardOperationHelper);
        this.defaultSaveOptions = defaultSaveOptions;
        this.eObjectToIDMap = new HashMap();
        this.idToEObjectMap = new HashMap();
        this.copy2ObjectMap = copy2ObjectMap;
        this.contentSet = new HashSet(copyObjects.totalCopyObjects);
        this.copyObjects = copyObjects;
        this.excludedObjects = clipboardOperationHelper.getExcludedCopyObjects(copyObjects.totalCopyObjects);
        this.setMissingResource();
        this.setContainmentFeatures();
        this.setLoaded(true);
        this.sortContentSetOnOriginalStorageOrder();
    }

    private void sortContentSetOnOriginalStorageOrder() {
        HashMap<EObject, ArrayList<EObject>> parentObjectMap = new HashMap<EObject, ArrayList<EObject>>();
        ArrayList<EObject> roots = new ArrayList<EObject>();
        for (EObject eObj : this.contentSet) {
            EObject eParent = eObj.eContainer();
            if (eParent == null) {
                roots.add(eObj);
                continue;
            }
            ArrayList<EObject> children = (ArrayList<EObject>)parentObjectMap.get(eParent);
            if (children == null) {
                children = new ArrayList<EObject>();
                parentObjectMap.put(eParent, children);
            }
            children.add(eObj);
        }
        ArrayList list = new ArrayList(roots);
        for (Map.Entry entry : parentObjectMap.entrySet()) {
            Collections.sort((List)entry.getValue(), new ListIndexComparator(((InternalEList)((EObject)entry.getKey()).eContents()).basicList()));
            list.addAll((List)entry.getValue());
        }
        this.contentSet = new LinkedHashSet(list);
    }

    private void setContainmentFeatures() {
        EAnnotation containmentAnnotations = EcoreFactory.eINSTANCE.createEAnnotation();
        EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        eAnnotation.setSource(SERIALIZATION_ANNOTATIONS);
        containmentAnnotations.getEAnnotations().add((Object)eAnnotation);
        HashSet set = new HashSet(this.contentSet);
        set.addAll(this.copyObjects.originalObjects);
        for (EObject eObj : set) {
            this.addToSerializationAnnotation(eAnnotation, eObj);
            TreeIterator contentIt = eObj.eAllContents();
            while (contentIt.hasNext()) {
                EObject childEObj = (EObject)contentIt.next();
                if (!this.getClipboardOperationHelper().shouldSaveContainmentFeature(childEObj)) {
                    contentIt.prune();
                    continue;
                }
                this.addToSerializationAnnotation(eAnnotation, childEObj);
            }
        }
        super.getContents().add((Object)containmentAnnotations);
        this.contentSet.add(containmentAnnotations);
    }

    private void addToSerializationAnnotation(EAnnotation eAnnotation, EObject eObj) {
        EObject eObjectWithValidContainer = eObj.eContainer() == null ? this.getOriginalEObject(eObj) : eObj;
        EAnnotation ref_obj_Annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        ref_obj_Annotation.getReferences().add((Object)eObj);
        if (eObjectWithValidContainer != null) {
            ref_obj_Annotation.getReferences().add((Object)eObjectWithValidContainer.eContainmentFeature());
        } else {
            ref_obj_Annotation.getReferences().add((Object)EcoreFactory.eINSTANCE.createEReference());
        }
        eAnnotation.getEAnnotations().add((Object)ref_obj_Annotation);
    }

    private void setMissingResource() {
        Iterator it = this.contentSet.iterator();
        EObject eObject2 = null;
        while (it.hasNext()) {
            eObject2 = (EObject)it.next();
            if (eObject2.eResource() != null) continue;
            while (eObject2.eContainer() != null) {
                eObject2 = eObject2.eContainer();
            }
            super.getContents().add((Object)eObject2);
        }
        for (EObject eObject2 : this.contentSet) {
            if (eObject2.eResource() != null) continue;
            IllegalArgumentException e = new IllegalArgumentException();
            ClipboardPlugin.throwing(((Object)((Object)this)).getClass(), "setMissingResource", e);
            throw e;
        }
    }

    public void doLoad(InputStream inputStream, Map options) throws IOException {
        this.throwUnsupportedOperationException("doLoad", new UnsupportedOperationException("Can't call load on serializing resource"));
    }

    protected XMLSave createXMLSave() {
        return new XMISaveImpl(this.createXMLHelper()){

            protected void saveElement(InternalEObject o, EStructuralFeature f) {
                this.saveElement((EObject)o, f);
            }

            protected void saveElement(EObject o, EStructuralFeature f) {
                if (SavingEMFResource.this.excludedObjects.contains(o)) {
                    return;
                }
                super.saveElement(o, f);
            }

            protected int sameDocMany(EObject o, EStructuralFeature f) {
                InternalEList values = (InternalEList)this.helper.getValue(o, f);
                if (values.isEmpty()) {
                    return 0;
                }
                Iterator i = values.basicIterator();
                while (i.hasNext()) {
                    InternalEObject value = (InternalEObject)i.next();
                    if (!value.eIsProxy() && SavingEMFResource.this.isInSavingResource((EObject)value)) continue;
                    return 2;
                }
                return 1;
            }

            protected int sameDocSingle(EObject o, EStructuralFeature f) {
                InternalEObject value = (InternalEObject)this.helper.getValue(o, f);
                if (value == null) {
                    return 0;
                }
                if (value.eIsProxy()) {
                    return 2;
                }
                return SavingEMFResource.this.isInSavingResource((EObject)value) ? 1 : 2;
            }
        };
    }

    boolean isInSavingResource(EObject eObject) {
        if (eObject.eResource() == this) {
            return true;
        }
        if (this.copyObjects.originalObjects.contains(eObject) || this.copyObjects.copyParent2CopyMap.values().contains(eObject) || this.copyObjects.combinedCopyAlwaysSet.contains(eObject)) {
            return true;
        }
        EObject eContainer = eObject.eContainer();
        while (eContainer != null) {
            if (this.copyObjects.originalObjects.contains(eContainer) || this.copyObjects.copyParent2CopyMap.values().contains(eContainer) || this.copyObjects.combinedCopyAlwaysSet.contains(eContainer)) {
                return true;
            }
            eContainer = eContainer.eContainer();
        }
        return false;
    }

    EObject getOriginalEObject(EObject copiedEObject) {
        return (EObject)this.copy2ObjectMap.get(copiedEObject);
    }

    private String getOriginalID(EObject eObject) {
        Resource res = eObject.eResource();
        if (res != this && res != null) {
            return ((XMLResource)res).getID(eObject);
        }
        return null;
    }

    public String getID(EObject eObject) {
        String id = this.getOriginalID(eObject);
        if (id == null) {
            EObject original = (EObject)this.copy2ObjectMap.get(eObject);
            if (original != null) {
                id = this.getOriginalID(original);
            } else {
                Resource res = eObject.eResource();
                if (res != null) {
                    assert (eObject.eResource() == this) : "eObject.eResource not same as self";
                    id = super.getID(eObject);
                }
            }
        }
        return id;
    }

    public EList getContents() {
        if (this.contentList == null) {
            this.contentList = new ContentBasicEList(this.contentSet);
        }
        return this.contentList;
    }

    protected void doUnload() {
        this.contentList = super.getContents();
        super.getContents().clear();
    }

    private static class ContentBasicEList
    extends EcoreEList.UnmodifiableEList
    implements InternalEList {
        private static final long serialVersionUID = -2551747854798104709L;

        ContentBasicEList(Set contentSet) {
            super(null, null, contentSet.size(), contentSet.toArray());
        }
    }
}

