/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.action.actions.global;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.gmf.runtime.common.ui.action.actions.global.ClipboardContentsHelper;
import org.eclipse.gmf.runtime.common.ui.action.actions.global.ClipboardState;
import org.eclipse.gmf.runtime.common.ui.util.CustomDataTransfer;
import org.eclipse.gmf.runtime.common.ui.util.ICustomData;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public final class ClipboardManager {
    public static final String COMMON_FORMAT = "COMMON_FORMAT";
    private static ClipboardManager instance;
    private Hashtable list = new Hashtable();
    private ClipboardState clipboardState = ClipboardState.NORMAL;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.ui.action.actions.global.ClipboardManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        instance = new ClipboardManager();
    }

    private ClipboardManager() {
    }

    public static ClipboardManager getInstance() {
        return instance;
    }

    public Object getClipboardContents(Transfer dataType, ClipboardContentsHelper helper) {
        return helper.getClipboardContents(dataType);
    }

    public void addToCache(Object data, Transfer dataType) {
        this.addToCache(data, dataType, ClipboardState.NORMAL);
    }

    public void addToCache(Object data, Transfer dataType, ClipboardState state) {
        if (data != null && dataType != null) {
            if (dataType instanceof CustomDataTransfer) {
                if (data instanceof ICustomData[]) {
                    ICustomData[] array = (ICustomData[])this.getList().get(CustomDataTransfer.getInstance());
                    if (array != null) {
                        List<ICustomData> oldlist = Arrays.asList(array);
                        List<ICustomData> newlist = Arrays.asList((ICustomData[])data);
                        ArrayList<ICustomData> compound = new ArrayList<ICustomData>();
                        compound.addAll(oldlist);
                        compound.addAll(newlist);
                        array = new ICustomData[compound.size()];
                        compound.toArray(array);
                        this.getList().put(CustomDataTransfer.getInstance(), array);
                    } else {
                        this.getList().put(CustomDataTransfer.getInstance(), data);
                    }
                    this.clipboardState = state;
                }
            } else {
                this.getList().put(dataType, data);
                this.clipboardState = state;
            }
        }
    }

    public void flushCacheToClipboard() {
        if (this.getList().size() > 0) {
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            ArrayList data = new ArrayList();
            data.addAll(this.getList().values());
            ArrayList keys = new ArrayList();
            keys.addAll(this.getList().keySet());
            Transfer[] transfer = new Transfer[keys.size()];
            keys.toArray(transfer);
            clipboard.setContents(data.toArray(), transfer);
            clipboard.dispose();
            this.getList().clear();
        }
    }

    protected void clearCache() {
        this.getList().clear();
    }

    public String[] getAvailableTypeNames() {
        String[] types = new String[]{};
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        types = clipboard.getAvailableTypeNames();
        clipboard.dispose();
        return types;
    }

    private Hashtable getList() {
        return this.list;
    }

    public void removeFromCache(Transfer dataType) {
        if (!$assertionsDisabled && dataType == null) {
            throw new AssertionError();
        }
        this.getList().remove(dataType);
    }

    public boolean doesCacheHaveType(Transfer dataType) {
        if (!$assertionsDisabled && dataType == null) {
            throw new AssertionError();
        }
        return this.getList().containsKey(dataType);
    }

    public boolean doesClipboardHaveData(String format, ClipboardContentsHelper contentsHelper) {
        if (!$assertionsDisabled && format == null) {
            throw new AssertionError();
        }
        Object data = this.getClipboardContents((Transfer)CustomDataTransfer.getInstance(), contentsHelper);
        if (data != null && data instanceof ICustomData[]) {
            ICustomData[] array = (ICustomData[])data;
            int i = 0;
            while (i < array.length) {
                if (format.equals(array[i].getFormatType())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean doesClipboardHaveData(Transfer dataType, ClipboardContentsHelper contentsHelper) {
        if (!$assertionsDisabled && dataType == null) {
            throw new AssertionError();
        }
        Object data = this.getClipboardContents(dataType, contentsHelper);
        return data != null;
    }

    public ICustomData[] getClipboardData(String format, ClipboardContentsHelper contentsHelper) {
        if (!$assertionsDisabled && format == null) {
            throw new AssertionError();
        }
        Object data = this.getClipboardContents((Transfer)CustomDataTransfer.getInstance(), contentsHelper);
        if (data != null && data instanceof ICustomData[]) {
            ICustomData[] array = (ICustomData[])data;
            ArrayList<ICustomData> dataList = new ArrayList<ICustomData>();
            int i = 0;
            while (i < array.length) {
                if (format.equals(array[i].getFormatType())) {
                    dataList.add(array[i]);
                }
                ++i;
            }
            if (!dataList.isEmpty()) {
                array = new ICustomData[dataList.size()];
                dataList.toArray(array);
                return array;
            }
        }
        return null;
    }

    public ClipboardState getClipboardState() {
        return this.clipboardState;
    }

    public void setClipboardState(ClipboardState clipboardState) {
        this.clipboardState = clipboardState;
    }
}

