/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.compatibility.parser.mt.ast.statements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.compatibility.model.mt.core.Template;
import org.eclipse.acceleo.compatibility.model.mt.statements.Statement;
import org.eclipse.acceleo.internal.compatibility.AcceleoCompatibilityMessages;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.statements.CommentParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.statements.FeatureParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.statements.ForParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.statements.IfParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.statements.TextParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.Region;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateConstants;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateSyntaxException;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TextSearch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatementParser {
    private static final int UNKNOWN_POSITION = -2;
    private static final String NEW_LINE = "\n";

    private StatementParser() {
    }

    public static Region formatTemplate(String buffer, Region range, int nbReturn) {
        Region res = range;
        String text = "";
        int posBegin = -1;
        int posEnd = posBegin - 1;
        if (range.b() == -1 || range.b() > range.e()) {
            res = Region.NOT_FOUND;
        } else {
            text = buffer.substring(range.b(), range.e());
            posBegin = StatementParser.searchFirstValidChar(text);
            if (text.length() > 0) {
                posEnd = StatementParser.searchLastValidChar(text, posBegin, nbReturn);
            }
        }
        if (posEnd >= posBegin) {
            boolean formatWithComment = false;
            String sub = text.substring(posBegin, posEnd);
            if (sub.startsWith(TemplateConstants.getDefault().getCommentBegin()) && sub.indexOf(TemplateConstants.getDefault().getCommentEnd()) > -1) {
                posBegin = text.indexOf(TemplateConstants.getDefault().getCommentEnd(), posBegin) + TemplateConstants.getDefault().getCommentEnd().length();
                formatWithComment = true;
                sub = posEnd > posBegin ? sub.substring(posBegin) : "";
            }
            if (sub.endsWith(TemplateConstants.getDefault().getCommentEnd()) && sub.lastIndexOf(TemplateConstants.getDefault().getCommentBegin(), posEnd) > -1) {
                posEnd = text.lastIndexOf(TemplateConstants.getDefault().getCommentBegin(), posEnd);
                formatWithComment = true;
            }
            res = formatWithComment ? StatementParser.formatTemplate(buffer, new Region(range.b() + posBegin, range.b() + posEnd), nbReturn) : new Region(range.b() + posBegin, range.b() + posEnd);
        }
        return res;
    }

    private static int searchFirstValidChar(String text) {
        int posBegin = text.indexOf(NEW_LINE);
        posBegin = posBegin == -1 || text.substring(0, posBegin).trim().length() > 0 ? 0 : ++posBegin;
        return posBegin;
    }

    private static int searchLastValidChar(String text, int posBegin, int nbReturn) {
        int n = 0;
        int endLine = text.length();
        int posEnd = text.length() - 1;
        boolean stop = false;
        while (!stop) {
            char c = text.charAt(posEnd);
            if (nbReturn == 0 && c == '\n') {
                ++posEnd;
                stop = true;
            } else if (c == '\n' && n < nbReturn) {
                ++n;
                endLine = posEnd;
            } else if (c == '\r') {
                endLine = posEnd;
            } else if (c != ' ' && c != '\t') {
                posEnd = endLine;
                stop = true;
            }
            if (stop) continue;
            if (posEnd > posBegin) {
                --posEnd;
                continue;
            }
            if (nbReturn != 0) {
                posEnd = endLine;
            }
            stop = true;
        }
        return posEnd;
    }

    public static List<Statement> createStatement(int offset, String buffer, Region range, Template template) throws TemplateSyntaxException {
        ArrayList<Statement> block = new ArrayList<Statement>();
        if (buffer != null) {
            int[] pos = new int[4];
            int i = 0;
            while (i < pos.length) {
                pos[i] = -2;
                ++i;
            }
            i = range.b();
            while (i < range.e()) {
                int iTab;
                if (pos[0] != -1 && i > pos[0]) {
                    pos[0] = TextSearch.indexIn(buffer, TemplateConstants.getDefault().getCommentBegin(), new Region(i, range.e())).b();
                }
                if (pos[1] != -1 && i > pos[1]) {
                    pos[1] = TextSearch.indexIn(buffer, TemplateConstants.getDefault().getIfBegin(), new Region(i, range.e())).b();
                }
                if (pos[2] != -1 && i > pos[2]) {
                    pos[2] = TextSearch.indexIn(buffer, TemplateConstants.getDefault().getForBegin(), new Region(i, range.e())).b();
                }
                if (pos[3] != -1 && i > pos[3]) {
                    pos[3] = TextSearch.indexIn(buffer, TemplateConstants.getDefault().getFeatureBegin(), new Region(i, range.e())).b();
                }
                if ((iTab = StatementParser.indexOfMin(pos)) == 0) {
                    i = StatementParser.readStatement(offset, buffer, TemplateConstants.getDefault().getCommentBegin(), TemplateConstants.getDefault().getCommentEnd(), new Region(i, range.e()), block, template);
                    continue;
                }
                if (iTab == 1) {
                    i = StatementParser.readStatement(offset, buffer, TemplateConstants.getDefault().getIfBegin(), TemplateConstants.getDefault().getIfEnd(), new Region(i, range.e()), block, template);
                    continue;
                }
                if (iTab == 2) {
                    i = StatementParser.readStatement(offset, buffer, TemplateConstants.getDefault().getForBegin(), TemplateConstants.getDefault().getForEnd(), new Region(i, range.e()), block, template);
                    continue;
                }
                if (iTab == 3) {
                    i = StatementParser.readStatement(offset, buffer, TemplateConstants.getDefault().getFeatureBegin(), TemplateConstants.getDefault().getFeatureEnd(), new Region(i, range.e()), block, template);
                    continue;
                }
                Region posText = new Region(i, range.e());
                block.add(TextParser.createText(offset, buffer, posText, null));
                i = range.e();
            }
        }
        return block;
    }

    protected static int indexOfMin(int[] pos) {
        int index = -1;
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i < pos.length) {
            if (pos[i] > -1 && pos[i] < min) {
                index = i;
                min = pos[i];
            }
            ++i;
        }
        return index;
    }

    protected static int readStatement(int offset, String buffer, String tagBegin, String tagEnd, Region range, List<Statement> block, Template template) throws TemplateSyntaxException {
        Region end = Region.NOT_FOUND;
        Region begin = TextSearch.indexIn(buffer, tagBegin, range);
        end = tagBegin == TemplateConstants.getDefault().getCommentBegin() ? TextSearch.blockIndexEndIn(buffer, tagBegin, tagEnd, new Region(begin.b(), range.e()), false, null, null) : TextSearch.blockIndexEndIn(buffer, tagBegin, tagEnd, new Region(begin.b(), range.e()), true, null, TemplateConstants.getDefault().getInhibsStatement());
        if (end.b() > -1) {
            boolean untab;
            boolean bl = untab = tagBegin != TemplateConstants.getDefault().getFeatureBegin() && StatementParser.isFirstSignificantOfLine(buffer, begin.b()) && StatementParser.isLastSignificantOfLine(buffer, end.e());
            if (begin.b() > range.b()) {
                Region posText = new Region(range.b(), StatementParser.getIEndPos(buffer, untab, begin.b(), range.b()));
                block.add(TextParser.createText(offset, buffer, posText, null));
            }
            if (tagBegin == TemplateConstants.getDefault().getIfBegin()) {
                block.add(IfParser.createIf(offset, buffer, new Region(begin.e(), end.b()), template));
            }
            if (tagBegin == TemplateConstants.getDefault().getForBegin()) {
                block.add(ForParser.createFor(offset, buffer, new Region(begin.e(), end.b()), template));
            }
            if (tagBegin == TemplateConstants.getDefault().getFeatureBegin()) {
                block.add(FeatureParser.createFeature(offset, buffer, new Region(begin.e(), end.b()), template));
            }
            if (tagBegin == TemplateConstants.getDefault().getCommentBegin()) {
                block.add(CommentParser.createComment(offset, buffer, new Region(begin.e(), end.b()), template));
            }
            if (untab) {
                int iNextLine = TextSearch.indexIn(buffer, NEW_LINE, new Region(end.e(), range.e())).e();
                if (iNextLine == -1) {
                    iNextLine = range.e();
                }
                if (buffer.substring(end.e(), iNextLine).trim().length() == 0) {
                    return iNextLine;
                }
            }
            return end.e();
        }
        block.add(TextParser.createText(offset, buffer, range, null));
        throw new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.UnclosedTag", new Object[]{tagEnd, tagBegin}), template, new Region(begin.b(), range.e()));
    }

    private static int getIEndPos(String buffer, boolean untab, int beginBegin, int rangeBegin) {
        int iEndText = beginBegin;
        if (untab) {
            int iPrevLine = TextSearch.lastIndexIn(buffer, NEW_LINE, rangeBegin, beginBegin, null, null).e();
            if (iPrevLine == -1) {
                iPrevLine = rangeBegin;
            }
            if (buffer.substring(iPrevLine, beginBegin).trim().length() == 0) {
                iEndText = iPrevLine;
            }
        }
        return iEndText;
    }

    private static boolean isFirstSignificantOfLine(String buffer, int index) {
        boolean res = true;
        boolean stop = false;
        int localIndex = index;
        if (localIndex > 0 && localIndex < buffer.length()) {
            --localIndex;
            while (localIndex >= 0 && !stop) {
                char c = buffer.charAt(localIndex);
                if (c == '\n') {
                    res = true;
                    stop = true;
                    continue;
                }
                if (c == ' ' || c == '\t' || c == '\r') {
                    --localIndex;
                    continue;
                }
                res = false;
                stop = true;
            }
        }
        if (stop) {
            return res;
        }
        return true;
    }

    private static boolean isLastSignificantOfLine(String buffer, int index) {
        boolean res = true;
        boolean stop = false;
        int localIndex = index;
        if (localIndex >= 0) {
            while (localIndex < buffer.length() && !stop) {
                char c = buffer.charAt(localIndex);
                if (c == '\n') {
                    res = true;
                    stop = true;
                    continue;
                }
                if (c == ' ' || c == '\t' || c == '\r') {
                    ++localIndex;
                    continue;
                }
                res = false;
                stop = true;
            }
        }
        if (stop) {
            return res;
        }
        return true;
    }
}

