/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references;

import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferencesSearchQuery;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class ReferencesSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private ReferencesSearchQuery query;

    public ReferencesSearchResult(ReferencesSearchQuery query) {
        this.query = query;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.getMissingImageDescriptor();
    }

    public String getLabel() {
        return AcceleoUIMessages.getString("AcceleoReferencesSearch.Result.Label");
    }

    public ISearchQuery getQuery() {
        return this.query;
    }

    public String getTooltip() {
        return AcceleoUIMessages.getString("AcceleoReferencesSearch.Result.Tooltip");
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IFile file = null;
        if (editor.getEditorInput() instanceof IFileEditorInput) {
            file = ((IFileEditorInput)editor.getEditorInput()).getFile();
        }
        return result.getMatches(file);
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        if (editor instanceof AcceleoEditor && match.getElement() instanceof IFile) {
            AcceleoEditor acceleoEditor = (AcceleoEditor)editor;
            IFile matchedFile = (IFile)match.getElement();
            return acceleoEditor.getFile().equals((Object)matchedFile);
        }
        return false;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        return result.getMatches((Object)file);
    }

    public IFile getFile(Object element) {
        if (element instanceof IFile) {
            return (IFile)element;
        }
        return null;
    }
}

