/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.xtend;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.xtend.expression.AbstractExpressionsUsingWorkflowComponent;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.middleend.LanguageContributor;
import org.eclipse.xtend.middleend.xtend.XtendBackendFacade;
import org.eclipse.xtend.middleend.xtend.plugin.OldXtendRegistryFactory;

public class XtendComponent
extends AbstractExpressionsUsingWorkflowComponent {
    private String _invokeExpression;
    String _extensionFile = null;
    private String _expression = null;
    private String _outputSlot = "default";
    private String _fileEncoding = null;

    public XtendComponent() {
        if (LanguageContributor.INSTANCE.getLanguageContributionByName("Xtend") == null) {
            LanguageContributor.INSTANCE.addLanguageContribution(OldXtendRegistryFactory.class);
        }
    }

    public void setFileEncoding(String fileEncoding) {
        this._fileEncoding = fileEncoding;
    }

    public String getLogMessage() {
        return "executing '" + this._invokeExpression + "'";
    }

    public void setInvoke(String invoke) {
        this._invokeExpression = invoke;
        int i = invoke.lastIndexOf("::");
        if (i != -1) {
            this._extensionFile = invoke.substring(0, i);
            this._expression = invoke.substring(i + "::".length());
        } else {
            this._expression = invoke;
        }
    }

    public void setOutputSlot(String outputSlot) {
        this._outputSlot = outputSlot;
    }

    public void invokeInternal2(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        if (!this.extensionFileExists()) {
            issues.addError("Cannot find extension file: " + this._extensionFile);
            return;
        }
        HashMap<String, Object> localVars = new HashMap<String, Object>();
        String[] stringArray = ctx.getSlotNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String slotName = stringArray[n2];
            localVars.put(slotName, ctx.get(slotName));
            ++n2;
        }
        HashMap<String, Object> globalVars = new HashMap<String, Object>();
        Set varNames = this.getGlobalVars(ctx).keySet();
        for (String varName : varNames) {
            globalVars.put(varName, ((Variable)this.getGlobalVars(ctx).get(varName)).getValue());
        }
        Object result = XtendBackendFacade.evaluateExpression(this._expression, this._extensionFile, this._fileEncoding, this.metaModels, localVars, globalVars, this._advice);
        ctx.set(this._outputSlot, result);
    }

    private boolean extensionFileExists() {
        InputStream is = null;
        try {
            is = ResourceLoaderFactory.createResourceLoader().getResourceAsStream(String.valueOf(this._extensionFile.replace("::", "/")) + "." + "ext");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return is != null;
    }

    public void checkConfigurationInternal(Issues issues) {
        String compPrefix;
        super.checkConfigurationInternal(issues);
        String string = compPrefix = this.getId() != null ? String.valueOf(this.getId()) + ": " : "";
        if (this._invokeExpression == null || this._invokeExpression.trim().length() == 0) {
            issues.addError(String.valueOf(compPrefix) + "Property 'invoke' not specified.");
            return;
        }
        if (this._extensionFile == null) {
            issues.addError(String.valueOf(compPrefix) + "Error parsing property 'invoke': Could not extract name of the extension file.");
            return;
        }
        if (!this.extensionFileExists() || this._expression == null) {
            issues.addError(String.valueOf(compPrefix) + "Property 'invoke' not specified properly. Extension file '" + this._extensionFile + "' not found.");
            return;
        }
        if (this._expression == null) {
            issues.addError(String.valueOf(compPrefix) + "Error parsing property 'invoke': Could not extract the expression to invoke in extension file '" + this._extensionFile + "'.");
            return;
        }
    }
}

