/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.types.builtin;

import java.lang.reflect.Method;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.types.AbstractProperty;
import org.eclipse.xtend.backend.util.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BuiltinProperty
extends AbstractProperty {
    private final Method _getter;
    private final Method _setter;

    public BuiltinProperty(BackendType owner, String name, Method getter, Method setter) {
        super(owner, BuiltinProperty.getJavaClassForProperty(getter, setter), name, getter != null, setter != null);
        this._getter = getter;
        this._setter = setter;
    }

    private static Class<?> getJavaClassForProperty(Method getter, Method setter) {
        if (getter != null) {
            return getter.getReturnType();
        }
        return setter.getParameterTypes()[0];
    }

    @Override
    public Object getRaw(ExecutionContext ctx, Object o) {
        try {
            return this._getter.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
            return null;
        }
    }

    @Override
    public void setRaw(ExecutionContext ctx, Object o, Object newValue) {
        if (this._setter == null) {
            super.setRaw(ctx, o, newValue);
        }
        try {
            this._setter.invoke(o, newValue);
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
        }
    }

    @Override
    public BackendType getType(BackendTypesystem ts) {
        return ts.findType(BuiltinProperty.getJavaClassForProperty(this._getter, this._setter));
    }
}

