/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.expr;

import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.SourcePos;

public final class AndExpression
extends ExpressionBase {
    private final ExpressionBase _left;
    private final ExpressionBase _right;

    public AndExpression(ExpressionBase left, ExpressionBase right, SourcePos sourcePos) {
        super(sourcePos);
        this._left = left;
        this._right = right;
    }

    public ExpressionBase getLeft() {
        return this._left;
    }

    public ExpressionBase getRight() {
        return this._right;
    }

    protected Object evaluateInternal(ExecutionContext ctx) {
        Object left = this._left.evaluate(ctx);
        if (left == null) {
            ctx.logNullDeRef(this.getPos());
            return null;
        }
        if (Boolean.FALSE.equals(left)) {
            return Boolean.FALSE;
        }
        Object right = this._right.evaluate(ctx);
        if (right == null) {
            ctx.logNullDeRef(this.getPos());
            return null;
        }
        return right;
    }
}

