/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.functions.java.internal;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import org.eclipse.xtend.backend.functions.java.internal.JavaBuiltinConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayConverter
implements JavaBuiltinConverter {
    private final Class<?> _componentType;

    public ArrayConverter(Class<?> componentType) {
        this._componentType = componentType;
    }

    @Override
    public Object backendToJava(Object o) {
        if (o == null) {
            return null;
        }
        List l = (List)o;
        Object[] result = (Object[])Array.newInstance(this._componentType, l.size());
        return l.toArray(result);
    }

    @Override
    public Object javaToBackend(Object o) {
        if (o == null) {
            return null;
        }
        return Arrays.asList((Object[])o);
    }
}

