/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.types.java;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.functions.java.internal.JavaBuiltinConverterFactory;
import org.eclipse.xtend.backend.types.java.JavaBeansType;
import org.eclipse.xtend.backend.util.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaBeansTypesystem
implements BackendTypesystem {
    private BackendTypesystem _rootTypesystem = null;
    private Map<Class<?>, JavaBeansType> _cache = new HashMap();
    public static final String UNIQUE_REPRESENTATION_PREFIX = "{javabean}";

    @Override
    public BackendType findType(Class<?> cls) {
        if (cls == Object.class) {
            return null;
        }
        BackendType nonstandardBuiltin = JavaBuiltinConverterFactory.getTypeForAdditionalBuiltin(cls);
        if (nonstandardBuiltin != null) {
            return nonstandardBuiltin;
        }
        if (!this.matchesScope(cls)) {
            return null;
        }
        JavaBeansType result = this._cache.get(cls);
        if (result != null) {
            return result;
        }
        result = new JavaBeansType(cls, this);
        this._cache.put(cls, result);
        result.init(this);
        return result;
    }

    @Override
    public BackendType findType(Object o) {
        if (o == null) {
            return null;
        }
        return this.findType(o.getClass());
    }

    @Override
    public BackendType findType(String uniqueRepresentation) {
        if (!uniqueRepresentation.startsWith(UNIQUE_REPRESENTATION_PREFIX)) {
            return null;
        }
        try {
            return this.findType(Class.forName(uniqueRepresentation.substring(UNIQUE_REPRESENTATION_PREFIX.length())));
        }
        catch (ClassNotFoundException e) {
            ErrorHandler.handle(e);
            return null;
        }
    }

    public abstract boolean matchesScope(Class<?> var1);

    @Override
    public BackendTypesystem getRootTypesystem() {
        return this._rootTypesystem;
    }

    @Override
    public void setRootTypesystem(BackendTypesystem ts) {
        this._rootTypesystem = ts;
    }
}

