/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.common.codegen.ui.handlers;

import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.languages.common.base.ClassUtils;
import org.eclipse.papyrus.designer.languages.common.codegen.ui.ChooseGenerator;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.LanguageCodegen;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.GeneratorHint;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;

public class GenerateCodeHandler
extends CmdHandler {
    private static final String DEPLOYMENT_PLAN = "Deployment::DeploymentPlan";
    private static final String EXECUTE_TRAFO_CHAIN = "Transformation::ExecuteTrafoChain";

    public boolean isEnabled() {
        this.updateSelectedEObject();
        if (this.selectedEObject instanceof Package || this.selectedEObject instanceof Classifier) {
            boolean deploymentPlanOrTrafoChain;
            boolean bl = deploymentPlanOrTrafoChain = StereotypeUtil.isApplied((Element)((Element)this.selectedEObject), (String)EXECUTE_TRAFO_CHAIN) || StereotypeUtil.isApplied((Element)((Element)this.selectedEObject), (String)DEPLOYMENT_PLAN);
            if (!deploymentPlanOrTrafoChain) {
                URI uri = this.selectedEObject.eResource().getURI();
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                if (uri.segmentCount() < 2) {
                    return false;
                }
                IProject modelProject = root.getProject(URI.decode((String)uri.segment(1)));
                return modelProject.exists();
            }
        }
        return false;
    }

    public void generate(ILangCodegen codeGen, IProject genProject, PackageableElement pe, EList<PackageableElement> alreadyHandled, boolean recurse) {
        Package owningPackage;
        alreadyHandled.add((Object)pe);
        codeGen.generateCode(genProject, pe, null);
        if (pe instanceof Package && recurse) {
            for (PackageableElement subPe : ((Package)pe).getPackagedElements()) {
                if (alreadyHandled.contains((Object)subPe)) continue;
                this.generate(codeGen, genProject, subPe, alreadyHandled, recurse);
            }
        }
        if (pe instanceof Classifier) {
            EList requiredClassifiers = ClassUtils.requiredClassifiers((Classifier)((Classifier)pe));
            for (Classifier requiredClassifier : requiredClassifiers) {
                if (alreadyHandled.contains((Object)requiredClassifier)) continue;
                this.generate(codeGen, genProject, (PackageableElement)requiredClassifier, alreadyHandled, false);
            }
        }
        if ((owningPackage = pe.getNearestPackage()) != null && owningPackage != pe && !alreadyHandled.contains((Object)owningPackage)) {
            this.generate(codeGen, genProject, (PackageableElement)owningPackage, alreadyHandled, false);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.selectedEObject instanceof PackageableElement) {
            PackageableElement pe = (PackageableElement)this.selectedEObject;
            GeneratorHint hint = DepUtils.getGeneratorHintFromElement((Element)pe);
            ILangCodegen codeGen = null;
            codeGen = hint == null ? ChooseGenerator.choose(Pattern.compile(".*"), pe) : LanguageCodegen.getGenerator((String)hint.getLanguage().getBase_Class().getName(), (String)hint.getGeneratorID());
            if (codeGen != null) {
                IProject genProject = codeGen.getTargetProject(pe, true);
                this.generate(codeGen, genProject, pe, (EList<PackageableElement>)new BasicEList(), true);
            }
        }
        return null;
    }
}

