/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine;

import com.google.common.base.Objects;
import java.util.function.Consumer;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Include;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.IncludeUtils;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.preferences.MonitoringPreferencesUtil;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.SM2ClassesTransformationCore;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.Monitored;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class MonitoringTransformation {
    public static final String MONITOR_SOCKET_NAME = "monitorSocket";
    public static final String MONITOR_ADDRESS_NAME = "monitorAddress";
    private SM2ClassesTransformationCore core;
    private Class superContext;
    private boolean isMonitored;

    public MonitoringTransformation(SM2ClassesTransformationCore core) {
        this.core = core;
        this.superContext = core.superContext;
        this.isMonitored = MonitoringPreferencesUtil.getEnabled();
    }

    public void appendInclude() {
        if (this.isMonitored) {
            Include include = (Include)UMLUtil.getStereotypeApplication((Element)this.superContext, Include.class);
            if (include != null) {
                boolean _not;
                String header = include.getHeader();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("#include <netinet/in.h>");
                boolean _contains = header.contains((CharSequence)_builder);
                boolean bl = _not = !_contains;
                if (_not) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("#include <netinet/in.h>");
                    IncludeUtils.appendIncludeHeader(this.superContext, _builder_1.toString());
                }
            }
            if (include != null) {
                boolean _not_3;
                boolean _not_2;
                boolean _not_1;
                String body = ((Include)UMLUtil.getStereotypeApplication((Element)this.superContext, Include.class)).getHeader();
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("#include <unistd.h>");
                boolean _contains_1 = body.contains((CharSequence)_builder_2);
                boolean bl = _not_1 = !_contains_1;
                if (_not_1) {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("#include <unistd.h>");
                    IncludeUtils.appendIncludeBody(this.superContext, _builder_3.toString());
                }
                StringConcatenation _builder_4 = new StringConcatenation();
                _builder_4.append("#include <sys/socket.h>");
                boolean _contains_2 = body.contains((CharSequence)_builder_4);
                boolean bl2 = _not_2 = !_contains_2;
                if (_not_2) {
                    StringConcatenation _builder_5 = new StringConcatenation();
                    _builder_5.append("#include <sys/socket.h>");
                    IncludeUtils.appendIncludeBody(this.superContext, _builder_5.toString());
                }
                StringConcatenation _builder_6 = new StringConcatenation();
                _builder_6.append("#include <arpa/inet.h>");
                boolean _contains_3 = body.contains((CharSequence)_builder_6);
                boolean bl3 = _not_3 = !_contains_3;
                if (_not_3) {
                    StringConcatenation _builder_7 = new StringConcatenation();
                    _builder_7.append("#include <arpa/inet.h>");
                    IncludeUtils.appendIncludeBody(this.superContext, _builder_7.toString());
                }
            }
        }
    }

    public Property createMonitorAttributes() {
        Property _xifexpression = null;
        if (this.isMonitored) {
            Property _xblockexpression = null;
            this.superContext.createOwnedAttribute(MONITOR_SOCKET_NAME, this.core.intType);
            _xifexpression = _xblockexpression = this.superContext.createOwnedAttribute(MONITOR_ADDRESS_NAME, this.core.sockAddrInType);
        }
        return _xifexpression;
    }

    public OpaqueBehavior createDestructor() {
        OpaqueBehavior _xifexpression = null;
        if (this.isMonitored) {
            OpaqueBehavior _xblockexpression = null;
            Functions.Function1<Operation, Boolean> _function = new Functions.Function1<Operation, Boolean>(){

                public Boolean apply(Operation it) {
                    return StereotypeUtil.isApplied((Element)it, (String)"StandardProfile::Destroy") && Objects.equal((Object)it.getName(), (Object)MonitoringTransformation.this.superContext.getName());
                }
            };
            Iterable sourceDestructors = IterableExtensions.filter((Iterable)this.superContext.getOwnedOperations(), (Functions.Function1)_function);
            Functions.Function1<Operation, Operation> _function_1 = new Functions.Function1<Operation, Operation>(){

                public Operation apply(Operation it) {
                    return it;
                }
            };
            Iterable targetDestructors = IterableExtensions.map((Iterable)sourceDestructors, (Functions.Function1)_function_1);
            OpaqueBehavior _xifexpression_1 = null;
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)targetDestructors);
            if (_isEmpty) {
                OpaqueBehavior _xblockexpression_1 = null;
                Operation destructor = this.superContext.createOwnedOperation(this.superContext.getName(), null, null);
                StereotypeUtil.apply((Element)destructor, (String)"StandardProfile::Destroy");
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("close(");
                _builder.append(MONITOR_SOCKET_NAME);
                _builder.append(");");
                _xifexpression_1 = _xblockexpression_1 = this.core.createOpaqueBehavior(this.superContext, destructor, _builder.toString());
            } else {
                Consumer<Operation> _function_2 = new Consumer<Operation>(){

                    @Override
                    public void accept(Operation it) {
                        Behavior _head = (Behavior)IterableExtensions.head((Iterable)it.getMethods());
                        OpaqueBehavior opaque = (OpaqueBehavior)_head;
                        if (opaque != null) {
                            String body = (String)opaque.getBodies().get(0);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append(body);
                            _builder.newLineIfNotEmpty();
                            _builder.append("close(");
                            _builder.append(MonitoringTransformation.MONITOR_SOCKET_NAME);
                            _builder.append(");");
                            MonitoringTransformation.this.core.createOpaqueBehavior(MonitoringTransformation.this.superContext, it, _builder.toString());
                        } else {
                            StringConcatenation _builder_1 = new StringConcatenation();
                            _builder_1.append("close(");
                            _builder_1.append(MonitoringTransformation.MONITOR_SOCKET_NAME);
                            _builder_1.append(");");
                            MonitoringTransformation.this.core.createOpaqueBehavior(MonitoringTransformation.this.superContext, it, _builder_1.toString());
                        }
                    }
                };
                targetDestructors.forEach(_function_2);
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public OpaqueBehavior createConstructor() {
        OpaqueBehavior _xifexpression = null;
        if (this.isMonitored) {
            OpaqueBehavior _xblockexpression = null;
            Functions.Function1<Operation, Boolean> _function = new Functions.Function1<Operation, Boolean>(){

                public Boolean apply(Operation it) {
                    return StereotypeUtil.isApplied((Element)it, (String)"StandardProfile::Create") && Objects.equal((Object)it.getName(), (Object)MonitoringTransformation.this.superContext.getName());
                }
            };
            Iterable sourceContructors = IterableExtensions.filter((Iterable)this.superContext.getOwnedOperations(), (Functions.Function1)_function);
            Functions.Function1<Operation, Operation> _function_1 = new Functions.Function1<Operation, Operation>(){

                public Operation apply(Operation it) {
                    return it;
                }
            };
            Iterable targetContructors = IterableExtensions.map((Iterable)sourceContructors, (Functions.Function1)_function_1);
            OpaqueBehavior _xifexpression_1 = null;
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)targetContructors);
            if (_isEmpty) {
                OpaqueBehavior _xblockexpression_1 = null;
                Operation constructor = this.superContext.createOwnedOperation(this.superContext.getName(), null, null);
                StereotypeUtil.apply((Element)constructor, (String)"StandardProfile::Create");
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(MONITOR_SOCKET_NAME);
                _builder.append(" = socket(AF_INET, SOCK_DGRAM, 17);");
                _builder.newLineIfNotEmpty();
                _builder.append(MONITOR_ADDRESS_NAME);
                _builder.append(".sin_addr.s_addr = inet_addr(\"");
                String _ipAddress = MonitoringPreferencesUtil.getIpAddress();
                _builder.append(_ipAddress);
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
                _builder.append(MONITOR_ADDRESS_NAME);
                _builder.append(".sin_family = AF_INET;");
                _builder.newLineIfNotEmpty();
                _builder.append(MONITOR_ADDRESS_NAME);
                _builder.append(".sin_port = htons(");
                int _port = MonitoringPreferencesUtil.getPort();
                _builder.append((Object)_port);
                _builder.append(");");
                _xifexpression_1 = _xblockexpression_1 = this.core.createOpaqueBehavior(this.superContext, constructor, _builder.toString());
            } else {
                Consumer<Operation> _function_2 = new Consumer<Operation>(){

                    @Override
                    public void accept(Operation it) {
                        Behavior _head = (Behavior)IterableExtensions.head((Iterable)it.getMethods());
                        OpaqueBehavior opaque = (OpaqueBehavior)_head;
                        if (opaque != null) {
                            String body = (String)opaque.getBodies().get(0);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append(MonitoringTransformation.MONITOR_SOCKET_NAME);
                            _builder.append(" = socket(AF_INET, SOCK_DGRAM, 17);");
                            _builder.newLineIfNotEmpty();
                            _builder.append(MonitoringTransformation.MONITOR_ADDRESS_NAME);
                            _builder.append(".sin_addr.s_addr = inet_addr(\"");
                            String _ipAddress = MonitoringPreferencesUtil.getIpAddress();
                            _builder.append(_ipAddress);
                            _builder.append("\");");
                            _builder.newLineIfNotEmpty();
                            _builder.append(MonitoringTransformation.MONITOR_ADDRESS_NAME);
                            _builder.append(".sin_family = AF_INET;");
                            _builder.newLineIfNotEmpty();
                            _builder.append(MonitoringTransformation.MONITOR_ADDRESS_NAME);
                            _builder.append(".sin_port = htons(");
                            int _port = MonitoringPreferencesUtil.getPort();
                            _builder.append((Object)_port);
                            _builder.append(");");
                            _builder.newLineIfNotEmpty();
                            _builder.append(body);
                            MonitoringTransformation.this.core.createOpaqueBehavior(MonitoringTransformation.this.superContext, it, _builder.toString());
                        } else {
                            StringConcatenation _builder_1 = new StringConcatenation();
                            _builder_1.append(MonitoringTransformation.MONITOR_SOCKET_NAME);
                            _builder_1.append(" = socket(AF_INET, SOCK_DGRAM, 17);");
                            _builder_1.newLineIfNotEmpty();
                            _builder_1.append(MonitoringTransformation.MONITOR_ADDRESS_NAME);
                            _builder_1.append(".sin_addr.s_addr = inet_addr(\"");
                            String _ipAddress_1 = MonitoringPreferencesUtil.getIpAddress();
                            _builder_1.append(_ipAddress_1);
                            _builder_1.append("\");");
                            _builder_1.newLineIfNotEmpty();
                            _builder_1.append(MonitoringTransformation.MONITOR_ADDRESS_NAME);
                            _builder_1.append(".sin_family = AF_INET;");
                            _builder_1.newLineIfNotEmpty();
                            _builder_1.append(MonitoringTransformation.MONITOR_ADDRESS_NAME);
                            _builder_1.append(".sin_port = htons(");
                            int _port_1 = MonitoringPreferencesUtil.getPort();
                            _builder_1.append((Object)_port_1);
                            _builder_1.append(");");
                            MonitoringTransformation.this.core.createOpaqueBehavior(MonitoringTransformation.this.superContext, it, _builder_1.toString());
                        }
                    }
                };
                targetContructors.forEach(_function_2);
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public String generateTransitionCode(Transition t) {
        if (this.isMonitored) {
            boolean _contains;
            boolean _not;
            Monitored monitoredStereotype;
            boolean monitorThis = true;
            StateMachine stateMachine = t.containingStateMachine();
            if (stateMachine != null && (monitoredStereotype = (Monitored)UMLUtil.getStereotypeApplication((Element)stateMachine, Monitored.class)) != null && (monitorThis = monitoredStereotype.isGenerateMonitoringCode()) && (monitorThis = (_not = !(_contains = monitoredStereotype.getGenerateExclude().contains((Object)t)))) && !monitoredStereotype.getGenerateExclusivelyInclude().isEmpty()) {
                monitorThis = monitoredStereotype.getGenerateExclusivelyInclude().contains((Object)t);
            }
            if (monitorThis && t.getQualifiedName() != null && !t.getQualifiedName().isEmpty()) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("if (");
                _builder.append(MONITOR_SOCKET_NAME);
                _builder.append(" != -1) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("sendto(");
                _builder.append(MONITOR_SOCKET_NAME, "\t");
                _builder.append(", \"TRANSITION|");
                String _qualifiedName = t.getQualifiedName();
                _builder.append(_qualifiedName, "\t");
                _builder.append("\", sizeof(\"TRANSITION|");
                String _qualifiedName_1 = t.getQualifiedName();
                _builder.append(_qualifiedName_1, "\t");
                _builder.append("\"), 0, reinterpret_cast<const sockaddr*>(&");
                _builder.append(MONITOR_ADDRESS_NAME, "\t");
                _builder.append("), sizeof(");
                _builder.append(MONITOR_ADDRESS_NAME, "\t");
                _builder.append("));");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
                return _builder.toString();
            }
        }
        return "";
    }
}

