package org.eclipse.papyrus.designer.transformation.library.xtend;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.transformation.base.utils.OperationUtils;
import org.eclipse.papyrus.designer.transformation.library.xtend.CppUtils;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class Marshalling {
  public static CharSequence marshall(final Operation operation) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// now marshall in and inout parameters via ASN.1");
    _builder.newLine();
    {
      EList<Parameter> _parametersInInout = OperationUtils.parametersInInout(operation);
      for(final Parameter parameter : _parametersInInout) {
        CharSequence _marshall = Marshalling.marshall(parameter);
        _builder.append(_marshall);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public static CharSequence marshallOutInout(final Operation operation) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// now marshall out and inout parameters via ASN.1");
    _builder.newLine();
    {
      EList<Parameter> _parametersOutInout = OperationUtils.parametersOutInout(operation);
      for(final Parameter parameter : _parametersOutInout) {
        CharSequence _marshall = Marshalling.marshall(parameter);
        _builder.append(_marshall);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public static CharSequence marshall(final Parameter parameter) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _cppType = CppUtils.cppType(parameter.getType());
    _builder.append(_cppType, "\t");
    _builder.append(" varName_ASN = ");
    String _name = parameter.getName();
    _builder.append(_name, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("BEncAsnContent (&pBuffer, &varName_ASN);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public static CharSequence unmarshall(final Operation operation) {
    StringConcatenation _builder = new StringConcatenation();
    {
      List<Parameter> _reverse = ListExtensions.<Parameter>reverse(OperationUtils.parametersInInout(operation));
      for(final Parameter parameter : _reverse) {
        CharSequence _unmarshall = Marshalling.unmarshall(parameter);
        _builder.append(_unmarshall);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public static CharSequence unmarshallOutInout(final Operation operation) {
    StringConcatenation _builder = new StringConcatenation();
    {
      List<Parameter> _reverse = ListExtensions.<Parameter>reverse(OperationUtils.parametersOutInout(operation));
      for(final Parameter parameter : _reverse) {
        CharSequence _unmarshall = Marshalling.unmarshall(parameter);
        _builder.append(_unmarshall);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public static CharSequence unmarshall(final Parameter parameter) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _cppType = CppUtils.cppType(parameter.getType());
    _builder.append(_cppType);
    _builder.append(" ");
    String _name = parameter.getName();
    _builder.append(_name);
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _cppType_1 = CppUtils.cppType(parameter.getType());
    _builder.append(_cppType_1, "\t");
    _builder.append(" varName_ASN;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("BDecAsnContent (&pBuffer, &varName_ASN);");
    _builder.newLine();
    _builder.append("\t");
    String _name_1 = parameter.getName();
    _builder.append(_name_1, "\t");
    _builder.append(" = varName_ASN;");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * Used in a union that contains a struct for each operation. This allows for
   * a parameter marshalling in which ...
   */
  public static CharSequence cppParameterStorage(final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<Operation> _ownedOperations = clazz.getOwnedOperations();
      for(final Operation operation : _ownedOperations) {
        _builder.append("struct Op_");
        String _name = operation.getName();
        _builder.append(_name);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        {
          EList<Parameter> _ownedParameters = operation.getOwnedParameters();
          for(final Parameter parameter : _ownedParameters) {
            _builder.append("\t");
            CharSequence _cppType = CppUtils.cppType(parameter.getType());
            _builder.append(_cppType, "\t");
            _builder.append(" ");
            String _name_1 = parameter.getName();
            _builder.append(_name_1, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("} op_");
        String _name_2 = operation.getName();
        _builder.append(_name_2);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
}
