/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.CDefinitions;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.SM2ClassesTransformationCore;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.SMCodeGeneratorConstants;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.TransformationUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class PseudostateGenerator {
    @Extension
    protected CDefinitions cdefs;
    private SM2ClassesTransformationCore core;
    private Class superContext;
    private Package targetPack;

    public PseudostateGenerator(SM2ClassesTransformationCore core) {
        Package _targetPacket;
        this.core = core;
        this.superContext = core.superContext;
        this.targetPack = _targetPacket = core.getTargetPacket();
        this.cdefs = core.cdefs;
    }

    public String generatePseudo(Pseudostate p) {
        StringConcatenation _builder = new StringConcatenation();
        String ret = _builder.toString();
        PseudostateKind _kind = p.getKind();
        if (_kind != null) {
            switch (_kind) {
                case JUNCTION_LITERAL: {
                    String _generateJunction;
                    ret = _generateJunction = this.generateJunction(p);
                    break;
                }
                case JOIN_LITERAL: {
                    String _generateJoin;
                    ret = _generateJoin = this.generateJoin(p);
                    break;
                }
                case FORK_LITERAL: {
                    String _generateFork;
                    ret = _generateFork = this.generateFork(p);
                    break;
                }
                case CHOICE_LITERAL: {
                    String _generateChoice;
                    ret = _generateChoice = this.generateChoice(p);
                    break;
                }
                case SHALLOW_HISTORY_LITERAL: {
                    String _generateShallowHistory;
                    ret = _generateShallowHistory = this.generateShallowHistory(p);
                    break;
                }
                case DEEP_HISTORY_LITERAL: {
                    String _generateDeepHistory;
                    ret = _generateDeepHistory = this.generateDeepHistory(p);
                    break;
                }
                case ENTRY_POINT_LITERAL: {
                    String _generateEntryPoint;
                    ret = _generateEntryPoint = this.generateEntryPoint(p);
                    break;
                }
                case EXIT_POINT_LITERAL: {
                    String _generateExitPoint;
                    ret = _generateExitPoint = this.generateExitPoint(p);
                    break;
                }
                case INITIAL_LITERAL: {
                    break;
                }
                case TERMINATE_LITERAL: {
                    break;
                }
            }
        }
        return ret;
    }

    public String generateJunction(Pseudostate p) {
        StringConcatenation _builder = new StringConcatenation();
        EList _outgoings = p.getOutgoings();
        boolean _hasElements = false;
        for (Transition out : _outgoings) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" else ", "");
            }
            _builder.append("if (");
            String _name = p.getName();
            _builder.append(_name, "");
            _builder.append(" == ");
            EList _outgoings_1 = p.getOutgoings();
            int _indexOf = _outgoings_1.indexOf((Object)out);
            _builder.append((Object)_indexOf, "");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            Vertex _target = out.getTarget();
            String _generateBetweenVertex = this.generateBetweenVertex((Vertex)p, _target, out);
            _builder.append(_generateBetweenVertex, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        String ret = _builder.toString();
        return ret;
    }

    public String generateBetweenVertex(Vertex v1, Vertex v2, Transition t) {
        ArrayList<Vertex> exits = new ArrayList<Vertex>();
        ArrayList<Vertex> enters = new ArrayList<Vertex>();
        StringConcatenation _builder = new StringConcatenation();
        String ret = _builder.toString();
        this.core.eventTransform.calculateExitsEnters(t, exits, enters);
        Vertex cpEx = (Vertex)IterableExtensions.last(exits);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append(ret, "");
        _builder_1.newLineIfNotEmpty();
        if (cpEx instanceof State) {
            String _generateExitingSubStates = this.core.generateExitingSubStates((State)cpEx, true);
            _builder_1.append(_generateExitingSubStates, "");
            _builder_1.newLineIfNotEmpty();
        }
        String _transitionEffect = TransformationUtil.getTransitionEffect(t);
        _builder_1.append(_transitionEffect, "");
        ret = _builder_1.toString();
        Vertex cpEn = (Vertex)IterableExtensions.last(enters);
        Vertex innermost = (Vertex)IterableExtensions.head(enters);
        if (innermost instanceof State) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append(ret, "");
            _builder_2.newLineIfNotEmpty();
            if (innermost instanceof FinalState) {
                Region _container = ((FinalState)innermost).getContainer();
                boolean _equals = Objects.equal((Object)_container, (Object)this.core.topRegion);
                if (_equals) {
                    _builder_2.append(SMCodeGeneratorConstants.ACTIVE_ROOT_STATE_ID, "");
                    _builder_2.append(" = ");
                    _builder_2.append(SMCodeGeneratorConstants.STATE_MAX, "");
                    _builder_2.append(";");
                    _builder_2.newLineIfNotEmpty();
                } else {
                    _builder_2.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                    _builder_2.append("[");
                    _builder_2.append(SMCodeGeneratorConstants.ACTIVE_ROOT_STATE_ID, "");
                    _builder_2.append("].");
                    _builder_2.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                    _builder_2.append("[");
                    Region _container_1 = ((FinalState)innermost).getContainer();
                    State _state = _container_1.getState();
                    EList _regions = _state.getRegions();
                    Region _container_2 = ((FinalState)innermost).getContainer();
                    int _indexOf = _regions.indexOf((Object)_container_2);
                    _builder_2.append((Object)_indexOf, "");
                    _builder_2.append("] = ");
                    _builder_2.append(SMCodeGeneratorConstants.STATE_MAX, "");
                    _builder_2.append(";");
                    _builder_2.newLineIfNotEmpty();
                    String _generateCompletionCall = this.core.generateCompletionCall((State)innermost);
                    _builder_2.append(_generateCompletionCall, "");
                    _builder_2.newLineIfNotEmpty();
                }
            } else {
                String _generateEnteringOnSubVertex = this.core.generateEnteringOnSubVertex((State)cpEn, innermost);
                _builder_2.append(_generateEnteringOnSubVertex, "");
                _builder_2.newLineIfNotEmpty();
                _builder_2.append("\t\t\t");
            }
            ret = _builder_2.toString();
        } else {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append(ret, "");
            _builder_3.newLineIfNotEmpty();
            if (cpEn instanceof State) {
                String _generateEnteringOnSubVertex_1 = this.core.generateEnteringOnSubVertex((State)cpEn, innermost);
                _builder_3.append(_generateEnteringOnSubVertex_1, "");
                _builder_3.newLineIfNotEmpty();
            } else {
                String _generatePseudo = this.generatePseudo((Pseudostate)innermost);
                _builder_3.append(_generatePseudo, "");
                _builder_3.newLineIfNotEmpty();
                _builder_3.append("\t\t\t");
            }
            ret = _builder_3.toString();
        }
        return ret;
    }

    public String generateDeepHistory(Pseudostate p) {
        boolean _greaterThan;
        Region _container = p.getContainer();
        State _state = _container.getState();
        EList _regions = _state.getRegions();
        Region _container_1 = p.getContainer();
        int regionIndex = _regions.indexOf((Object)_container_1);
        Region _container_2 = p.getContainer();
        EList _subvertices = _container_2.getSubvertices();
        Iterable _filter = Iterables.filter((Iterable)_subvertices, State.class);
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                boolean _isComposite;
                boolean _and = false;
                boolean _not = !(it instanceof FinalState);
                _and = !_not ? false : (_isComposite = it.isComposite());
                return _and;
            }
        };
        Iterable subCompositeStates = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
        Region _container_3 = p.getContainer();
        State _state_1 = _container_3.getState();
        String _name = _state_1.getName();
        String _upperCase = _name.toUpperCase();
        String parentId = String.valueOf(_upperCase) + "_ID";
        Region _container_4 = p.getContainer();
        EList _subvertices_1 = _container_4.getSubvertices();
        Iterable _filter_1 = Iterables.filter((Iterable)_subvertices_1, State.class);
        Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                boolean _isComposite;
                boolean _not_1;
                boolean _not;
                boolean _and = false;
                boolean bl = _not = !(it instanceof FinalState);
                _and = !_not ? false : (_not_1 = !(_isComposite = it.isComposite()));
                return _and;
            }
        };
        Iterable subAtomics = IterableExtensions.filter((Iterable)_filter_1, (Functions.Function1)_function_1);
        Functions.Function1<State, Boolean> _function_2 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                List<TimeEvent> _get_1;
                boolean _isEmpty;
                boolean _not;
                boolean _notEquals;
                boolean _and = false;
                List<TimeEvent> _get = ((PseudostateGenerator)PseudostateGenerator.this).core.states2TimeEvents.get(it);
                boolean bl = _notEquals = !Objects.equal(_get, null);
                _and = !_notEquals ? false : (_not = !(_isEmpty = (_get_1 = ((PseudostateGenerator)PseudostateGenerator.this).core.states2TimeEvents.get(it)).isEmpty()));
                return _and;
            }
        };
        Iterable atomicsWithTimeEvent = IterableExtensions.filter((Iterable)subAtomics, (Functions.Function1)_function_2);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("unsigned int ");
        Region _container_5 = p.getContainer();
        String _deepHistoryVariableName = this.getDeepHistoryVariableName(_container_5, p);
        _builder.append(_deepHistoryVariableName, "");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("if (");
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
        _builder.append("[");
        _builder.append(parentId, "");
        _builder.append("].");
        _builder.append(SMCodeGeneratorConstants.PREVIOUS_STATES, "");
        _builder.append("[");
        _builder.append((Object)regionIndex, "");
        _builder.append("] != ");
        _builder.append(SMCodeGeneratorConstants.STATE_MAX, "");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("//restore active sub-state of ");
        Region _container_6 = p.getContainer();
        State _state_2 = _container_6.getState();
        String _name_1 = _state_2.getName();
        _builder.append(_name_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Region _container_7 = p.getContainer();
        String _deepHistoryVariableName_1 = this.getDeepHistoryVariableName(_container_7, p);
        _builder.append(_deepHistoryVariableName_1, "\t");
        _builder.append(" = ");
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
        _builder.append("[");
        _builder.append(parentId, "\t");
        _builder.append("].");
        _builder.append(SMCodeGeneratorConstants.PREVIOUS_STATES, "\t");
        _builder.append("[");
        _builder.append((Object)regionIndex, "\t");
        _builder.append("];");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("(this->*");
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
        _builder.append("[");
        Region _container_8 = p.getContainer();
        String _deepHistoryVariableName_2 = this.getDeepHistoryVariableName(_container_8, p);
        _builder.append(_deepHistoryVariableName_2, "\t");
        _builder.append("].");
        _builder.append(SMCodeGeneratorConstants.ENTRY_NAME, "\t");
        _builder.append(")();");
        _builder.newLineIfNotEmpty();
        boolean _hasElements = false;
        for (State a : atomicsWithTimeEvent) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" else ", "\t");
            }
            _builder.append("\t");
            _builder.append("if (");
            String _name_2 = a.getName();
            String _upperCase_1 = _name_2.toUpperCase();
            _builder.append(_upperCase_1, "\t");
            _builder.append("_ID == ");
            Region _container_9 = p.getContainer();
            String _deepHistoryVariableName_3 = this.getDeepHistoryVariableName(_container_9, p);
            _builder.append(_deepHistoryVariableName_3, "\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            String _generateActivateTimeEvent = this.core.generateActivateTimeEvent(a);
            _builder.append(_generateActivateTimeEvent, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append(SMCodeGeneratorConstants.SET_FLAG, "\t");
        _builder.append("(");
        Region _container_10 = p.getContainer();
        String _deepHistoryVariableName_4 = this.getDeepHistoryVariableName(_container_10, p);
        _builder.append(_deepHistoryVariableName_4, "\t");
        _builder.append(", ");
        _builder.append(SMCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "\t");
        _builder.append(", true);");
        _builder.newLineIfNotEmpty();
        boolean _hasElements_1 = false;
        for (State comp : subCompositeStates) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)" else ", "\t");
            }
            _builder.append("\t");
            _builder.append("if (");
            String _name_3 = comp.getName();
            String _upperCase_2 = _name_3.toUpperCase();
            _builder.append(_upperCase_2, "\t");
            _builder.append("_ID == ");
            Region _container_11 = p.getContainer();
            String _deepHistoryVariableName_5 = this.getDeepHistoryVariableName(_container_11, p);
            _builder.append(_deepHistoryVariableName_5, "\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            String _generateRestoreString = this.generateRestoreString(comp, p);
            _builder.append(_generateRestoreString, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//for the first time, the history should be initialized");
        _builder.newLine();
        EList _outgoings = p.getOutgoings();
        int _size = _outgoings.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("\t");
            EList _outgoings_1 = p.getOutgoings();
            Transition _head = (Transition)IterableExtensions.head((Iterable)_outgoings_1);
            Vertex _target = _head.getTarget();
            EList _outgoings_2 = p.getOutgoings();
            Transition _head_1 = (Transition)IterableExtensions.head((Iterable)_outgoings_2);
            String _generateBetweenVertex = this.generateBetweenVertex((Vertex)p, _target, _head_1);
            _builder.append(_generateBetweenVertex, "\t");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t");
            Region _container_12 = p.getContainer();
            String _regionMethodName = this.core.getRegionMethodName(_container_12);
            _builder.append(_regionMethodName, "\t");
            _builder.append("(");
            Region _container_13 = p.getContainer();
            String _initialMacroName = this.core.getInitialMacroName(_container_13);
            _builder.append(_initialMacroName, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        String ret = _builder.toString();
        return ret;
    }

    private String generateRestoreString(State s, Pseudostate p) {
        Region _container = p.getContainer();
        EList _subvertices = _container.getSubvertices();
        Iterable _filter = Iterables.filter((Iterable)_subvertices, State.class);
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                boolean _isComposite;
                boolean _not_1;
                boolean _not;
                boolean _and = false;
                boolean bl = _not = !(it instanceof FinalState);
                _and = !_not ? false : (_not_1 = !(_isComposite = it.isComposite()));
                return _and;
            }
        };
        Iterable subAtomics = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
        Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                List<TimeEvent> _get_1;
                boolean _isEmpty;
                boolean _not;
                boolean _notEquals;
                boolean _and = false;
                List<TimeEvent> _get = ((PseudostateGenerator)PseudostateGenerator.this).core.states2TimeEvents.get(it);
                boolean bl = _notEquals = !Objects.equal(_get, null);
                _and = !_notEquals ? false : (_not = !(_isEmpty = (_get_1 = ((PseudostateGenerator)PseudostateGenerator.this).core.states2TimeEvents.get(it)).isEmpty()));
                return _and;
            }
        };
        Iterable atomicsWithTimeEvent = IterableExtensions.filter((Iterable)subAtomics, (Functions.Function1)_function_1);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//restore active-stub state of ");
        String _name = s.getName();
        _builder.append(_name, "");
        _builder.newLineIfNotEmpty();
        EList _regions = s.getRegions();
        for (Region r : _regions) {
            _builder.append("unsigned int ");
            String _deepHistoryVariableName = this.getDeepHistoryVariableName(r, p);
            _builder.append(_deepHistoryVariableName, "");
            _builder.append(" = ");
            _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
            _builder.append("[");
            String _name_1 = s.getName();
            String _upperCase = _name_1.toUpperCase();
            _builder.append(_upperCase, "");
            _builder.append("_ID].");
            _builder.append(SMCodeGeneratorConstants.PREVIOUS_STATES, "");
            _builder.append("[");
            EList _regions_1 = s.getRegions();
            int _indexOf = _regions_1.indexOf((Object)r);
            _builder.append((Object)_indexOf, "");
            _builder.append("];");
            _builder.newLineIfNotEmpty();
            _builder.append("(this->*");
            _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
            _builder.append("[");
            String _deepHistoryVariableName_1 = this.getDeepHistoryVariableName(r, p);
            _builder.append(_deepHistoryVariableName_1, "");
            _builder.append("].");
            _builder.append(SMCodeGeneratorConstants.ENTRY_NAME, "");
            _builder.append(")();");
            _builder.newLineIfNotEmpty();
            boolean _hasElements = false;
            for (State a : atomicsWithTimeEvent) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)" else ", "");
                }
                _builder.append("if (");
                String _name_2 = a.getName();
                String _upperCase_1 = _name_2.toUpperCase();
                _builder.append(_upperCase_1, "");
                _builder.append("_ID == ");
                String _deepHistoryVariableName_2 = this.getDeepHistoryVariableName(r, p);
                _builder.append(_deepHistoryVariableName_2, "");
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                String _generateActivateTimeEvent = this.core.generateActivateTimeEvent(a);
                _builder.append(_generateActivateTimeEvent, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append(SMCodeGeneratorConstants.SET_FLAG, "");
            _builder.append("(");
            String _deepHistoryVariableName_3 = this.getDeepHistoryVariableName(r, p);
            _builder.append(_deepHistoryVariableName_3, "");
            _builder.append(", ");
            _builder.append(SMCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "");
            _builder.append(", true);");
            _builder.newLineIfNotEmpty();
            EList _subvertices_1 = r.getSubvertices();
            Iterable _filter_1 = Iterables.filter((Iterable)_subvertices_1, State.class);
            Functions.Function1<State, Boolean> _function_2 = new Functions.Function1<State, Boolean>(){

                public Boolean apply(State it) {
                    boolean _isComposite;
                    boolean _and = false;
                    boolean _not = !(it instanceof FinalState);
                    _and = !_not ? false : (_isComposite = it.isComposite());
                    return _and;
                }
            };
            Iterable subCompositeStates = IterableExtensions.filter((Iterable)_filter_1, (Functions.Function1)_function_2);
            _builder.newLineIfNotEmpty();
            boolean _hasElements_1 = false;
            for (State comp : subCompositeStates) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)" else ", "");
                }
                _builder.append("if (");
                String _name_3 = comp.getName();
                String _upperCase_2 = _name_3.toUpperCase();
                _builder.append(_upperCase_2, "");
                _builder.append("_ID == ");
                String _deepHistoryVariableName_4 = this.getDeepHistoryVariableName(r, p);
                _builder.append(_deepHistoryVariableName_4, "");
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                String _generateRestoreString = this.generateRestoreString(comp, p);
                _builder.append(_generateRestoreString, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
            }
        }
        String ret = _builder.toString();
        return ret;
    }

    public String getDeepHistoryVariableName(Region r, Pseudostate p) {
        StringConcatenation _builder = new StringConcatenation();
        State _state = r.getState();
        String _name = _state.getName();
        _builder.append(_name, "");
        _builder.append("_");
        String _name_1 = r.getName();
        _builder.append(_name_1, "");
        _builder.append("_");
        String _name_2 = p.getName();
        _builder.append(_name_2, "");
        return _builder.toString();
    }

    public String generateShallowHistory(Pseudostate p) {
        boolean _greaterThan_2;
        boolean _greaterThan_1;
        boolean _greaterThan;
        Region _container = p.getContainer();
        State _state = _container.getState();
        EList _regions = _state.getRegions();
        Region _container_1 = p.getContainer();
        int regionIndex = _regions.indexOf((Object)_container_1);
        Region _container_2 = p.getContainer();
        EList _subvertices = _container_2.getSubvertices();
        Iterable _filter = Iterables.filter((Iterable)_subvertices, State.class);
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                boolean _isComposite;
                boolean _and = false;
                boolean _not = !(it instanceof FinalState);
                _and = !_not ? false : (_isComposite = it.isComposite());
                return _and;
            }
        };
        Iterable subCompositeStates = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
        Region _container_3 = p.getContainer();
        Pseudostate pseudoInitial = TransformationUtil.firstPseudoState(_container_3, PseudostateKind.INITIAL_LITERAL);
        Region _container_4 = p.getContainer();
        State _state_1 = _container_4.getState();
        String _name = _state_1.getName();
        String _upperCase = _name.toUpperCase();
        String parentId = String.valueOf(_upperCase) + "_ID";
        Region _container_5 = p.getContainer();
        EList _subvertices_1 = _container_5.getSubvertices();
        Iterable _filter_1 = Iterables.filter((Iterable)_subvertices_1, State.class);
        Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                boolean _isComposite;
                boolean _not_1;
                boolean _not;
                boolean _and = false;
                boolean bl = _not = !(it instanceof FinalState);
                _and = !_not ? false : (_not_1 = !(_isComposite = it.isComposite()));
                return _and;
            }
        };
        Iterable subAtomics = IterableExtensions.filter((Iterable)_filter_1, (Functions.Function1)_function_1);
        Functions.Function1<State, Boolean> _function_2 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                List<TimeEvent> _get_1;
                boolean _isEmpty;
                boolean _not;
                boolean _notEquals;
                boolean _and = false;
                List<TimeEvent> _get = ((PseudostateGenerator)PseudostateGenerator.this).core.states2TimeEvents.get(it);
                boolean bl = _notEquals = !Objects.equal(_get, null);
                _and = !_notEquals ? false : (_not = !(_isEmpty = (_get_1 = ((PseudostateGenerator)PseudostateGenerator.this).core.states2TimeEvents.get(it)).isEmpty()));
                return _and;
            }
        };
        Iterable atomicsWithTimeEvent = IterableExtensions.filter((Iterable)subAtomics, (Functions.Function1)_function_2);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("unsigned int loc_ActiveId;");
        _builder.newLine();
        _builder.append("if (");
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
        _builder.append("[");
        _builder.append(parentId, "");
        _builder.append("].");
        _builder.append(SMCodeGeneratorConstants.PREVIOUS_STATES, "");
        _builder.append("[");
        _builder.append((Object)regionIndex, "");
        _builder.append("] != ");
        _builder.append(SMCodeGeneratorConstants.STATE_MAX, "");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("loc_ActiveId = ");
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
        _builder.append("[");
        _builder.append(parentId, "\t");
        _builder.append("].");
        _builder.append(SMCodeGeneratorConstants.PREVIOUS_STATES, "\t");
        _builder.append("[");
        _builder.append((Object)regionIndex, "\t");
        _builder.append("];");
        _builder.newLineIfNotEmpty();
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//for the first time, the history should be initialized");
        _builder.newLine();
        EList _outgoings = p.getOutgoings();
        int _size = _outgoings.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("\t");
            EList _outgoings_1 = p.getOutgoings();
            Transition _head = (Transition)IterableExtensions.head((Iterable)_outgoings_1);
            String _transitionEffect = TransformationUtil.getTransitionEffect(_head);
            _builder.append(_transitionEffect, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("loc_ActiveId = ");
            EList _outgoings_2 = p.getOutgoings();
            Transition _head_1 = (Transition)IterableExtensions.head((Iterable)_outgoings_2);
            Vertex _target = _head_1.getTarget();
            String _name_1 = _target.getName();
            String _upperCase_1 = _name_1.toUpperCase();
            _builder.append(_upperCase_1, "\t");
            _builder.append("_ID;");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t");
            EList _outgoings_3 = pseudoInitial.getOutgoings();
            Transition _head_2 = (Transition)IterableExtensions.head((Iterable)_outgoings_3);
            String _transitionEffect_1 = TransformationUtil.getTransitionEffect(_head_2);
            _builder.append(_transitionEffect_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("loc_ActiveId = ");
            EList _outgoings_4 = pseudoInitial.getOutgoings();
            Transition _head_3 = (Transition)IterableExtensions.head((Iterable)_outgoings_4);
            Vertex _target_1 = _head_3.getTarget();
            String _name_2 = _target_1.getName();
            String _upperCase_2 = _name_2.toUpperCase();
            _builder.append(_upperCase_2, "\t");
            _builder.append("_ID;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
        _builder.append("[");
        _builder.append(parentId, "");
        _builder.append("].");
        _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
        _builder.append("[");
        _builder.append((Object)regionIndex, "");
        _builder.append("] = loc_ActiveId;");
        _builder.newLineIfNotEmpty();
        boolean _hasElements = false;
        for (State comp : subCompositeStates) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" else ", "");
            }
            _builder.append("if (");
            String _name_3 = comp.getName();
            String _upperCase_3 = _name_3.toUpperCase();
            _builder.append(_upperCase_3, "");
            _builder.append("_ID == loc_ActiveId) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _generateEnteringOnSubVertex = this.core.generateEnteringOnSubVertex(comp, null);
            _builder.append(_generateEnteringOnSubVertex, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
        }
        _builder.append(" ");
        int _size_1 = IterableExtensions.size((Iterable)subCompositeStates);
        boolean bl2 = _greaterThan_1 = _size_1 > 0;
        if (_greaterThan_1) {
            _builder.append(" else { ");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("(this->*");
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
        _builder.append("[loc_ActiveId].");
        _builder.append(SMCodeGeneratorConstants.ENTRY_NAME, "\t");
        _builder.append(")();");
        _builder.newLineIfNotEmpty();
        boolean _hasElements_1 = false;
        for (State a : atomicsWithTimeEvent) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)" else ", "\t");
            }
            _builder.append("\t");
            _builder.append("if (");
            String _name_4 = a.getName();
            String _upperCase_4 = _name_4.toUpperCase();
            _builder.append(_upperCase_4, "\t");
            _builder.append("_ID == loc_ActiveId) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            String _generateActivateTimeEvent = this.core.generateActivateTimeEvent(a);
            _builder.append(_generateActivateTimeEvent, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append(SMCodeGeneratorConstants.SET_FLAG, "\t");
        _builder.append("(loc_ActiveId, ");
        _builder.append(SMCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "\t");
        _builder.append(", true);");
        _builder.newLineIfNotEmpty();
        int _size_2 = IterableExtensions.size((Iterable)subCompositeStates);
        boolean bl3 = _greaterThan_2 = _size_2 > 0;
        if (_greaterThan_2) {
            _builder.append("}");
        }
        String ret = _builder.toString();
        return ret;
    }

    public String generateChoice(Pseudostate p) {
        StringConcatenation _builder = new StringConcatenation();
        EList _outgoings = p.getOutgoings();
        Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition it) {
                Constraint _guard = it.getGuard();
                return !Objects.equal((Object)_guard, null);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_outgoings, (Functions.Function1)_function);
        boolean _hasElements = false;
        for (Transition out : _filter) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" else ", "");
            }
            _builder.append("if (");
            String _guard = this.core.getGuard(out);
            _builder.append(_guard, "");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            Vertex _target = out.getTarget();
            String _generateBetweenVertex = this.generateBetweenVertex((Vertex)p, _target, out);
            _builder.append(_generateBetweenVertex, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
        }
        _builder.append(" else {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        EList _outgoings_1 = p.getOutgoings();
        Functions.Function1<Transition, Boolean> _function_1 = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition it) {
                Constraint _guard = it.getGuard();
                return Objects.equal((Object)_guard, null);
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_outgoings_1, (Functions.Function1)_function_1);
        Transition t = (Transition)IterableExtensions.head((Iterable)_filter_1);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Vertex _target_1 = t.getTarget();
        String _generateBetweenVertex_1 = this.generateBetweenVertex((Vertex)p, _target_1, t);
        _builder.append(_generateBetweenVertex_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        String ret = _builder.toString();
        return ret;
    }

    public List<Vertex> intersect(List<Vertex> l1, final List<Vertex> l2) {
        Functions.Function1<Vertex, Boolean> _function = new Functions.Function1<Vertex, Boolean>(){

            public Boolean apply(Vertex it) {
                return l2.contains(it);
            }
        };
        Iterable _filter = IterableExtensions.filter(l1, (Functions.Function1)_function);
        return IterableExtensions.toList((Iterable)_filter);
    }

    public String generateEntryPoint(Pseudostate p) {
        StringConcatenation _builder = new StringConcatenation();
        String ret = _builder.toString();
        EList _outgoings = p.getOutgoings();
        Functions.Function1<Transition, Vertex> _function = new Functions.Function1<Transition, Vertex>(){

            public Vertex apply(Transition it) {
                return it.getTarget();
            }
        };
        List _map = ListExtensions.map((List)_outgoings, (Functions.Function1)_function);
        final List targets = IterableExtensions.toList((Iterable)_map);
        EObject _eContainer = p.eContainer();
        EList _regions = ((State)_eContainer).getRegions();
        Functions.Function1<Region, Boolean> _function_1 = new Functions.Function1<Region, Boolean>(){

            public Boolean apply(Region it) {
                List<Vertex> _allSubVertexes = PseudostateGenerator.this.core.allSubVertexes(it);
                List _list = IterableExtensions.toList(_allSubVertexes);
                List<Vertex> _intersect = PseudostateGenerator.this.intersect(_list, targets);
                int _size = _intersect.size();
                return _size > 0;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_regions, (Functions.Function1)_function_1);
        final List enteredRegions = IterableExtensions.toList((Iterable)_filter);
        EObject _eContainer_1 = p.eContainer();
        EList _regions_1 = ((State)_eContainer_1).getRegions();
        Functions.Function1<Region, Boolean> _function_2 = new Functions.Function1<Region, Boolean>(){

            public Boolean apply(Region it) {
                boolean _contains = enteredRegions.contains(it);
                return !_contains;
            }
        };
        Iterable defaultRegions = IterableExtensions.filter((Iterable)_regions_1, (Functions.Function1)_function_2);
        StringConcatenation _builder_1 = new StringConcatenation();
        EList _outgoings_1 = p.getOutgoings();
        for (Transition out : _outgoings_1) {
            String _transitionEffect = TransformationUtil.getTransitionEffect(out);
            _builder_1.append(_transitionEffect, "");
            _builder_1.newLineIfNotEmpty();
        }
        Functions.Function1<Region, Boolean> _function_3 = new Functions.Function1<Region, Boolean>(){

            public Boolean apply(Region it) {
                State _findInitialState = TransformationUtil.findInitialState(it);
                return !Objects.equal((Object)_findInitialState, null);
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)defaultRegions, (Functions.Function1)_function_3);
        for (Region r : _filter_1) {
            String _regionMethodName = this.core.getRegionMethodName(r);
            _builder_1.append(_regionMethodName, "");
            _builder_1.append("(");
            String _initialMacroName = this.core.getInitialMacroName(r);
            _builder_1.append(_initialMacroName, "");
            _builder_1.append(");");
            _builder_1.newLineIfNotEmpty();
        }
        for (final Region r_1 : enteredRegions) {
            String _regionMethodName_1 = this.core.getRegionMethodName(r_1);
            _builder_1.append(_regionMethodName_1, "");
            _builder_1.append("(");
            Functions.Function1<Vertex, Boolean> _function_4 = new Functions.Function1<Vertex, Boolean>(){

                public Boolean apply(Vertex it) {
                    EList _allNamespaces = r_1.allNamespaces();
                    return _allNamespaces.contains((Object)it);
                }
            };
            Iterable _filter_2 = IterableExtensions.filter((Iterable)targets, (Functions.Function1)_function_4);
            Vertex _head = (Vertex)IterableExtensions.head((Iterable)_filter_2);
            String _vertexMacroName = this.core.getVertexMacroName(_head);
            _builder_1.append(_vertexMacroName, "");
            _builder_1.append(");");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t\t\t");
        }
        ret = _builder_1.toString();
        return ret;
    }

    public String generateExitPoint(Pseudostate p) {
        StringConcatenation _builder = new StringConcatenation();
        String ret = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        EList _outgoings = p.getOutgoings();
        Transition _head = (Transition)IterableExtensions.head((Iterable)_outgoings);
        Vertex _target = _head.getTarget();
        EList _outgoings_1 = p.getOutgoings();
        Transition _head_1 = (Transition)IterableExtensions.head((Iterable)_outgoings_1);
        String _generateBetweenVertex = this.generateBetweenVertex((Vertex)p, _target, _head_1);
        _builder_1.append(_generateBetweenVertex, "");
        _builder_1.newLineIfNotEmpty();
        ret = _builder_1.toString();
        return ret;
    }

    public String generateFork(Pseudostate p) {
        try {
            boolean _not;
            EList _outgoings = p.getOutgoings();
            Functions.Function1<Transition, Vertex> _function = new Functions.Function1<Transition, Vertex>(){

                public Vertex apply(Transition it) {
                    return it.getTarget();
                }
            };
            List targets = ListExtensions.map((List)_outgoings, (Functions.Function1)_function);
            StringConcatenation _builder = new StringConcatenation();
            String ret = _builder.toString();
            ArrayList<Vertex> exits = new ArrayList<Vertex>();
            ArrayList<Vertex> enters = new ArrayList<Vertex>();
            EList _outgoings_1 = p.getOutgoings();
            Transition _head = (Transition)IterableExtensions.head((Iterable)_outgoings_1);
            this.core.eventTransform.calculateExitsEnters(_head, exits, enters);
            Vertex cpEx = (Vertex)IterableExtensions.last(exits);
            Vertex _last = (Vertex)IterableExtensions.last(enters);
            State parent = (State)_last;
            boolean _isOrthogonal = parent.isOrthogonal();
            boolean bl = _not = !_isOrthogonal;
            if (_not) {
                throw new Exception("state machine is ill-formed");
            }
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(ret, "");
            _builder_1.newLineIfNotEmpty();
            if (cpEx instanceof State) {
                String _generateExitingSubStates = this.core.generateExitingSubStates((State)cpEx, true);
                _builder_1.append(_generateExitingSubStates, "");
                _builder_1.newLineIfNotEmpty();
            }
            _builder_1.append("//need to be concurrently executed");
            _builder_1.newLine();
            EList _outgoings_2 = p.getOutgoings();
            for (Transition out : _outgoings_2) {
                String _transitionEffect = TransformationUtil.getTransitionEffect(out);
                _builder_1.append(_transitionEffect, "");
                _builder_1.newLineIfNotEmpty();
            }
            ret = _builder_1.toString();
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
            _builder_2.append("[");
            String _name = parent.getName();
            String _upperCase = _name.toUpperCase();
            _builder_2.append(_upperCase, "");
            _builder_2.append("_ID]");
            String pAttr = _builder_2.toString();
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append(ret, "");
            _builder_3.newLineIfNotEmpty();
            String _generateChangeState = this.core.generateChangeState(parent);
            _builder_3.append(_generateChangeState, "");
            _builder_3.newLineIfNotEmpty();
            String _fptrCall = this.core.getFptrCall(pAttr, false, SMCodeGeneratorConstants.ENTRY_NAME);
            _builder_3.append(_fptrCall, "");
            _builder_3.append(";");
            _builder_3.newLineIfNotEmpty();
            _builder_3.append("//start activity of ");
            String _name_1 = parent.getName();
            _builder_3.append(_name_1, "");
            _builder_3.append(" by calling setFlag");
            _builder_3.newLineIfNotEmpty();
            _builder_3.append(SMCodeGeneratorConstants.SET_FLAG, "");
            _builder_3.append("(");
            String _name_2 = parent.getName();
            String _upperCase_1 = _name_2.toUpperCase();
            _builder_3.append(_upperCase_1, "");
            _builder_3.append("_ID, ");
            _builder_3.append(SMCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "");
            _builder_3.append(", true);");
            _builder_3.newLineIfNotEmpty();
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                for (Vertex target : targets) {
                    List<Vertex> _allSubVertexes = this.core.allSubVertexes(r);
                    boolean _contains = _allSubVertexes.contains(target);
                    if (!_contains) continue;
                    String _vertexMacroName = this.core.getVertexMacroName(target);
                    String _generateForkCall = this.core.concurrency.generateForkCall(r, true, _vertexMacroName);
                    _builder_3.append(_generateForkCall, "");
                    _builder_3.newLineIfNotEmpty();
                }
            }
            ret = _builder_3.toString();
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String generateJoin(Pseudostate p) {
        StringConcatenation _builder = new StringConcatenation();
        EList _outgoings = p.getOutgoings();
        Transition _head = (Transition)IterableExtensions.head((Iterable)_outgoings);
        Vertex _target = _head.getTarget();
        EList _outgoings_1 = p.getOutgoings();
        Transition _head_1 = (Transition)IterableExtensions.head((Iterable)_outgoings_1);
        String _generateBetweenVertex = this.generateBetweenVertex((Vertex)p, _target, _head_1);
        _builder.append(_generateBetweenVertex, "");
        return _builder.toString();
    }
}

