/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse.reverse;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTRangeBasedForStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeConstructorExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTryBlockStatement;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.ReverseCpp2Uml;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.ReverseUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.utils.RoundtripCppUtils;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class DependencyAnalysis {
    private ReverseUtils reverseUtils = ReverseUtils.getInstance();
    private Operation m_operation;
    private IASTFunctionDefinition m_definition;
    private ITranslationUnit m_itu;
    private ReverseCpp2Uml m_reverseCppUml;
    private Classifier m_classifier;
    private Map<String, Type> localVaribaleList = new HashMap<String, Type>();

    public DependencyAnalysis(Operation op, IASTFunctionDefinition definition, ITranslationUnit itu, ReverseCpp2Uml reverseCppUml) {
        this.m_operation = op;
        this.m_definition = definition;
        this.m_itu = itu;
        this.m_reverseCppUml = reverseCppUml;
        EObject _eContainer = op.eContainer();
        if (_eContainer instanceof Classifier) {
            EObject _eContainer_1 = op.eContainer();
            this.m_classifier = (Classifier)_eContainer_1;
        }
    }

    public void analyzeDependencies() {
        boolean _notEquals;
        IASTStatement body = this.m_definition.getBody();
        boolean bl = _notEquals = !Objects.equal((Object)body, null);
        if (_notEquals) {
            this.analyzeStatement(body);
        }
    }

    private void analyzeStatement(IASTStatement statement) {
        boolean _equals = Objects.equal((Object)statement, null);
        if (_equals) {
            return;
        }
        boolean _matched = false;
        if (!_matched && statement instanceof IASTCompoundStatement) {
            _matched = true;
            this.analyzeStatement((IASTCompoundStatement)statement);
        }
        if (!_matched && statement instanceof ICPPASTCatchHandler) {
            _matched = true;
            this.analyzeStatement((ICPPASTCatchHandler)statement);
        }
        if (!_matched && statement instanceof ICPPASTRangeBasedForStatement) {
            _matched = true;
            this.analyzeStatement((ICPPASTRangeBasedForStatement)statement);
        }
        if (!_matched && statement instanceof ICPPASTTryBlockStatement) {
            _matched = true;
            this.analyzeStatement((ICPPASTTryBlockStatement)statement);
        }
        if (!_matched && statement instanceof IASTCaseStatement) {
            _matched = true;
            this.analyzeStatement((IASTCaseStatement)statement);
        }
        if (!_matched && statement instanceof IASTDeclarationStatement) {
            _matched = true;
            this.analyzeStatement((IASTDeclarationStatement)statement);
        }
        if (!_matched && statement instanceof IASTDefaultStatement) {
            _matched = true;
            this.analyzeStatement((IASTDefaultStatement)statement);
        }
        if (!_matched && statement instanceof IASTDoStatement) {
            _matched = true;
            this.analyzeStatement((IASTDoStatement)statement);
        }
        if (!_matched && statement instanceof IASTExpressionStatement) {
            _matched = true;
            this.analyzeStatement((IASTExpressionStatement)statement);
        }
        if (!_matched && statement instanceof IASTForStatement) {
            _matched = true;
            this.analyzeStatement((IASTForStatement)statement);
        }
        if (!_matched && statement instanceof IASTIfStatement) {
            _matched = true;
            this.analyzeStatement((IASTIfStatement)statement);
        }
        if (!_matched && statement instanceof IASTReturnStatement) {
            _matched = true;
            this.analyzeStatement((IASTReturnStatement)statement);
        }
        if (!_matched && statement instanceof IASTSwitchStatement) {
            _matched = true;
            this.analyzeStatement((IASTSwitchStatement)statement);
        }
        if (!_matched && statement instanceof IASTWhileStatement) {
            _matched = true;
            this.analyzeStatement((IASTWhileStatement)statement);
        }
    }

    private void analyzeStatement(IASTCompoundStatement statement) {
        IASTStatement[] statements;
        IASTStatement[] _converted_statements = statements = statement.getStatements();
        Consumer<IASTStatement> _function = new Consumer<IASTStatement>(){

            @Override
            public void accept(IASTStatement it) {
                DependencyAnalysis.this.analyzeStatement(it);
            }
        };
        ((List)Conversions.doWrapArray((Object)_converted_statements)).forEach(_function);
    }

    private void analyzeStatement(ICPPASTCatchHandler statement) {
    }

    private void analyzeStatement(ICPPASTRangeBasedForStatement statement) {
    }

    private void analyzeStatement(ICPPASTTryBlockStatement statement) {
    }

    private void analyzeStatement(IASTCaseStatement statement) {
    }

    private void analyzeStatement(IASTDeclarationStatement statement) {
        IASTDeclaration _declaration = statement.getDeclaration();
        if (_declaration instanceof IASTSimpleDeclaration) {
            boolean _notEquals;
            IASTDeclaration _declaration_1 = statement.getDeclaration();
            IASTSimpleDeclaration declaration = (IASTSimpleDeclaration)_declaration_1;
            boolean bl = _notEquals = !Objects.equal((Object)declaration, null);
            if (_notEquals) {
                boolean _not;
                IASTDeclSpecifier specifier = declaration.getDeclSpecifier();
                String typeName = this.reverseUtils.getCppTypeName(specifier);
                boolean _isPrimitiveCppType = RoundtripCppUtils.isPrimitiveCppType(typeName);
                boolean bl2 = _not = !_isPrimitiveCppType;
                if (_not) {
                    boolean _notEquals_1;
                    List<String> namespaces = this.reverseUtils.getContextNamespaces((ICElement)this.m_itu);
                    final Type umlType = this.m_reverseCppUml.getUMLType(typeName, this.m_itu, namespaces);
                    boolean bl3 = _notEquals_1 = !Objects.equal((Object)umlType, null);
                    if (_notEquals_1) {
                        IASTDeclarator[] _declarators = declaration.getDeclarators();
                        Consumer<IASTDeclarator> _function = new Consumer<IASTDeclarator>(){

                            @Override
                            public void accept(IASTDeclarator it) {
                                IASTName _name = it.getName();
                                String _string = _name.toString();
                                DependencyAnalysis.this.localVaribaleList.put(_string, umlType);
                            }
                        };
                        ((List)Conversions.doWrapArray((Object)_declarators)).forEach(_function);
                        this.createDependency((NamedElement)umlType);
                    }
                }
                IASTDeclarator[] _declarators_1 = declaration.getDeclarators();
                Consumer<IASTDeclarator> _function_1 = new Consumer<IASTDeclarator>(){

                    @Override
                    public void accept(IASTDeclarator it) {
                        IASTEqualsInitializer equalsInitialiser;
                        IASTInitializerClause clause;
                        boolean _notEquals;
                        IASTInitializer initilizer = it.getInitializer();
                        boolean bl = _notEquals = !Objects.equal((Object)initilizer, null);
                        if (_notEquals && initilizer instanceof IASTEqualsInitializer && (clause = (equalsInitialiser = (IASTEqualsInitializer)initilizer).getInitializerClause()) instanceof IASTExpression) {
                            DependencyAnalysis.this.analyzeExpression((IASTExpression)clause);
                        }
                    }
                };
                ((List)Conversions.doWrapArray((Object)_declarators_1)).forEach(_function_1);
            }
        }
    }

    private void createDependency(final NamedElement suplier) {
        Element _owner = this.m_operation.getOwner();
        if (_owner instanceof NamedElement) {
            Functions.Function1<Usage, Boolean> _function;
            EList _ownedElements;
            Iterable _filter;
            List usages;
            Iterable _filter_1;
            Usage usage;
            boolean _equals;
            boolean _notEquals;
            Package nearestPack = this.reverseUtils.getNearestPackage((Element)this.m_operation);
            boolean bl = _notEquals = !Objects.equal((Object)nearestPack, null);
            if (_notEquals && (_equals = Objects.equal((Object)(usage = (Usage)IterableExtensions.head((Iterable)(_filter_1 = IterableExtensions.filter((Iterable)(usages = IterableExtensions.toList((Iterable)(_filter = Iterables.filter((Iterable)(_ownedElements = nearestPack.getOwnedElements()), Usage.class)))), (Functions.Function1)(_function = new Functions.Function1<Usage, Boolean>(){

                public Boolean apply(Usage it) {
                    Element _owner;
                    boolean _and = false;
                    EList _clients = it.getClients();
                    boolean _contains = _clients.contains((Object)(_owner = DependencyAnalysis.this.m_operation.getOwner()));
                    if (!_contains) {
                        _and = false;
                    } else {
                        boolean _contains_1;
                        EList _suppliers = it.getSuppliers();
                        _and = _contains_1 = _suppliers.contains((Object)suplier);
                    }
                    return _and;
                }
            }))))), null))) {
                Element _owner_1 = this.m_operation.getOwner();
                ((NamedElement)_owner_1).createUsage(suplier);
            }
        }
    }

    private void analyzeStatement(IASTDefaultStatement statement) {
    }

    private void analyzeStatement(IASTDoStatement statement) {
        IASTStatement _body = statement.getBody();
        this.analyzeStatement(_body);
    }

    private void analyzeStatement(IASTExpressionStatement statement) {
        IASTExpression expression = statement.getExpression();
        this.analyzeExpression(expression);
    }

    private Type getTypeOfVariableOrAttribute(final String attributeName) {
        Type type = this.localVaribaleList.get(attributeName);
        boolean _equals = Objects.equal((Object)type, null);
        if (_equals) {
            boolean _notEquals;
            Functions.Function1<Property, Boolean> _function;
            EList _allAttributes = this.m_classifier.getAllAttributes();
            Iterable _filter = IterableExtensions.filter((Iterable)_allAttributes, (Functions.Function1)(_function = new Functions.Function1<Property, Boolean>(){

                public Boolean apply(Property it) {
                    String _name = it.getName();
                    return _name.equals(attributeName);
                }
            }));
            Property attribute = (Property)IterableExtensions.head((Iterable)_filter);
            boolean bl = _notEquals = !Objects.equal((Object)attribute, null);
            if (_notEquals) {
                Type _type;
                type = _type = attribute.getType();
            }
        }
        return type;
    }

    private boolean isSameSignature(Operation op, List<Type> l2) {
        EList _ownedParameters = op.getOwnedParameters();
        Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

            public Boolean apply(Parameter it) {
                ParameterDirectionKind _direction = it.getDirection();
                return !Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_ownedParameters, (Functions.Function1)_function);
        List _list = IterableExtensions.toList((Iterable)_filter);
        Functions.Function1<Parameter, Type> _function_1 = new Functions.Function1<Parameter, Type>(){

            public Type apply(Parameter it) {
                return it.getType();
            }
        };
        List params = ListExtensions.map((List)_list, (Functions.Function1)_function_1);
        return this.isSameTypeList(params, l2);
    }

    private boolean isSameTypeList(List<Type> l1, List<Type> l2) {
        int _size_1;
        boolean _notEquals;
        int _size = l1.size();
        boolean bl = _notEquals = _size != (_size_1 = l2.size());
        if (_notEquals) {
            return false;
        }
        int i = 0;
        while (i < l1.size()) {
            Type _get_1;
            boolean _notEquals_1;
            Type _get = l1.get(i);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_get, (Object)(_get_1 = l2.get(i)));
            if (_notEquals_1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Type analyzeExpression(IASTExpression expression) {
        boolean _equals = Objects.equal((Object)expression, null);
        if (_equals) {
            return null;
        }
        Type ret = null;
        if (expression instanceof ICPPASTFunctionCallExpression) {
            boolean _notEquals_3;
            IASTExpression nameExpression = ((ICPPASTFunctionCallExpression)expression).getFunctionNameExpression();
            IASTInitializerClause[] arguments = ((ICPPASTFunctionCallExpression)expression).getArguments();
            Parameter returnParam = null;
            if (nameExpression instanceof IASTFieldReference) {
                boolean _notEquals;
                String _rawSignature;
                boolean _equals_1;
                final IASTName functionName = ((IASTFieldReference)nameExpression).getFieldName();
                IASTExpression fieldOwner = ((IASTFieldReference)nameExpression).getFieldOwner();
                Classifier targetClass = null;
                if (fieldOwner instanceof IASTIdExpression) {
                    IASTName _name = ((IASTIdExpression)fieldOwner).getName();
                    String _string = _name.toString();
                    Type type = this.getTypeOfVariableOrAttribute(_string);
                    if (type instanceof Classifier) {
                        targetClass = (Classifier)type;
                    }
                } else if (fieldOwner instanceof IASTLiteralExpression && (_equals_1 = Objects.equal((Object)(_rawSignature = ((IASTLiteralExpression)fieldOwner).getRawSignature()), (Object)"this"))) {
                    targetClass = this.m_classifier;
                }
                boolean bl = _notEquals = !Objects.equal(targetClass, null);
                if (_notEquals) {
                    boolean _greaterThan;
                    Functions.Function1<Operation, Boolean> _function;
                    EList _allOperations = targetClass.getAllOperations();
                    Iterable _filter = IterableExtensions.filter((Iterable)_allOperations, (Functions.Function1)(_function = new Functions.Function1<Operation, Boolean>(){

                        public Boolean apply(Operation it) {
                            String _name = it.getName();
                            String _string = functionName.toString();
                            return _name.equals(_string);
                        }
                    }));
                    List sameNameOps = IterableExtensions.toList((Iterable)_filter);
                    int _size = sameNameOps.size();
                    boolean bl2 = _greaterThan = _size > 1;
                    if (_greaterThan) {
                        boolean _notEquals_1;
                        IASTInitializerClause[] _converted_arguments = arguments;
                        Functions.Function1<IASTInitializerClause, Type> _function_1 = new Functions.Function1<IASTInitializerClause, Type>(){

                            public Type apply(IASTInitializerClause it) {
                                return DependencyAnalysis.this.getArgumentType(it);
                            }
                        };
                        List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_converted_arguments)), (Functions.Function1)_function_1);
                        final List currentArgumentTypes = IterableExtensions.toList((Iterable)_map);
                        Functions.Function1<Operation, Boolean> _function_2 = new Functions.Function1<Operation, Boolean>(){

                            public Boolean apply(Operation it) {
                                return DependencyAnalysis.this.isSameSignature(it, currentArgumentTypes);
                            }
                        };
                        Iterable _filter_1 = IterableExtensions.filter((Iterable)sameNameOps, (Functions.Function1)_function_2);
                        Operation targetOp = (Operation)IterableExtensions.head((Iterable)_filter_1);
                        boolean bl3 = _notEquals_1 = !Objects.equal((Object)targetOp, null);
                        if (_notEquals_1) {
                            Parameter _head;
                            this.createDependency((NamedElement)targetOp);
                            EList _ownedParameters = targetOp.getOwnedParameters();
                            Functions.Function1<Parameter, Boolean> _function_3 = new Functions.Function1<Parameter, Boolean>(){

                                public Boolean apply(Parameter it) {
                                    ParameterDirectionKind _direction = it.getDirection();
                                    return Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
                                }
                            };
                            Iterable _filter_2 = IterableExtensions.filter((Iterable)_ownedParameters, (Functions.Function1)_function_3);
                            returnParam = _head = (Parameter)IterableExtensions.head((Iterable)_filter_2);
                        }
                    } else {
                        boolean _notEquals_2;
                        Operation _head_1 = (Operation)IterableExtensions.head((Iterable)sameNameOps);
                        boolean bl4 = _notEquals_2 = !Objects.equal((Object)_head_1, null);
                        if (_notEquals_2) {
                            Parameter _head_4;
                            Operation _head_2 = (Operation)IterableExtensions.head((Iterable)sameNameOps);
                            this.createDependency((NamedElement)_head_2);
                            Operation _head_3 = (Operation)IterableExtensions.head((Iterable)sameNameOps);
                            EList _ownedParameters_1 = _head_3.getOwnedParameters();
                            Functions.Function1<Parameter, Boolean> _function_4 = new Functions.Function1<Parameter, Boolean>(){

                                public Boolean apply(Parameter it) {
                                    ParameterDirectionKind _direction = it.getDirection();
                                    return Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
                                }
                            };
                            Iterable _filter_3 = IterableExtensions.filter((Iterable)_ownedParameters_1, (Functions.Function1)_function_4);
                            returnParam = _head_4 = (Parameter)IterableExtensions.head((Iterable)_filter_3);
                        }
                    }
                }
            }
            boolean bl = _notEquals_3 = !Objects.equal(returnParam, null);
            if (_notEquals_3) {
                Type _type;
                ret = _type = returnParam.getType();
            }
        } else if (!(expression instanceof IASTFunctionCallExpression)) {
            if (expression instanceof ICPPASTNewExpression) {
                Type _uMLType;
                IASTTypeId _typeId = ((ICPPASTNewExpression)expression).getTypeId();
                IASTDeclSpecifier _declSpecifier = _typeId.getDeclSpecifier();
                String typeName = this.reverseUtils.getCppTypeName(_declSpecifier);
                List<String> _contextNamespaces = this.reverseUtils.getContextNamespaces((ICElement)this.m_itu);
                ret = _uMLType = this.m_reverseCppUml.getUMLType(typeName, this.m_itu, _contextNamespaces);
            } else if (!(expression instanceof ICPPASTSimpleTypeConstructorExpression)) {
                if (expression instanceof IASTCastExpression) {
                    Type _uMLType_1;
                    IASTTypeId _typeId_1 = ((IASTCastExpression)expression).getTypeId();
                    IASTDeclSpecifier _declSpecifier_1 = _typeId_1.getDeclSpecifier();
                    String typeName_1 = this.reverseUtils.getCppTypeName(_declSpecifier_1);
                    List<String> _contextNamespaces_1 = this.reverseUtils.getContextNamespaces((ICElement)this.m_itu);
                    ret = _uMLType_1 = this.m_reverseCppUml.getUMLType(typeName_1, this.m_itu, _contextNamespaces_1);
                } else if (expression instanceof IASTExpressionList) {
                    IASTExpression[] _expressions = ((IASTExpressionList)expression).getExpressions();
                    Consumer<IASTExpression> _function_5 = new Consumer<IASTExpression>(){

                        @Override
                        public void accept(IASTExpression it) {
                            DependencyAnalysis.this.analyzeExpression(it);
                        }
                    };
                    ((List)Conversions.doWrapArray((Object)_expressions)).forEach(_function_5);
                } else {
                    IASTNode[] _children_1;
                    int _size_1;
                    boolean _greaterThan_1;
                    boolean _notEquals_4;
                    boolean _and = false;
                    IASTNode[] _children = expression.getChildren();
                    boolean bl = _notEquals_4 = !Objects.equal((Object)_children, null);
                    _and = !_notEquals_4 ? false : (_greaterThan_1 = (_size_1 = ((List)Conversions.doWrapArray((Object)(_children_1 = expression.getChildren()))).size()) > 0);
                    if (_and) {
                        IASTNode[] _children_2 = expression.getChildren();
                        Consumer<IASTNode> _function_6 = new Consumer<IASTNode>(){

                            @Override
                            public void accept(IASTNode it) {
                                if (it instanceof IASTExpression) {
                                    DependencyAnalysis.this.analyzeExpression((IASTExpression)it);
                                }
                            }
                        };
                        ((List)Conversions.doWrapArray((Object)_children_2)).forEach(_function_6);
                    }
                }
            }
        }
        return ret;
    }

    private Type getArgumentType(IASTInitializerClause argument) {
        Type argType = null;
        if (argument instanceof IASTExpression) {
            Type _analyzeExpression;
            argType = _analyzeExpression = this.analyzeExpression((IASTExpression)argument);
        }
        return argType;
    }

    private void analyzeStatement(IASTForStatement statement) {
    }

    private void analyzeStatement(IASTReturnStatement statement) {
    }

    private void analyzeStatement(IASTSwitchStatement statement) {
        IASTStatement body = statement.getBody();
        this.analyzeStatement(body);
    }

    private void analyzeStatement(IASTWhileStatement statement) {
        IASTStatement _body = statement.getBody();
        this.analyzeStatement(_body);
    }

    private void analyzeStatement(IASTIfStatement statement) {
        IASTStatement _elseClause;
        boolean _notEquals_1;
        boolean _notEquals;
        IASTExpression _conditionExpression = statement.getConditionExpression();
        this.analyzeExpression(_conditionExpression);
        IASTStatement _thenClause = statement.getThenClause();
        boolean bl = _notEquals = !Objects.equal((Object)_thenClause, null);
        if (_notEquals) {
            IASTStatement _thenClause_1 = statement.getThenClause();
            this.analyzeStatement(_thenClause_1);
        }
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)(_elseClause = statement.getElseClause()), null);
        if (_notEquals_1) {
            IASTStatement _elseClause_1 = statement.getElseClause();
            this.analyzeStatement(_elseClause_1);
        }
    }
}

