package org.eclipse.papyrus.designer.components.transformation.cpp.xtend;

import com.google.common.base.Objects;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class CppUtils {
  public static String nameRef(final Property part) {
    String _name = part.getName();
    String _derefOp = CppUtils.derefOp(part);
    return (_name + _derefOp);
  }

  /**
   * return the operator for (de-) referencing a part, depending on
   * whether it is a pointer or a "normal" attribute
   * 
   * @param part
   * @return -> or .
   */
  public static String derefOp(final Property attribute) {
    String _xifexpression = null;
    boolean _isRef = CppUtils.isRef(attribute);
    if (_isRef) {
      _xifexpression = "->";
    } else {
      _xifexpression = ".";
    }
    return _xifexpression;
  }

  /**
   * @return true, if attribute is a pointer.
   */
  public static boolean isRef(final Property attribute) {
    return (Objects.equal(attribute.getAggregation(), AggregationKind.SHARED_LITERAL) || StereotypeUtil.isApplied(attribute, Ptr.class));
  }

  /**
   * @return reference of an attribute
   */
  public static String getRef(final Property attribute) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isRef = CppUtils.isRef(attribute);
      if (_isRef) {
        _builder.append("&");
      }
    }
    String _name = attribute.getName();
    _builder.append(_name);
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }
}
