/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.c.codegen.utils;

import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.designer.languages.c.codegen.Activator;
import org.eclipse.papyrus.designer.languages.c.codegen.utils.Messages;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangProjectSupport;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.LanguageProjectSupport;
import org.eclipse.papyrus.designer.uml.tools.utils.PackageUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;

public class LocateCProject {
    public static final String LANGUAGE_NAME = "C";
    private static final boolean Headless = Boolean.getBoolean("papyrus.run-headless");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IProject getTargetProject(PackageableElement pe, boolean createIfMissing) {
        IProject modelProject;
        block13: {
            IEclipsePreferences prefs;
            String prefix;
            String projectName;
            Package rootPkg = PackageUtil.getRootPackage((Element)pe);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            modelProject = root.getProject(projectName = String.valueOf(prefix = (prefs = InstanceScope.INSTANCE.getNode("org.eclipse.papyrus.designer.languages.c.codegen")) != null ? prefs.get("projectPrefix", "org.eclipse.papyrus.cgen.") : "bad preferences") + rootPkg.getName());
            if (!modelProject.exists()) {
                if (Headless) {
                    try {
                        modelProject.create(null);
                    }
                    catch (CoreException e) {
                        return null;
                    }
                } else {
                    if (!createIfMissing) return null;
                    if (!LocateCProject.openQuestion(Messages.LocateCProject_CreateTargetProjectTitle, String.format(Messages.LocateCProject_CreateTargetProjectDesc, projectName))) return null;
                    boolean bl = true;
                    boolean create = bl;
                    if (!create) return null;
                    ILangProjectSupport langSupport = LanguageProjectSupport.getProjectSupport((String)LANGUAGE_NAME);
                    if (langSupport == null) return null;
                    modelProject = langSupport.createProject(projectName);
                    if (modelProject == null) {
                        return null;
                    }
                    langSupport.setSettings(modelProject, langSupport.initialConfigurationData());
                }
            }
            if (!modelProject.isOpen()) {
                try {
                    modelProject.open(null);
                }
                catch (CoreException e) {
                    return null;
                }
            }
            if (modelProject.hasNature("org.eclipse.cdt.core.cnature")) return modelProject;
            if (!createIfMissing) return null;
            if (!Headless) {
                if (!LocateCProject.openQuestion(Messages.LocateCProject_ApplyCNatureTitle, Messages.LocateCProject_ApplyCNatureDesc)) return null;
            }
            boolean bl = true;
            boolean apply = bl;
            if (apply) break block13;
            return null;
        }
        try {
            CProjectNature.addCNature((IProject)modelProject, null);
            return modelProject;
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
        return modelProject;
    }

    private static boolean openQuestion(final String title, final String message) {
        final boolean[] ret = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ret[0] = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
            }
        });
        return ret[0];
    }
}

