/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.listener;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.papyrus.designer.languages.common.base.codesync.SyncStatus;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.Activator;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.listener.OperationHistoryListener;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;

public class ModelListener
implements IPapyrusListener {
    static EList<Classifier> regenList = new UniqueEList();

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        int eventType = notification.getEventType();
        if (SyncStatus.syncFromEditor) {
            return;
        }
        if (eventType == 8 || eventType == 9) {
            return;
        }
        OperationHistoryListener.init();
        try {
            if (notifier instanceof Classifier) {
                Classifier classifier = (Classifier)notifier;
                if (eventType == 4 || eventType == 31 || eventType == 32 || eventType == 33) {
                    ModelListener.addtoList(ModelListener.getNearestClassifier((Element)classifier));
                }
            }
            if (notifier instanceof Behavior) {
                Behavior behavior = (Behavior)notifier;
                if (eventType == 1) {
                    behavior.getSpecification();
                } else if (eventType == 3) {
                    Classifier nearestCl = ModelListener.getNearestClassifier((Element)behavior);
                    ModelListener.addtoList(nearestCl);
                }
            } else if (notifier instanceof Feature) {
                Feature feature = (Feature)notifier;
                Element owner = feature.getOwner();
                if (owner instanceof Classifier) {
                    ModelListener.addtoList(ModelListener.getNearestClassifier(owner));
                }
            } else if (notifier instanceof Parameter) {
                Parameter parameter = (Parameter)notifier;
                ModelListener.addtoList(ModelListener.getNearestClassifier((Element)parameter));
            } else if (notifier instanceof DirectedRelationship) {
                DirectedRelationship dr = (DirectedRelationship)notifier;
                for (Element client : dr.getSources()) {
                    if (!(client instanceof Classifier)) continue;
                    ModelListener.addtoList(ModelListener.getNearestClassifier(client));
                }
            } else {
                boolean cfr_ignored_0 = notifier instanceof Package;
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    public static Classifier getNearestClassifier(Element element) {
        while (element != null) {
            if (!(element instanceof Behavior) && element instanceof Classifier) {
                return (Classifier)element;
            }
            element = element.getOwner();
        }
        return null;
    }

    static void addtoList(Classifier cl) {
        if (cl != null) {
            regenList.add((Object)cl);
        }
    }
}

