/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.umlparser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.External;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Final;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Native;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.StaticClassifier;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Strictfp;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Synchronized;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Transient;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Variadic;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Volatile;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.CompilationUnit;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.ImportDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.Node;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.PackageDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.BodyDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.ConstructorDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.EnumConstantDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.EnumDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.FieldDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.MethodDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.ModifierSet;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.Parameter;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.TypeDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.VariableDeclarator;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.comments.Comment;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.AnnotationExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.Expression;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.NameExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.QualifiedNameExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.BlockStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.ClassOrInterfaceType;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.PrimitiveType;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.ReferenceType;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.VoidType;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.WildcardType;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.visitor.VoidVisitorAdapter;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.ClassifierCatalog;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.CreationPackageCatalog;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.GenericSwitchVisitor;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.ImportedTypeCatalog;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.SwitchVisitor;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.TypeAnalyser;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.TypeAnalyserAndTranslator;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.UmlUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CompilationUnitAnalyser {
    public static String DEFAULT_GENERATION_PACKAGE_NAME = "generated";
    public static String DEFAULT_ROOT_PACKAGE_NAME = "model";
    private List<String> generationPackageQualifiedName;
    private Model rootModel;
    private Package defaultGenerationPackage;
    private CreationPackageCatalog creationPackageCatalog;
    private ClassifierCatalog classifierCatalog;
    private ImportedTypeCatalog importedTypes;
    private Package currentCompilationUnitPackage;
    private List<Namespace> enclosingNamespaces = new ArrayList<Namespace>();
    private QualifiedNameParser qualifiedNameParser = new QualifiedNameParser();
    private TypeAnalyserAndTranslator typeAnalyser;
    private List<String> qualifiedNamesInProjects;

    public CompilationUnitAnalyser(Resource model) {
        this(model, DEFAULT_ROOT_PACKAGE_NAME, DEFAULT_GENERATION_PACKAGE_NAME, null, null);
    }

    public CompilationUnitAnalyser(Resource model, String generatePackageName, List<String> searchPaths, List<String> creationPaths) {
        this(model, DEFAULT_ROOT_PACKAGE_NAME, generatePackageName, searchPaths, creationPaths);
    }

    public CompilationUnitAnalyser(Resource model, String modelRootPackageName, String generatePackageName, List<String> searchPaths, List<String> creationPaths) {
        if (model instanceof Model) {
            this.rootModel = (Model)model;
        }
        Package modelRootPackage = UmlUtils.getPackage(model, this.dirToQualifiedName(modelRootPackageName));
        this.initCompilationUnitAnalyser(modelRootPackage, generatePackageName, searchPaths, creationPaths, null);
    }

    public CompilationUnitAnalyser(Package modelRootPackage, String generatePackageName, List<String> searchPaths, List<String> creationPaths, List<String> qualifiedNamesInProjects) {
        if (modelRootPackage instanceof Model) {
            this.rootModel = (Model)modelRootPackage;
        }
        this.initCompilationUnitAnalyser(modelRootPackage, generatePackageName, searchPaths, creationPaths, qualifiedNamesInProjects);
    }

    public ClassifierCatalog getClassifierCatalog() {
        return this.classifierCatalog;
    }

    public Model getRootModel() {
        return this.rootModel;
    }

    private void initCompilationUnitAnalyser(Package modelRootPackage, String generatePackageName, List<String> searchPaths, List<String> creationPaths, List<String> qualifiedNamesInProjects) {
        this.qualifiedNamesInProjects = qualifiedNamesInProjects;
        if (generatePackageName == null) {
            generatePackageName = DEFAULT_GENERATION_PACKAGE_NAME;
        }
        this.generationPackageQualifiedName = this.dirToQualifiedName(generatePackageName);
        searchPaths = searchPaths != null ? new ArrayList<String>(searchPaths) : new ArrayList<String>();
        creationPaths = creationPaths != null ? new ArrayList<String>(creationPaths) : new ArrayList<String>();
        if (!searchPaths.contains(generatePackageName)) {
            searchPaths.add(generatePackageName);
        }
        System.out.println(String.valueOf(this.getClass().getSimpleName()) + ".CT(" + this.generationPackageQualifiedName + ", sarchpaths=" + searchPaths + ")");
        this.createDefaultGenerationPackage(modelRootPackage);
        this.classifierCatalog = new ClassifierCatalog(modelRootPackage, searchPaths);
        this.importedTypes = new ImportedTypeCatalog();
        this.creationPackageCatalog = new CreationPackageCatalog(modelRootPackage, this.defaultGenerationPackage, creationPaths);
        this.typeAnalyser = new TypeAnalyserAndTranslator(this.importedTypes);
    }

    private List<String> dirToQualifiedName(String qname) {
        String[] splittedName = qname.split("/");
        return Arrays.asList(splittedName);
    }

    private void createDefaultGenerationPackage(Package rootModelElement) {
        Package p;
        this.defaultGenerationPackage = this.generationPackageQualifiedName.size() == 1 && this.generationPackageQualifiedName.get(0).isEmpty() ? rootModelElement : (p = UmlUtils.getPackage(rootModelElement, this.generationPackageQualifiedName));
    }

    public void processCompilationUnit(CompilationUnit cu) {
        this.currentCompilationUnitPackage = this.getCuPackage(cu.getPackage());
        this.classifierCatalog.setCurrentCompilationUnitPackage(this.currentCompilationUnitPackage);
        this.importedTypes.clear();
        if (cu.getImports() != null) {
            this.addImports(this.importedTypes, cu.getImports());
        }
        if (cu.getTypes() != null) {
            for (TypeDeclaration typeDecl : cu.getTypes()) {
                this.enclosingNamespaces.add((Namespace)this.currentCompilationUnitPackage);
                this.processTypedeclaration(this.enclosingNamespaces, typeDecl);
                this.enclosingNamespaces.clear();
            }
        }
    }

    private void processTypedeclaration(final List<Namespace> enclosingParents, TypeDeclaration typeDecl) {
        Classifier classifier = (Classifier)new GenericSwitchVisitor<Classifier, List<Namespace>>(){

            @Override
            public Classifier visit(ClassOrInterfaceDeclaration n, List<Namespace> enclosingParents) {
                return CompilationUnitAnalyser.this.processClassOrInterfaceDeclaration(n, enclosingParents);
            }

            @Override
            public Classifier visit(EnumDeclaration n, List<Namespace> enclosingParents) {
                return CompilationUnitAnalyser.this.processEnumDeclaration(n, enclosingParents);
            }
        }.doSwitch(typeDecl, enclosingParents);
        if (classifier == null) {
            return;
        }
        this.createModifiers(classifier, typeDecl.getModifiers());
        if (typeDecl.getMembers() != null) {
            if (typeDecl instanceof EnumDeclaration) {
                for (EnumConstantDeclaration enumConstant : ((EnumDeclaration)typeDecl).getEntries()) {
                    new SwitchVisitor<Type>(){

                        @Override
                        public void visit(EnumConstantDeclaration n, Type classifier) {
                            CompilationUnitAnalyser.this.processEnumConstant(n, classifier);
                        }
                    }.doSwitch(enumConstant, (Type)classifier);
                }
            }
            for (BodyDeclaration member : typeDecl.getMembers()) {
                new SwitchVisitor<Type>(){

                    @Override
                    public void visit(FieldDeclaration n, Type classifier) {
                        CompilationUnitAnalyser.this.createAttributes(n, classifier);
                    }

                    @Override
                    public void visit(MethodDeclaration n, Type classifier) {
                        CompilationUnitAnalyser.this.processMethod(n, (Classifier)classifier);
                    }

                    @Override
                    public void visit(ConstructorDeclaration n, Type classifier) {
                        CompilationUnitAnalyser.this.processConstructor(n, (Classifier)classifier);
                    }

                    @Override
                    public void visit(ClassOrInterfaceDeclaration n, Type classifier) {
                        System.out.println("Found nested class (ClassOrInterface)'" + n.getName() + "'");
                        enclosingParents.add((Classifier)classifier);
                        CompilationUnitAnalyser.this.processTypedeclaration(enclosingParents, n);
                        enclosingParents.remove((Classifier)classifier);
                        super.visit(n, classifier);
                    }

                    @Override
                    public void visit(EnumDeclaration n, Type classifier) {
                        enclosingParents.add((Classifier)classifier);
                        CompilationUnitAnalyser.this.processTypedeclaration(enclosingParents, n);
                        enclosingParents.remove((Classifier)classifier);
                        super.visit(n, classifier);
                    }
                }.doSwitch(member, (Type)classifier);
            }
        }
    }

    private void addImports(ImportedTypeCatalog importedTypes, List<ImportDeclaration> imports) {
        for (ImportDeclaration decl : imports) {
            List<String> qualifiedName = this.qualifiedNameParser.getImportQualifiedName(decl);
            if (decl.isAsterisk()) {
                importedTypes.addStarImport(qualifiedName);
                continue;
            }
            importedTypes.addImport(qualifiedName);
        }
    }

    private Classifier getUmlClassifier(List<String> qualifiedName, boolean isInterface) {
        Classifier foundClass = this.classifierCatalog.getClassifier(qualifiedName);
        if (foundClass == null) {
            EClass expectedType = isInterface ? UMLPackage.eINSTANCE.getInterface() : UMLPackage.eINSTANCE.getClass_();
            if (this.importedTypes.isImportedType(qualifiedName) || qualifiedName.size() > 1) {
                Package creationPackage = this.creationPackageCatalog.getCreationPackage(qualifiedName, this.qualifiedNamesInProjects);
                foundClass = (Classifier)UmlUtils.getClassifier(creationPackage, qualifiedName, expectedType);
            } else {
                foundClass = UmlUtils.getGuessedClassifier(this.enclosingNamespaces, qualifiedName, expectedType);
            }
        }
        this.handleExternalType(qualifiedName, foundClass);
        return foundClass;
    }

    private void handleExternalType(List<String> qualifiedName, Classifier foundClass) {
        if (qualifiedName != null && foundClass != null) {
            if (qualifiedName.size() > 1) {
                String flatQualifiedName = this.creationPackageCatalog.toFlatQualifiedName(qualifiedName);
                if (this.qualifiedNamesInProjects != null && !this.qualifiedNamesInProjects.contains(flatQualifiedName)) {
                    this.applyExternalStereotypes(foundClass, qualifiedName);
                }
            } else if (qualifiedName.size() == 1 && !this.shortNameInQualifiedNamesOfProjects(qualifiedName)) {
                this.applyExternalStereotypes(foundClass, qualifiedName);
            }
        }
    }

    private boolean shortNameInQualifiedNamesOfProjects(List<String> qualifiedName) {
        if (this.qualifiedNamesInProjects == null || qualifiedName == null) {
            return false;
        }
        String flatQualifiedName = this.creationPackageCatalog.toFlatQualifiedName(qualifiedName);
        if (qualifiedName.size() > 0) {
            for (String qualifiedNameInProjects : this.qualifiedNamesInProjects) {
                if (!qualifiedNameInProjects.endsWith(flatQualifiedName)) continue;
                return true;
            }
        }
        return false;
    }

    private void applyExternalStereotypes(Classifier foundClass, List<String> qualifiedName) {
        External externalStereotype = (External)UMLUtil.getStereotypeApplication((Element)foundClass, External.class);
        if (externalStereotype == null) {
            StereotypeUtil.apply((Element)foundClass, External.class);
            externalStereotype = (External)UMLUtil.getStereotypeApplication((Element)foundClass, External.class);
        }
        externalStereotype.setName(this.creationPackageCatalog.toFlatQualifiedName(qualifiedName));
    }

    private List<String> getQualifiedName(ClassOrInterfaceType astType) {
        QualifiedNameParser visitor = new QualifiedNameParser();
        List<String> res = visitor.getClassOrInterfaceQualifiedName(astType);
        return res;
    }

    protected void createAttributes(FieldDeclaration n, Type parent) {
        System.out.println("getAttributeType( from:" + n.getType().getClass().getName() + ")");
        TypeAnalyserAndTranslator.TranslatedTypeData typeData = this.processType(n.getType());
        Type umlType = this.getUmlType(typeData);
        for (VariableDeclarator var : n.getVariables()) {
            if (!(parent instanceof Classifier)) continue;
            this.createAttribute(n, var, (Classifier)parent, umlType, typeData);
        }
    }

    protected void processEnumConstant(EnumConstantDeclaration n, Type parent) {
        if (parent instanceof Enumeration) {
            EnumerationLiteral enumLiteral = (EnumerationLiteral)((Enumeration)parent).getMember(n.getName(), false, UMLPackage.eINSTANCE.getEnumerationLiteral());
            if (enumLiteral == null) {
                enumLiteral = ((Enumeration)parent).createOwnedLiteral(n.getName());
            }
            if (enumLiteral != null && n.getArgs() != null && n.getArgs().size() > 0) {
                String arguments = "";
                int i = 0;
                while (i < n.getArgs().size() - 1) {
                    arguments = String.valueOf(arguments) + n.getArgs().get(i) + ", ";
                    ++i;
                }
                if (!(arguments = String.valueOf(arguments) + n.getArgs().get(n.getArgs().size() - 1)).isEmpty()) {
                    ValueSpecification specification = enumLiteral.getSpecification();
                    if (!(specification instanceof OpaqueExpression)) {
                        if (specification != null) {
                            enumLiteral.setSpecification(null);
                        }
                        specification = enumLiteral.createSpecification("specification", null, UMLPackage.eINSTANCE.getOpaqueExpression());
                    }
                    OpaqueExpression opaqueExpression = (OpaqueExpression)specification;
                    this.addLanguageBody("JAVA", arguments, (List<String>)opaqueExpression.getLanguages(), (List<String>)opaqueExpression.getBodies());
                }
            }
        }
    }

    private TypeAnalyserAndTranslator.TranslatedTypeData processType(org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.Type astType) {
        TypeAnalyserAndTranslator.TranslatedTypeData data = this.typeAnalyser.getTranslatedTypeData(astType);
        return data;
    }

    private Type getUmlType(TypeAnalyserAndTranslator.TranslatedTypeData data) {
        org.eclipse.uml2.uml.PrimitiveType umlType;
        block30: {
            List<String> potentialQualifiedName;
            block29: {
                umlType = null;
                if (!data.isPrimitive) break block29;
                Package javaPrimitivesModel = UmlUtils.importOrGetModel(this.rootModel, "pathmap://PapyrusJava_LIBRARIES/JavaLibrary.uml");
                String primitiveName = TypeAnalyser.wrapperToPrimitive(data);
                umlType = primitiveName != null && !primitiveName.isEmpty() ? UmlUtils.getImportedPrimitive(javaPrimitivesModel, primitiveName) : UmlUtils.getImportedPrimitive(javaPrimitivesModel, (String)data.qualifiedName.get(data.qualifiedName.size() - 1));
                if (umlType == null && (umlType = this.classifierCatalog.getClassifier(data.qualifiedName)) == null) {
                    Package creationPackage = this.creationPackageCatalog.getCreationPackage(data.qualifiedName, this.qualifiedNamesInProjects);
                    umlType = UmlUtils.getPrimitive(creationPackage, data.qualifiedName);
                }
                break block30;
            }
            if (data.isVoid || data.isWildcard) {
                return null;
            }
            List<String> qualifiedName = data.getTranslatedQualifiedName();
            boolean isInterface = false;
            String shortName = qualifiedName.get(qualifiedName.size() - 1);
            boolean isPrimitiveWrapper = false;
            switch (shortName) {
                case "Integer": 
                case "Byte": 
                case "Char": 
                case "Long": 
                case "Float": 
                case "Short": 
                case "Boolean": 
                case "Double": {
                    isPrimitiveWrapper = true;
                    break;
                }
                default: {
                    isPrimitiveWrapper = false;
                }
            }
            if (isPrimitiveWrapper && (potentialQualifiedName = this.importedTypes.getQualifiedName(shortName)) != null && potentialQualifiedName.size() == qualifiedName.size()) {
                Package javaPrimitivesModel;
                int i = 0;
                while (i < potentialQualifiedName.size()) {
                    if (!potentialQualifiedName.get(i).equals(qualifiedName.get(i))) {
                        isPrimitiveWrapper = false;
                        break;
                    }
                    ++i;
                }
                if (isPrimitiveWrapper && (umlType = UmlUtils.getImportedPrimitive(javaPrimitivesModel = UmlUtils.importOrGetModel(this.rootModel, "pathmap://PapyrusJava_LIBRARIES/JavaLibrary.uml"), shortName)) == null) {
                    isPrimitiveWrapper = false;
                }
            }
            if (!isPrimitiveWrapper) {
                if (shortName.length() > 2 && shortName.startsWith("I") && Character.isUpperCase(shortName.charAt(1))) {
                    isInterface = true;
                }
                umlType = this.getUmlClassifier(qualifiedName, isInterface);
            }
        }
        return umlType;
    }

    protected TypeData getAttributeType(org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.Type astType) {
        TypeData res = new TypeData();
        new SwitchVisitor<TypeData>(){

            @Override
            public void visit(ClassOrInterfaceType n, TypeData data) {
                List<String> qnameBefore = CompilationUnitAnalyser.this.getQualifiedName(n);
                List<String> qname = CompilationUnitAnalyser.this.importedTypes.getQualifiedName(qnameBefore);
                data.qualifiedName = qname;
                if (n.getTypeArgs() != null) {
                    data.genericData = new ArrayList<TypeData>();
                    for (org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.Type arg : n.getTypeArgs()) {
                        TypeData argData = new TypeData();
                        arg.accept(this, argData);
                        data.genericData.add(argData);
                    }
                }
            }

            @Override
            public void visit(ReferenceType n, TypeData data) {
                data.arrayCount = n.getArrayCount();
                n.getType().accept(this, data);
            }

            @Override
            public void visit(PrimitiveType n, TypeData data) {
                String qnameBefore = CompilationUnitAnalyser.this.getPrimitiveName(n);
                List<String> qname = CompilationUnitAnalyser.this.importedTypes.getQualifiedName(qnameBefore);
                data.qualifiedName = qname;
                data.isPrimitive = true;
            }

            @Override
            public void visit(WildcardType n, TypeData data) {
                data.isWildcard = true;
                if (n.getExtends() != null) {
                    data.extends_ = new TypeData();
                    n.getExtends().accept(this, data.extends_);
                }
                if (n.getSuper() != null) {
                    data.super_ = new TypeData();
                    n.getSuper().accept(this, data.super_);
                }
            }

            @Override
            public void visit(VoidType n, TypeData data) {
                data.isVoid = true;
            }
        }.doSwitch(astType, res);
        return res;
    }

    protected String getPrimitiveName(PrimitiveType n) {
        String typeName = null;
        switch (n.getType()) {
            case Boolean: {
                typeName = "Boolean";
                break;
            }
            case Byte: {
                typeName = "Byte";
                break;
            }
            case Char: {
                typeName = "Char";
                break;
            }
            case Double: {
                typeName = "Double";
                break;
            }
            case Float: {
                typeName = "Float";
                break;
            }
            case Int: {
                typeName = "Integer";
                break;
            }
            case Long: {
                typeName = "Long";
                break;
            }
            case Short: {
                typeName = "Short";
            }
        }
        return typeName;
    }

    protected void createAttribute(FieldDeclaration n, VariableDeclarator var, Classifier parent, Type type, TypeAnalyserAndTranslator.TranslatedTypeData typeData) {
        Expression init;
        Property property = UmlUtils.createProperty(parent, null, var.getId().getName(), var.getId().getArrayCount());
        property.setType(type);
        this.processJavadoc(n.getJavaDoc(), (Element)property);
        this.processModifiers(n.getModifiers(), (Feature)property);
        if (typeData.isCollection()) {
            property.setLower(typeData.getTranslatedLower());
            property.setUpper(typeData.getTranslatedUpper());
        }
        if ((init = var.getInit()) != null) {
            ValueSpecification defaultValue = property.getDefaultValue();
            if (!(defaultValue instanceof OpaqueExpression)) {
                if (defaultValue != null) {
                    property.setDefaultValue(null);
                }
                defaultValue = property.createDefaultValue("defaultValue", null, UMLPackage.eINSTANCE.getOpaqueExpression());
            }
            OpaqueExpression opaqueExpression = (OpaqueExpression)defaultValue;
            this.addLanguageBody("JAVA", init.toString(), (List<String>)opaqueExpression.getLanguages(), (List<String>)opaqueExpression.getBodies());
        }
    }

    private void processModifiers(int modifiers, Operation property) {
        if (ModifierSet.isAbstract(modifiers)) {
            property.setIsAbstract(true);
        }
        if (ModifierSet.isNative(modifiers) && UMLUtil.getStereotypeApplication((Element)property, Native.class) == null) {
            StereotypeUtil.apply((Element)property, Native.class);
        }
        if (ModifierSet.isStrictfp(modifiers) && UMLUtil.getStereotypeApplication((Element)property, Strictfp.class) == null) {
            StereotypeUtil.apply((Element)property, Strictfp.class);
        }
        if (ModifierSet.isSynchronized(modifiers) && UMLUtil.getStereotypeApplication((Element)property, Synchronized.class) == null) {
            StereotypeUtil.apply((Element)property, Synchronized.class);
        }
        this.processModifiers(modifiers, (Feature)property);
    }

    private void processModifiers(int modifiers, Feature property) {
        property.setVisibility(VisibilityKind.PRIVATE_LITERAL);
        if (ModifierSet.isPrivate(modifiers)) {
            property.setVisibility(VisibilityKind.PRIVATE_LITERAL);
        }
        if (ModifierSet.isProtected(modifiers)) {
            property.setVisibility(VisibilityKind.PROTECTED_LITERAL);
        }
        if (ModifierSet.isPublic(modifiers)) {
            property.setVisibility(VisibilityKind.PUBLIC_LITERAL);
        }
        if (ModifierSet.isStatic(modifiers)) {
            property.setIsStatic(true);
        }
        if (ModifierSet.isFinal(modifiers)) {
            property.setIsLeaf(true);
        }
        if (property instanceof Property) {
            if (ModifierSet.isTransient(modifiers) && UMLUtil.getStereotypeApplication((Element)property, Transient.class) == null) {
                StereotypeUtil.apply((Element)property, Transient.class);
            }
            if (ModifierSet.isVolatile(modifiers) && UMLUtil.getStereotypeApplication((Element)property, Volatile.class) == null) {
                StereotypeUtil.apply((Element)property, Volatile.class);
            }
        }
    }

    private void processModifiers(int modifiers, org.eclipse.uml2.uml.Parameter property) {
        if (ModifierSet.isFinal(modifiers) && UMLUtil.getStereotypeApplication((Element)property, Final.class) == null) {
            StereotypeUtil.apply((Element)property, Final.class);
        }
    }

    private void addLanguageBody(String language, String body, List<String> languages, List<String> bodies) {
        int i = -1;
        int j = 0;
        while (j < languages.size()) {
            if (languages.get(j).equalsIgnoreCase(language)) {
                i = j;
                break;
            }
            ++j;
        }
        if (i == -1) {
            languages.add(language);
            i = languages.indexOf(language);
        }
        if (bodies.size() >= languages.size()) {
            bodies.set(i, body);
        } else {
            bodies.add(body);
        }
    }

    protected void processMethod(MethodDeclaration n, Classifier classifier) {
        BlockStmt bodyBlock;
        ArrayList<Type> signature = new ArrayList<Type>();
        if (n.getParameters() != null) {
            ArrayList<MethodParameterData> paramDatas = new ArrayList<MethodParameterData>();
            for (Parameter param : n.getParameters()) {
                MethodParameterData data = new MethodParameterData();
                data.dataType = this.processType(param.getType());
                data.umlType = this.getUmlType(data.dataType);
                paramDatas.add(data);
                signature.add(data.umlType);
            }
        }
        Operation method = this.getUmlOperation(classifier, n.getName(), signature);
        this.processJavadoc(n.getComment(), (Element)method);
        this.processAnnotation(n.getAnnotations(), (Element)method);
        this.processModifiers(n.getModifiers(), method);
        TypeAnalyserAndTranslator.TranslatedTypeData typeData = this.processType(n.getType());
        Type methodType = this.getUmlType(typeData);
        if (methodType != null) {
            method.setType(methodType);
            if (typeData.isCollection()) {
                method.setLower(typeData.getTranslatedLower());
                method.setUpper(typeData.getTranslatedUpper());
            }
        }
        if (n.getParameters() != null) {
            for (Parameter param : n.getParameters()) {
                this.processMethodParameter(param, method);
            }
        }
        if (n.getThrows() != null) {
            for (ReferenceType thrown : n.getThrows()) {
                TypeAnalyserAndTranslator.TranslatedTypeData exceptionTypeData = this.processType(thrown);
                Type exceptionUmlType = this.getUmlType(exceptionTypeData);
                if (exceptionUmlType == null || method.getRaisedExceptions().contains((Object)exceptionUmlType)) continue;
                method.getRaisedExceptions().add((Object)exceptionUmlType);
            }
        }
        if ((bodyBlock = n.getBody()) != null) {
            String bodyString = bodyBlock.toString();
            if (bodyString.length() > 1) {
                bodyString = bodyString.substring(0, bodyString.length() - 1);
                bodyString = bodyString.replaceFirst("\\{", "");
            }
            boolean setBody = false;
            for (Behavior behavior : method.getMethods()) {
                OpaqueBehavior opaqueBehavior;
                if (behavior instanceof OpaqueBehavior && (opaqueBehavior = (OpaqueBehavior)behavior).getBodies().size() >= opaqueBehavior.getLanguages().size()) {
                    int i = 0;
                    while (i < opaqueBehavior.getLanguages().size()) {
                        if (((String)opaqueBehavior.getLanguages().get(i)).equalsIgnoreCase("JAVA")) {
                            opaqueBehavior.getBodies().set(i, (Object)bodyString);
                            setBody = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (setBody) break;
            }
            if (!setBody && method.getOwner() instanceof BehavioredClassifier) {
                BehavioredClassifier clazz = (BehavioredClassifier)method.getOwner();
                OpaqueBehavior opaqueBehavior = (OpaqueBehavior)clazz.createOwnedBehavior(method.getName(), UMLPackage.eINSTANCE.getOpaqueBehavior());
                opaqueBehavior.getLanguages().add((Object)"JAVA");
                opaqueBehavior.getBodies().add((Object)bodyString);
                opaqueBehavior.setSpecification((BehavioralFeature)method);
            }
        }
    }

    protected void processConstructor(ConstructorDeclaration n, Classifier classifier) {
        BlockStmt bodyBlock;
        Operation method;
        ArrayList<Type> signature = new ArrayList<Type>();
        if (n.getParameters() != null) {
            ArrayList<MethodParameterData> paramDatas = new ArrayList<MethodParameterData>();
            for (Parameter param : n.getParameters()) {
                MethodParameterData data = new MethodParameterData();
                data.dataType = this.processType(param.getType());
                data.umlType = this.getUmlType(data.dataType);
                paramDatas.add(data);
                signature.add(data.umlType);
            }
        }
        if (UMLUtil.getStereotypeApplication((Element)(method = this.getUmlOperation(classifier, n.getName(), signature)), Create.class) == null) {
            StereotypeUtil.apply((Element)method, Create.class);
        }
        this.processJavadoc(n.getComment(), (Element)method);
        this.processAnnotation(n.getAnnotations(), (Element)method);
        this.processModifiers(n.getModifiers(), method);
        if (n.getParameters() != null) {
            for (Parameter param : n.getParameters()) {
                this.processMethodParameter(param, method);
            }
        }
        if (n.getThrows() != null) {
            for (NameExpr thrown : n.getThrows()) {
                String thrownString = thrown.toString();
                String[] tokens = thrownString.split("\\.");
                List<String> qualifiedName = Arrays.asList(tokens);
                if (qualifiedName.size() == 1) {
                    qualifiedName = this.importedTypes.getQualifiedName((String)qualifiedName.get(0));
                }
                Classifier exceptionClass = this.getUmlClassifier(qualifiedName, false);
                if (method.getRaisedExceptions().contains((Object)exceptionClass)) continue;
                method.getRaisedExceptions().add((Object)exceptionClass);
            }
        }
        if ((bodyBlock = n.getBlock()) != null) {
            String bodyString = bodyBlock.toString();
            if (bodyString.length() > 1) {
                bodyString = bodyString.substring(0, bodyString.length() - 1);
                bodyString = bodyString.replaceFirst("\\{", "");
            }
            boolean setBody = false;
            for (Behavior behavior : method.getMethods()) {
                OpaqueBehavior opaqueBehavior;
                if (behavior instanceof OpaqueBehavior && (opaqueBehavior = (OpaqueBehavior)behavior).getLanguages().size() == opaqueBehavior.getBodies().size()) {
                    int i = 0;
                    while (i < opaqueBehavior.getLanguages().size()) {
                        if (((String)opaqueBehavior.getLanguages().get(i)).equalsIgnoreCase("JAVA")) {
                            opaqueBehavior.getBodies().set(i, (Object)bodyString);
                            setBody = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (setBody) break;
            }
            if (!setBody && method.getOwner() instanceof BehavioredClassifier) {
                BehavioredClassifier clazz = (BehavioredClassifier)method.getOwner();
                OpaqueBehavior opaqueBehavior = (OpaqueBehavior)clazz.createOwnedBehavior(method.getName(), UMLPackage.eINSTANCE.getOpaqueBehavior());
                opaqueBehavior.getLanguages().add((Object)"JAVA");
                opaqueBehavior.getBodies().add((Object)bodyString);
                opaqueBehavior.setSpecification((BehavioralFeature)method);
            }
        }
    }

    private Operation getUmlOperation(Classifier classifier, String name, List<Type> signature) {
        EList list = classifier.getOperations();
        for (Operation oper : list) {
            if (!this.isSameOperation(oper, name, signature)) continue;
            return oper;
        }
        return UmlUtils.createOperation(classifier, name);
    }

    private boolean isSameOperation(Operation oper, String name, List<Type> signature) {
        if (!name.equals(oper.getName())) {
            return false;
        }
        EList umlParams = oper.getOwnedParameters();
        if (signature == null) {
            return true;
        }
        if (umlParams == null) {
            return signature.size() == 0;
        }
        if (umlParams != null) {
            int umlParamIndex = 0;
            for (Type signatureType : signature) {
                try {
                    org.eclipse.uml2.uml.Parameter param = (org.eclipse.uml2.uml.Parameter)umlParams.get(umlParamIndex++);
                    while (param.getDirection() == ParameterDirectionKind.RETURN_LITERAL) {
                        param = (org.eclipse.uml2.uml.Parameter)umlParams.get(umlParamIndex++);
                    }
                    Type existingType = param.getType();
                    if (existingType == null || existingType.getName().equals(signatureType.getName())) continue;
                    return false;
                }
                catch (IndexOutOfBoundsException e) {
                    return false;
                }
            }
            while (umlParamIndex < umlParams.size()) {
                if (((org.eclipse.uml2.uml.Parameter)umlParams.get(umlParamIndex++)).getDirection() == ParameterDirectionKind.RETURN_LITERAL) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void processMethodParameter(Parameter param, Operation method) {
        TypeAnalyserAndTranslator.TranslatedTypeData typeData = this.processType(param.getType());
        Type type = this.getUmlType(typeData);
        System.out.println("getOwnedParameter(" + method.getName() + "= " + param.getId().getName() + ", " + type + " )");
        org.eclipse.uml2.uml.Parameter umlParameter = method.getOwnedParameter(param.getId().getName(), type, true, true);
        if (typeData.isCollection()) {
            umlParameter.setLower(typeData.getTranslatedLower());
            umlParameter.setUpper(typeData.getTranslatedUpper());
        }
        if (param.toString().contains("...") && UMLUtil.getStereotypeApplication((Element)umlParameter, Variadic.class) == null) {
            StereotypeUtil.apply((Element)umlParameter, Variadic.class);
        }
        this.processModifiers(param.getModifiers(), umlParameter);
        this.processAnnotation(param.getAnnotations(), (Element)method);
    }

    private void processAnnotation(List<AnnotationExpr> annotations, Element method) {
    }

    private void processJavadoc(Comment javaDoc, Element umlElement) {
    }

    protected Class createClass(List<Namespace> enclosingParents, ClassOrInterfaceDeclaration n) {
        System.out.println("getClass( " + n.getName() + " )");
        return UmlUtils.getClass(enclosingParents, n.getName());
    }

    protected Enumeration createEnumeration(List<Namespace> enclosingParents, EnumDeclaration n) {
        return UmlUtils.getEnumeration(enclosingParents, n.getName());
    }

    protected Interface createInterface(List<Namespace> enclosingParents, ClassOrInterfaceDeclaration n) {
        System.out.println("getInterface( " + n.getName() + " )");
        return UmlUtils.getInterface(enclosingParents, n.getName());
    }

    private Package getCuPackage(PackageDeclaration packageDecl) {
        if (packageDecl == null) {
            return this.defaultGenerationPackage;
        }
        List<String> qualifiedName = this.qualifiedNameParser.getPackageQualifiedName(packageDecl);
        Package creationPackage = this.creationPackageCatalog.getCreationPackage(qualifiedName, this.qualifiedNamesInProjects);
        Package p = UmlUtils.getPackage(creationPackage, qualifiedName);
        return p;
    }

    private void createModifiers(Classifier c, int modifiers) {
        if (ModifierSet.isPrivate(modifiers)) {
            c.setVisibility(VisibilityKind.PRIVATE_LITERAL);
        }
        if (ModifierSet.isProtected(modifiers)) {
            c.setVisibility(VisibilityKind.PROTECTED_LITERAL);
        }
        if (ModifierSet.isPublic(modifiers)) {
            c.setVisibility(VisibilityKind.PUBLIC_LITERAL);
        }
        if (ModifierSet.isAbstract(modifiers)) {
            c.setIsAbstract(true);
        }
        if (ModifierSet.isStatic(modifiers) && UMLUtil.getStereotypeApplication((Element)c, StaticClassifier.class) == null) {
            StereotypeUtil.apply((Element)c, StaticClassifier.class);
        }
        if (ModifierSet.isFinal(modifiers)) {
            c.setIsLeaf(true);
        }
        if (ModifierSet.isStrictfp(modifiers) && UMLUtil.getStereotypeApplication((Element)c, Strictfp.class) == null) {
            StereotypeUtil.apply((Element)c, Strictfp.class);
        }
    }

    private Classifier processClassOrInterfaceDeclaration(ClassOrInterfaceDeclaration n, List<Namespace> enclosingParents) {
        Classifier generalization;
        List<String> qualifiedName;
        Object processedClass = n.isInterface() ? this.createInterface(enclosingParents, n) : this.createClass(enclosingParents, n);
        this.processJavadoc(n.getComment(), (Element)processedClass);
        if (n.getExtends() != null) {
            for (ClassOrInterfaceType type : n.getExtends()) {
                qualifiedName = this.getQualifiedName(type);
                qualifiedName = this.importedTypes.getQualifiedName(qualifiedName);
                generalization = this.getUmlClassifier(qualifiedName, n.isInterface());
                UmlUtils.getGeneralization((Classifier)processedClass, generalization);
            }
        }
        if (n.getImplements() != null) {
            for (ClassOrInterfaceType type : n.getImplements()) {
                qualifiedName = this.getQualifiedName(type);
                generalization = this.getUmlClassifier(qualifiedName = this.importedTypes.getQualifiedName(qualifiedName), true);
                if (generalization instanceof Interface && processedClass instanceof BehavioredClassifier) {
                    UmlUtils.getInterfaceRealization((BehavioredClassifier)processedClass, (Interface)generalization);
                    continue;
                }
                UmlUtils.getGeneralization((Classifier)processedClass, generalization);
            }
        }
        return processedClass;
    }

    private Enumeration processEnumDeclaration(EnumDeclaration n, List<Namespace> enclosingParents) {
        Enumeration processedClass = this.createEnumeration(enclosingParents, n);
        this.processJavadoc(n.getJavaDoc(), (Element)processedClass);
        return processedClass;
    }

    protected class CreatePackage
    extends VoidVisitorAdapter<List<String>> {
        protected CreatePackage() {
        }

        public Package getPackage(PackageDeclaration decl, Package parent) {
            ArrayList names = new ArrayList();
            decl.accept(this, names);
            Package p = parent;
            for (String packageName : names) {
                p = UmlUtils.getPackage(p, packageName);
            }
            return p;
        }

        @Override
        public void visit(NameExpr n, List<String> names) {
            names.add(0, n.getName());
            super.visit(n, names);
        }

        @Override
        public void visit(QualifiedNameExpr n, List<String> names) {
            names.add(0, n.getName());
            super.visit(n, names);
        }
    }

    private class MethodParameterData {
        TypeAnalyserAndTranslator.TranslatedTypeData dataType;
        Type umlType;

        private MethodParameterData() {
        }
    }

    protected class QualifiedNameParser
    extends VoidVisitorAdapter<List<String>> {
        protected QualifiedNameParser() {
        }

        public List<String> getClassOrInterfaceQualifiedName(ClassOrInterfaceType n) {
            ArrayList<String> res = new ArrayList<String>();
            n.accept(this, res);
            return res;
        }

        public List<String> getPackageQualifiedName(PackageDeclaration n) {
            ArrayList<String> res = new ArrayList<String>();
            n.accept(this, res);
            return res;
        }

        public List<String> getImportQualifiedName(ImportDeclaration n) {
            return this.getQualifiedName(n);
        }

        private List<String> getQualifiedName(Node n) {
            ArrayList<String> res = new ArrayList<String>();
            n.accept(this, res);
            return res;
        }

        @Override
        public void visit(ClassOrInterfaceType n, List<String> names) {
            names.add(0, n.getName());
            if (n.getScope() != null) {
                n.getScope().accept(this, names);
            }
        }

        @Override
        public void visit(NameExpr n, List<String> names) {
            names.add(0, n.getName());
        }

        @Override
        public void visit(QualifiedNameExpr n, List<String> names) {
            names.add(0, n.getName());
            if (n.getQualifier() != null) {
                n.getQualifier().accept(this, names);
            }
        }
    }

    protected class TypeData {
        List<String> qualifiedName;
        protected List<TypeData> genericData;
        boolean isInterface = false;
        boolean isPrimitive = false;
        protected int arrayCount;
        protected boolean isWildcard = false;
        protected TypeData extends_;
        protected TypeData super_;
        protected boolean isVoid = false;

        protected TypeData() {
        }
    }
}

