/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.python.codegen.transformation;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.designer.languages.common.base.ILocationStrategy;
import org.eclipse.papyrus.designer.languages.common.base.ModelElementsCreator;
import org.eclipse.papyrus.designer.languages.common.base.file.FileSystemAccessFactory;
import org.eclipse.papyrus.designer.languages.common.base.file.IPFileSystemAccess;
import org.eclipse.papyrus.designer.languages.python.codegen.gen.PyClasses;
import org.eclipse.papyrus.designer.languages.python.codegen.gen.PyDatatype;
import org.eclipse.papyrus.designer.languages.python.codegen.gen.PyEnumeration;
import org.eclipse.papyrus.designer.languages.python.codegen.gen.PyInterface;
import org.eclipse.papyrus.designer.languages.python.codegen.transformation.PythonLocStrategy;
import org.eclipse.papyrus.designer.languages.python.profile.python.Module;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.ValueSpecification;

public class PythonModelElementsCreator
extends ModelElementsCreator {
    private static final String PYTHON_LANG = "Python";
    protected String pythonExt;

    public PythonModelElementsCreator(IProject project) {
        this(project, FileSystemAccessFactory.create((IProject)project));
    }

    public PythonModelElementsCreator(IProject project, IPFileSystemAccess fileSystemAccess) {
        super(fileSystemAccess, (ILocationStrategy)new PythonLocStrategy(), PYTHON_LANG);
        this.project = project;
        this.pythonExt = "py";
    }

    protected boolean noCodeGen(Element element) {
        return false;
    }

    protected void createPackageableElementFile(PackageableElement pe, IProgressMonitor monitor) {
        if (pe instanceof Classifier && !StereotypeUtil.isApplied((Element)pe.getNearestPackage(), Module.class)) {
            Classifier classifier = (Classifier)pe;
            String fileName = String.valueOf(this.getFileName((NamedElement)classifier)) + "." + this.pythonExt;
            String result = "";
            if (!(classifier instanceof PrimitiveType || classifier instanceof OpaqueBehavior || classifier instanceof Usage || classifier instanceof ValueSpecification)) {
                if (classifier instanceof Class) {
                    result = PyClasses.genClassWithNS((Class)classifier, this.useRelativeImports()).toString();
                    this.generateFile(fileName, result);
                } else if (classifier instanceof Interface) {
                    result = PyInterface.genInterface((Interface)classifier, this.useRelativeImports()).toString();
                    this.generateFile(fileName, result);
                } else if (classifier instanceof Enumeration) {
                    result = PyEnumeration.genEnumeration((Enumeration)classifier, this.useRelativeImports()).toString();
                    this.fileSystemAccess.generateFile(fileName, result);
                } else if (classifier instanceof DataType) {
                    result = PyDatatype.genDatatype((DataType)classifier).toString();
                    this.generateFile(fileName, result);
                }
            }
        } else if (pe instanceof Package) {
            Package pkg = (Package)pe;
            if (StereotypeUtil.isApplied((Element)pe, Module.class)) {
                String fileName = String.valueOf(this.getFileName((NamedElement)pe.getNearestPackage())) + "." + this.pythonExt;
                String result = "";
                for (Element element : pkg.allOwnedElements()) {
                    if (!(element instanceof Classifier) || !(element instanceof Class) || element instanceof OpaqueBehavior) continue;
                    result = String.valueOf(result) + PyClasses.genClassWithNS((Class)element, this.useRelativeImports()).toString();
                }
                this.generateFile(fileName, result);
            } else if (pkg.getOwnedMembers().size() > 0) {
                String fileName = String.valueOf(this.getFileName((NamedElement)pkg)) + "/__init__." + this.pythonExt;
                this.generateFile(fileName, "");
            }
        }
    }

    protected boolean useRelativeImports() {
        return true;
    }

    protected void generateFile(String fileName, String content) {
        this.fileSystemAccess.generateFile(fileName, content);
    }
}

