/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.monitoring.sm.runnable;

import org.eclipse.papyrus.designer.monitoring.sm.animation.Animator;
import org.eclipse.papyrus.designer.monitoring.sm.data.Message;
import org.eclipse.papyrus.designer.monitoring.sm.data.MessageQueue;

public class AnimatorMessageQueueReader
implements Runnable {
    public static final String PAPYRUS_END_SM_MONITORING = "PAPYRUS_END_SM_MONITORING";
    private boolean running = true;
    private final int sleepTime = 10;
    private MessageQueue messageQueue;
    private Animator animator;

    public AnimatorMessageQueueReader(MessageQueue messageQueue, Animator animator) {
        this.messageQueue = messageQueue;
        this.animator = animator;
    }

    @Override
    public void run() {
        this.animator.initialize();
        while (this.running) {
            Message message = null;
            if (this.messageQueue != null) {
                message = this.messageQueue.poll();
            }
            if (message != null) {
                String header = message.getHeader();
                String data = message.getData();
                if (header.equals("TRANSITION") || header.equals("STATE")) {
                    this.animator.animate(header, data);
                }
                if (header.equals(PAPYRUS_END_SM_MONITORING)) {
                    this.running = false;
                }
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.animator.deleteMarkers();
    }

    public void stop() {
        this.running = false;
    }
}

