/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.designer.languages.cpp.library.CppUriConstants;
import org.eclipse.papyrus.designer.transformation.base.utils.ModelManagement;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoElem;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.SM2ClassesTransformationCore;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Type;

public class CompleteStatemachine
implements IM2MTrafoElem {
    public static final String THREAD_FUNCTIONS = "ThreadFunctions";
    public static final String SYSTEM_STATE_ENUM_T = "SystemStateEnum_t";
    public static final String STRUCT_FOR_THREAD = "StructForThread_t";
    public static final URI SM_CPP_URI = URI.createURI((String)"pathmap://DML_TRAFOS_CPP/statemachine.uml");

    public void transformElement(M2MTrafo trafo, Element element) {
        Class tmClass;
        if (element instanceof Class && (tmClass = (Class)element).getClassifierBehavior() instanceof StateMachine) {
            StateMachine sm = (StateMachine)tmClass.getClassifierBehavior();
            LazyCopier copier = TransformationContext.current.copier;
            SM2ClassesTransformationCore trafoCore = new SM2ClassesTransformationCore(copier, sm, tmClass);
            ElementUtils.loadPackage((URI)CppUriConstants.PTHREAD_LIB_URI, (Element)tmClass);
            Package smModel = ElementUtils.loadPackage((URI)SM_CPP_URI, (ResourceSet)ModelManagement.getResourceSet());
            PackageableElement stateEnum = smModel.getPackagedElement(SYSTEM_STATE_ENUM_T);
            PackageableElement threadFuncEnum = smModel.getPackagedElement(THREAD_FUNCTIONS);
            Type structForThread = (Type)smModel.getPackagedElement(STRUCT_FOR_THREAD);
            trafoCore.setThreadStructType(structForThread);
            trafoCore.setSmPack(smModel);
            tmClass.createOwnedAttribute("systemState", (Type)stateEnum);
            tmClass.createDependency((NamedElement)threadFuncEnum);
            trafoCore.threadFuncEnum = (Type)threadFuncEnum;
            trafoCore.transform();
        }
    }
}

