/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.languages.cpp.library.preferences;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class MonitoringPreferencesUtil {
    protected static IEclipsePreferences prefs = null;
    private static final Pattern IP_PATTERN = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");

    public static void initPrefs() {
        if (prefs == null) {
            prefs = InstanceScope.INSTANCE.getNode("org.eclipse.papyrus.designer.monitoring.sm");
        }
    }

    public static String getIpAddress() {
        MonitoringPreferencesUtil.initPrefs();
        String ip = prefs.get("papyrusMonitorIpAddress", "127.0.0.1");
        if (ip == null || !MonitoringPreferencesUtil.validate(ip)) {
            ip = "127.0.0.1";
        }
        return ip;
    }

    public static int getPort() {
        MonitoringPreferencesUtil.initPrefs();
        int port = prefs.getInt("papyrusMonitorPort", 4445);
        if (port <= 0) {
            port = 4445;
        }
        return port;
    }

    public static boolean getEnabled() {
        MonitoringPreferencesUtil.initPrefs();
        return prefs.getBoolean("papyrusMonitorEnabled", false);
    }

    private static boolean validate(String ip) {
        return IP_PATTERN.matcher(ip).matches();
    }
}

