/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.library.transformations;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.designer.deployment.profile.DepProfileResource;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.UseInstanceConfigurator;
import org.eclipse.papyrus.designer.deployment.tools.ConfigUtils;
import org.eclipse.papyrus.designer.deployment.tools.DepCreation;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoElem;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.extensions.IM2MTrafo;
import org.eclipse.papyrus.designer.transformation.extensions.InstanceConfigurator;
import org.eclipse.papyrus.designer.transformation.extensions.M2MTrafoExt;
import org.eclipse.papyrus.designer.transformation.library.Messages;
import org.eclipse.papyrus.designer.transformation.library.transformations.bindinghelpers.BindOperation;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.ApplyTransformation;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.papyrus.designer.uml.tools.utils.BehaviorUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.OperationUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.designer.uml.tools.utils.StUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.profile.standard.Destroy;
import org.eclipse.uml2.uml.util.UMLUtil;

public class MergeClass
implements IM2MTrafoElem {
    LazyCopier copier;

    public void mergeClass(Class mergeTemplateClass, Class tmClass) throws TransformationException {
        Package p;
        for (Dependency dependency : mergeTemplateClass.getClientDependencies()) {
            Dependency dependencyCopy = (Dependency)EcoreUtil.copy((EObject)dependency);
            tmClass.getClientDependencies().add((Object)dependencyCopy);
        }
        boolean hasConstructor = OperationUtils.isOperationStereotypeApplied((Classifier)tmClass, Create.class);
        boolean hasDestructor = OperationUtils.isOperationStereotypeApplied((Classifier)tmClass, Destroy.class);
        this.copier.put((Object)mergeTemplateClass, (Object)tmClass);
        this.copier.setStatus((EObject)tmClass, LazyCopier.CopyStatus.INPROGRESS);
        for (Operation templateOperation : mergeTemplateClass.getOperations()) {
            boolean templateOpIsConstructor = StereotypeUtil.isApplied((Element)templateOperation, Create.class);
            boolean templateOpIsDestructor = StereotypeUtil.isApplied((Element)templateOperation, Destroy.class);
            boolean needsMerge = templateOpIsConstructor && hasConstructor || templateOpIsDestructor && hasDestructor;
            ApplyTransformation trafoOnOpSt = (ApplyTransformation)UMLUtil.getStereotypeApplication((Element)templateOperation, ApplyTransformation.class);
            boolean isTemplate = false;
            if (trafoOnOpSt != null) {
                for (M2MTrafo stTrafo : trafoOnOpSt.getTrafo()) {
                    IM2MTrafo trafoOnOp = M2MTrafoExt.getM2MTrafo((M2MTrafo)stTrafo);
                    if (!(trafoOnOp instanceof BindOperation)) continue;
                    isTemplate = true;
                    break;
                }
            }
            if (needsMerge) {
                this.mergeOperations(tmClass, mergeTemplateClass, templateOperation);
                continue;
            }
            if (isTemplate) continue;
            Operation newOperation = (Operation)this.copier.getCopy((Element)templateOperation);
            if (templateOpIsConstructor) {
                newOperation.setName(tmClass.getName());
                continue;
            }
            if (!templateOpIsDestructor) continue;
            newOperation.setName("~" + tmClass.getName());
        }
        for (Property part : mergeTemplateClass.getAllAttributes()) {
            Type type = part.getType();
            if (type == null) {
                String ruleName = mergeTemplateClass.getName() != null ? mergeTemplateClass.getName() : "undefined";
                throw new TransformationException(String.format(Messages.MergeClass_CannotApply0, ruleName));
            }
            Property newPart = (Property)EcoreUtil.copy((EObject)part);
            StUtils.copyStereotypes((Element)part, (Element)newPart);
            tmClass.getOwnedAttributes().add((Object)newPart);
        }
        UseInstanceConfigurator configuratorOnTemplate = (UseInstanceConfigurator)UMLUtil.getStereotypeApplication((Element)mergeTemplateClass, UseInstanceConfigurator.class);
        if (configuratorOnTemplate != null && (p = PackageUtil.loadPackage((URI)DepProfileResource.PROFILE_PATH_URI, (ResourceSet)tmClass.eResource().getResourceSet())) instanceof Profile) {
            tmClass.getNearestPackage().applyProfile((Profile)p);
            UseInstanceConfigurator useConfigurator = (UseInstanceConfigurator)StereotypeUtil.applyApp((Element)tmClass, UseInstanceConfigurator.class);
            useConfigurator.setConfigurator(configuratorOnTemplate.getConfigurator());
        }
    }

    void mergeOperations(Class tmClass, Class mergeTemplateClass, Operation mergeOperation) throws TransformationException {
        for (Operation tmOperation : tmClass.getOwnedOperations()) {
            String mergeBody = BehaviorUtils.body((Operation)mergeOperation);
            if (StereotypeUtil.isApplied((Element)mergeOperation, Create.class) != StereotypeUtil.isApplied((Element)tmOperation, Create.class) || StereotypeUtil.isApplied((Element)mergeOperation, Destroy.class) != StereotypeUtil.isApplied((Element)tmOperation, Destroy.class) || mergeBody.length() <= 0) continue;
            mergeBody = "// --- merged from template <" + mergeTemplateClass.getName() + "> ---\n" + mergeBody;
            String newBody = String.valueOf(BehaviorUtils.body((Operation)tmOperation)) + mergeBody;
            BehaviorUtils.set((Operation)tmOperation, (String)newBody);
        }
    }

    public void configureMergedInstance(InstanceSpecification mergedInstance, Class tmClass) throws TransformationException {
        Package tmCDP = mergedInstance.getNearestPackage();
        for (Property part : DepUtils.getParts((Class)tmClass)) {
            Type typeFromTemplate = part.getType();
            if (!(typeFromTemplate instanceof Class) || DepUtils.getSlot((InstanceSpecification)mergedInstance, (Property)part) != null) continue;
            InstanceSpecification containerExtIS = DepCreation.createDepPlan((Package)tmCDP, (Class)((Class)typeFromTemplate), (String)(String.valueOf(mergedInstance.getName()) + "." + part.getName()), (boolean)false);
            ConfigUtils.configureInstance((InstanceSpecification)containerExtIS, (Property)part, null);
            DepCreation.createSlot((InstanceSpecification)mergedInstance, (InstanceSpecification)containerExtIS, (Property)part);
        }
    }

    public void transformElement(M2MTrafo trafo, Element element) throws TransformationException {
        InstanceSpecification is;
        Classifier cl;
        if (element instanceof Class) {
            Class tmClass = (Class)element;
            this.copier = TransformationContext.current.copier;
            this.mergeClass(trafo.getBase_Class(), tmClass);
        } else if (element instanceof InstanceSpecification && (cl = DepUtils.getClassifier((InstanceSpecification)(is = (InstanceSpecification)element))) instanceof Class) {
            this.configureMergedInstance(is, (Class)cl);
            UseInstanceConfigurator useInstanceConfigurator = (UseInstanceConfigurator)UMLUtil.getStereotypeApplication((Element)trafo.getBase_Class(), UseInstanceConfigurator.class);
            InstanceConfigurator.configureInstance((UseInstanceConfigurator)useInstanceConfigurator, (InstanceSpecification)is, null, null);
        }
    }
}

