/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.uml.tools.utils;

import java.util.Iterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class OperationUtils {
    public static Operation getSameOperation(Operation op, Class owner) {
        for (Operation ownedOp : owner.getOwnedOperations()) {
            if (!OperationUtils.isSameOperation(op, ownedOp)) continue;
            return ownedOp;
        }
        return null;
    }

    public static boolean isSameOperation(Operation op1, Operation op2) {
        return OperationUtils.isSameOperation(op1, op2, true);
    }

    public static boolean isOperationStereotypeApplied(Classifier cl, java.lang.Class<? extends EObject> stereotype) {
        for (Operation op : cl.getOperations()) {
            if (!StereotypeUtil.isApplied((Element)op, stereotype)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSameOperation(Operation op1, Operation op2, boolean checkName) {
        if (checkName) {
            String op1Name = op1.getName();
            String op2Name = op2.getName();
            if (op1Name == null ? op2Name != null : !op1Name.equals(op2Name)) {
                return false;
            }
        }
        Iterator parameters1 = op1.getOwnedParameters().iterator();
        Iterator parameters2 = op2.getOwnedParameters().iterator();
        while (parameters1.hasNext() && parameters2.hasNext()) {
            Parameter parameter1 = (Parameter)parameters1.next();
            Parameter parameter2 = (Parameter)parameters2.next();
            String par1Name = parameter1.getName();
            Type par1Type = parameter1.getType();
            String par2Name = parameter2.getName();
            Type par2Type = parameter2.getType();
            if (par1Name == null ? par2Name != null : !par1Name.equals(par2Name)) {
                return false;
            }
            if (par1Type != null && par2Type != null ? (par1Type.getName() == null ? par2Type.getName() != null : !par1Type.getName().equals(par2Type.getName())) : par1Type != par2Type) {
                return false;
            }
            if (parameter1.getUpper() != parameter2.getUpper() || parameter1.getLower() != parameter2.getLower()) {
                return false;
            }
            if (parameter1.getStereotypeApplications().size() != parameter2.getStereotypeApplications().size()) {
                return false;
            }
            Iterator par2StereoIter = parameter2.getAppliedStereotypes().iterator();
            for (Stereotype par1Stereo : parameter1.getAppliedStereotypes()) {
                Stereotype par2Stereo;
                if (par1Stereo == (par2Stereo = (Stereotype)par2StereoIter.next())) continue;
                return false;
            }
        }
        return parameters1.hasNext() == parameters2.hasNext();
    }

    public static Operation createOwnedOperation(Classifier cl, String name, EList<String> paramNames, EList<Type> paramTypes, Type retType) {
        if (cl instanceof Class) {
            return ((Class)cl).createOwnedOperation(name, paramNames, paramTypes, retType);
        }
        if (cl instanceof Interface) {
            return ((Interface)cl).createOwnedOperation(name, paramNames, paramTypes, retType);
        }
        return null;
    }

    public static EList<Parameter> parametersInInout(Operation operation) {
        BasicEList list = new BasicEList();
        for (Parameter parameter : operation.getOwnedParameters()) {
            if (parameter.getDirection().getValue() != 0 && parameter.getDirection().getValue() != 1) continue;
            list.add((Object)parameter);
        }
        return list;
    }

    public static EList<Parameter> parametersNonRet(Operation operation) {
        BasicEList list = new BasicEList();
        for (Parameter parameter : operation.getOwnedParameters()) {
            if (parameter.getDirection().getValue() == 3) continue;
            list.add((Object)parameter);
        }
        return list;
    }

    public static EList<Parameter> parametersOutInout(Operation operation) {
        BasicEList list = new BasicEList();
        for (Parameter parameter : operation.getOwnedParameters()) {
            if (parameter.getDirection().getValue() != 2 && parameter.getDirection().getValue() != 3 && parameter.getDirection().getValue() != 1) continue;
            list.add((Object)parameter);
        }
        return list;
    }

    public static String paramName(Parameter parameter) {
        if (parameter.getDirection().getValue() == 3) {
            return "retValue";
        }
        return parameter.getName();
    }

    public static Interface implementsInterface(Operation operation) {
        Element owner = operation.getOwner();
        if (owner instanceof BehavioredClassifier) {
            String name = operation.getName();
            BasicEList types = new BasicEList();
            for (Parameter parameter : operation.getOwnedParameters()) {
                types.add((Object)parameter.getType());
            }
            for (InterfaceRealization ir : ((BehavioredClassifier)owner).getInterfaceRealizations()) {
                Operation candidate = ir.getContract().getOwnedOperation(name, null, (EList)types);
                if (candidate == null) continue;
                return ir.getContract();
            }
        } else if (owner instanceof Interface) {
            return (Interface)owner;
        }
        return null;
    }
}

