/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.diagram;

import java.util.EventObject;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.gmfdiag.diagram.Activator;
import org.eclipse.papyrus.infra.gmfdiag.diagram.DynamicContextMenu;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.presentation.LayersEditor;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class LayersTreeEditorDiagram
extends LayersEditor
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker {
    protected ServicesRegistry servicesRegistry;
    protected CommandStackListener commandStackListener;
    protected DynamicContextMenu dynamicContextMenu;

    public LayersTreeEditorDiagram(ServicesRegistry servicesRegistry) throws ServiceException, BackboneException {
        this.servicesRegistry = servicesRegistry;
        this.initEditor();
    }

    private void initEditor() throws ServiceException {
        TransactionalEditingDomain papyrusEditingDomain = (TransactionalEditingDomain)this.servicesRegistry.getService(TransactionalEditingDomain.class);
        CommandStack commandStack = papyrusEditingDomain.getCommandStack();
        this.commandStackListener = new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                if (LayersTreeEditorDiagram.this.getContainer().isDisposed()) {
                    return;
                }
                LayersTreeEditorDiagram.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LayersTreeEditorDiagram.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            LayersTreeEditorDiagram.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        Iterator i = LayersTreeEditorDiagram.this.propertySheetPages.iterator();
                        while (i.hasNext()) {
                            PropertySheetPage propertySheetPage = (PropertySheetPage)i.next();
                            if (propertySheetPage.getControl() == null || propertySheetPage.getControl().isDisposed()) {
                                i.remove();
                                continue;
                            }
                            propertySheetPage.refresh();
                        }
                    }
                });
            }
        };
        commandStack.addCommandStackListener(this.commandStackListener);
        ResourceSet resourceSet = papyrusEditingDomain.getResourceSet();
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, commandStack, resourceSet);
    }

    public void createModel() {
    }

    public void doSave(IProgressMonitor progressMonitor) {
    }

    public void doSaveAs() {
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        super.init(site, editorInput);
        this.setPartName("Layers Editor");
    }

    public IActionBars getActionBars() {
        try {
            return this.getActionBarContributor().getActionBars();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public void dispose() {
        try {
            TransactionalEditingDomain papyrusEditingDomain = (TransactionalEditingDomain)this.servicesRegistry.getService(TransactionalEditingDomain.class);
            CommandStack commandStack = papyrusEditingDomain.getCommandStack();
            commandStack.removeCommandStackListener(this.commandStackListener);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public void setStatusLineManager(ISelection selection) {
    }

    public IPropertySheetPage getPropertySheetPage() {
        return super.getPropertySheetPage();
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        if (this.dynamicContextMenu == null) {
            this.dynamicContextMenu = new DynamicContextMenu((IEditorPart)this);
        }
        this.dynamicContextMenu.menuAboutToShow(menuManager);
    }
}

