/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.exprmatcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.query.conditions.eobjects.EObjectCondition;
import org.eclipse.emf.query.ocl.conditions.BooleanOCLCondition;
import org.eclipse.emf.query.statements.FROM;
import org.eclipse.emf.query.statements.IQueryResult;
import org.eclipse.emf.query.statements.SELECT;
import org.eclipse.emf.query.statements.WHERE;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.LayersException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.exprmatcher.IValueChangedEventListener;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.exprmatcher.ValueChangedEventNotifier;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.exprmatcher.ValueChangedEventNotifierFactory;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.util.Collections3;

public class ExpressionMatcher
implements IValueChangedEventListener {
    protected String expression = "";
    protected List<View> matchingElements;
    protected List<EObject> searchRoots;
    protected EObjectCondition condition;
    protected OCL ocl;

    public ExpressionMatcher() {
        this.expression = "";
        this.searchRoots = Collections.emptyList();
        this.matchingElements = new ArrayList<View>();
    }

    public ExpressionMatcher(List<View> matchingElementsList) {
        this.expression = "";
        this.searchRoots = Collections.emptyList();
        this.matchingElements = matchingElementsList;
    }

    public ExpressionMatcher(EObject searchRoot) {
        this.expression = "";
        this.setSearchRoots(Collections.singletonList(searchRoot));
        this.matchingElements = new ArrayList<View>();
    }

    public ExpressionMatcher(String expression, List<EObject> searchRoots) throws LayersException {
        this.searchRoots = searchRoots;
        this.matchingElements = new ArrayList<View>();
        this.setExpression(expression);
    }

    public ExpressionMatcher(String expression, List<View> matchingElementsList, List<EObject> searchRoots) throws LayersException {
        this.searchRoots = searchRoots;
        this.matchingElements = matchingElementsList;
        this.setExpression(expression);
    }

    public ExpressionMatcher(String expression, EObject searchRoot) throws LayersException {
        this(expression, Collections.singletonList(searchRoot));
    }

    public ExpressionMatcher(String expression, List<View> matchingElementsList, EObject searchRoot) throws LayersException {
        this(expression, matchingElementsList, Collections.singletonList(searchRoot));
    }

    private void computeCondition() throws LayersException {
        if (this.getExpression() == null || this.getExpression().length() == 0) {
            return;
        }
        if (this.ocl == null) {
            this.ocl = OCL.newInstance();
        }
        try {
            this.condition = new BooleanOCLCondition(this.ocl.getEnvironment(), this.getExpression(), (Object)NotationPackage.Literals.VIEW);
        }
        catch (ParserException e) {
            this.condition = null;
            throw new LayersException("Can't parse expression : " + e.getMessage(), e);
        }
    }

    public void refreshMatchingElements() {
        if (this.condition == null) {
            if (!this.getMatchingElements().isEmpty()) {
                this.resetMatchingElements(Collections.EMPTY_LIST);
            }
            return;
        }
        SELECT statement = new SELECT(0, false, new FROM(this.getSearchRoots()), new WHERE(this.condition), (IProgressMonitor)new NullProgressMonitor());
        IQueryResult results = statement.execute();
        this.resetMatchingElements((Collection<?>)results);
    }

    private void resetMatchingElements(Collection<?> newElements) {
        Collections3.resetListTo(this.matchingElements, newElements);
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) throws LayersException {
        if (expression == null || expression.length() == 0) {
            expression = "";
        }
        if (expression.equals(this.expression)) {
            return;
        }
        this.expression = expression;
        this.computeCondition();
        this.refreshMatchingElements();
    }

    public List<View> getMatchingElements() {
        return this.matchingElements;
    }

    public List<EObject> getSearchRoots() {
        return this.searchRoots;
    }

    public void setSearchRoots(List<EObject> searchRoots) {
        this.removeSearchRootsObservers();
        if (searchRoots == null) {
            searchRoots = Collections.emptyList();
        }
        this.searchRoots = searchRoots;
        this.addSearchRootsObservers();
    }

    public void setSearchRoots(EObject searchRoot) {
        if (searchRoot == null) {
            this.removeSearchRootsObservers();
            this.searchRoots = Collections.emptyList();
            return;
        }
        this.setSearchRoots(Collections.singletonList(searchRoot));
    }

    protected void addSearchRootsObservers() {
        if (this.searchRoots == null) {
            return;
        }
        for (EObject root : this.searchRoots) {
            ValueChangedEventNotifier notifier = ValueChangedEventNotifierFactory.instance.adapt((Notifier)root);
            notifier.addEventListener(this);
        }
    }

    protected void removeSearchRootsObservers() {
        if (this.searchRoots == null) {
            return;
        }
        for (EObject root : this.searchRoots) {
            ValueChangedEventNotifier notifier = ValueChangedEventNotifierFactory.instance.adapt((Notifier)root);
            notifier.removeEventListener(this);
        }
    }

    @Override
    public void valueChanged(Notification msg) {
        this.refreshMatchingElements();
    }
}

