/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringListValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.databinding.AddCSSStyleSheetCommand;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.databinding.AddCssClassStyleCommand;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.EmbeddedStyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.CSSInstance;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.CSSPropertySetter;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersPackage;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.TypeInstance;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.PropertySetterImpl;

public class CSSPropertySetterImpl
extends PropertySetterImpl
implements CSSPropertySetter {
    protected CSSPropertySetterImpl() {
        this.setPropertyName("css");
    }

    @Override
    protected EClass eStaticClass() {
        return LayersPackage.Literals.CSS_PROPERTY_SETTER;
    }

    @Override
    public void setValue(View view, TypeInstance value) {
        Diagram d = view.getDiagram();
        CSSDiagram cssD = null;
        TransactionalEditingDomain ted = null;
        EList features = view.eClass().getEStructuralFeatures();
        CSSInstance associatedCSS = (CSSInstance)value;
        StyleSheet sheet = associatedCSS.getStylesheet();
        if (sheet == null) {
            return;
        }
        if (d instanceof CSSDiagram) {
            String style;
            cssD = (CSSDiagram)d;
            try {
                ted = ServiceUtilsForResource.getInstance().getTransactionalEditingDomain((Object)view.eResource());
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            String sheetPath = ((StyleSheetReference)sheet).getPath();
            boolean sheetIsApplied = false;
            for (StyleSheet ss : cssD.getStyleSheets()) {
                String ssPath = ((StyleSheetReference)ss).getPath();
                if (!sheetPath.equals(ssPath)) continue;
                sheetIsApplied = true;
                break;
            }
            if (!sheetIsApplied) {
                if (sheet instanceof StyleSheetReference) {
                    sheet = (StyleSheet)EcoreUtil.copy((EObject)sheet);
                } else {
                    boolean cfr_ignored_0 = sheet instanceof EmbeddedStyleSheet;
                }
                AddCSSStyleSheetCommand aacssc = new AddCSSStyleSheetCommand((EditingDomain)ted, (View)cssD, "css_stylesheets", NotationPackage.eINSTANCE.getEObjectListValueStyle(), (EStructuralFeature)NotationPackage.eINSTANCE.getEObjectListValueStyle_EObjectListValue(), (Object)sheet);
                aacssc.execute();
            }
            if ((style = associatedCSS.getStyle()) == null) {
                return;
            }
            ArrayList<String> appliedStyles = new ArrayList<String>();
            for (Object o : view.getStyles()) {
                StringListValueStyle slvs;
                if (!(o instanceof StringListValueStyle) || (slvs = (StringListValueStyle)o).getStringListValue().isEmpty()) continue;
                appliedStyles.add((String)slvs.getStringListValue().get(0));
            }
            if (appliedStyles.isEmpty() || !appliedStyles.contains(style)) {
                AddCssClassStyleCommand accsc = new AddCssClassStyleCommand(ted, view, style);
                accsc.execute();
            }
        }
    }
}

