/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersFactory;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersPackage;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Property;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.PropertyRegistry;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Type;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.TypeInstance;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.TypeRegistry;

public class PropertyRegistryImpl
extends EObjectImpl
implements PropertyRegistry {
    protected EList<Property> properties;
    protected TypeRegistry typeRegistry;
    protected static final int PROPERTIES_COUNT_EDEFAULT = 0;

    protected PropertyRegistryImpl() {
        this.init();
    }

    protected void init() {
        TypeRegistry typeRegistry = LayersFactory.eINSTANCE.createTypeRegistry();
        this.setTypeRegistry(typeRegistry);
        String[] properties = new String[]{"css", "CSSType", ""};
        int i = 0;
        while (i < properties.length) {
            Property property = LayersFactory.eINSTANCE.createProperty();
            property.setName(properties[i]);
            Type propertyType = (Type)typeRegistry.getTypes().get((Object)properties[i + 1]);
            property.setType(propertyType);
            String defaultValueStr = properties[i + 2];
            if (defaultValueStr != null && defaultValueStr.length() > 0) {
                TypeInstance defaultValue = propertyType.createInstance();
                defaultValue.setValueFromString(defaultValueStr);
                property.setDefaultValue(defaultValue);
            }
            this.addProperty(property);
            i += 3;
        }
    }

    protected EClass eStaticClass() {
        return LayersPackage.Literals.PROPERTY_REGISTRY;
    }

    @Override
    public EList<Property> getProperties() {
        if (this.properties == null) {
            this.properties = new EObjectContainmentEList(Property.class, (InternalEObject)this, 0);
        }
        return this.properties;
    }

    @Override
    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public NotificationChain basicSetTypeRegistry(TypeRegistry newTypeRegistry, NotificationChain msgs) {
        TypeRegistry oldTypeRegistry = this.typeRegistry;
        this.typeRegistry = newTypeRegistry;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldTypeRegistry, (Object)newTypeRegistry);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setTypeRegistry(TypeRegistry newTypeRegistry) {
        if (newTypeRegistry != this.typeRegistry) {
            NotificationChain msgs = null;
            if (this.typeRegistry != null) {
                msgs = ((InternalEObject)this.typeRegistry).eInverseRemove((InternalEObject)this, -2, null, msgs);
            }
            if (newTypeRegistry != null) {
                msgs = ((InternalEObject)newTypeRegistry).eInverseAdd((InternalEObject)this, -2, null, msgs);
            }
            if ((msgs = this.basicSetTypeRegistry(newTypeRegistry, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newTypeRegistry, (Object)newTypeRegistry));
        }
    }

    @Override
    public int getPropertiesCount() {
        return this.getProperties().size();
    }

    @Override
    public int getPropertyIndex(String propertyName) throws NotFoundException {
        if (propertyName == null) {
            throw new NotFoundException("Null not Allowed");
        }
        EList<Property> props = this.getProperties();
        int i = 0;
        while (i < props.size()) {
            if (propertyName.equals(((Property)props.get(i)).getName())) {
                return i;
            }
            ++i;
        }
        throw new NotFoundException("No property found with name '" + propertyName + "'");
    }

    @Override
    public Property getProperty(String propertyName) throws NotFoundException {
        int index = this.getPropertyIndex(propertyName);
        return (Property)this.getProperties().get(index);
    }

    @Override
    public void addProperty(Property property) {
        try {
            this.getProperty(property.getName());
            return;
        }
        catch (NotFoundException notFoundException) {
            property.setIndex(this.getProperties().size());
            this.getProperties().add((Object)property);
            return;
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getProperties()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return this.basicSetTypeRegistry(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getProperties();
            }
            case 1: {
                return this.getTypeRegistry();
            }
            case 2: {
                return this.getPropertiesCount();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getProperties().clear();
                this.getProperties().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setTypeRegistry((TypeRegistry)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getProperties().clear();
                return;
            }
            case 1: {
                this.setTypeRegistry(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.properties != null && !this.properties.isEmpty();
            }
            case 1: {
                return this.typeRegistry != null;
            }
            case 2: {
                return this.getPropertiesCount() != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                try {
                    return this.getPropertyIndex((String)arguments.get(0));
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 1: {
                try {
                    return this.getProperty((String)arguments.get(0));
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 2: {
                this.addProperty((Property)arguments.get(0));
                return null;
            }
        }
        return super.eInvoke(operationID, arguments);
    }
}

