/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.model;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.resource.AbstractModelWithSharedResource;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersFactory;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStackApplication;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.LayersStackAndApplicationLifeCycleEventNotifier;

public class LayersModelResource
extends AbstractModelWithSharedResource<LayersStackApplication>
implements IModel {
    public static final String LAYERS_RESOURCE_FILE_EXTENSION = "layers";
    public static final String MODEL_ID = "org.eclipse.papyrus.layers.resource.LayersModel";
    private LayersStackAndApplicationLifeCycleEventNotifier layersStackAndApplicationLifeCycleEventNotifier = null;

    public LayersModelResource() {
        this.modelKind = AbstractModelWithSharedResource.ModelKind.master;
    }

    public String getIdentifier() {
        return MODEL_ID;
    }

    protected String getModelFileExtension() {
        return LAYERS_RESOURCE_FILE_EXTENSION;
    }

    protected boolean isModelRoot(EObject object) {
        return object instanceof LayersStackApplication;
    }

    public void loadModel(URI uriWithoutExtension) {
        if (this.exists(uriWithoutExtension)) {
            try {
                super.loadModel(uriWithoutExtension);
            }
            catch (Exception e) {
                this.createModel(uriWithoutExtension);
            }
        }
        if (this.resource == null) {
            this.createModel(uriWithoutExtension);
        }
        try {
            this.saveModel();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveModel() throws IOException {
        super.saveModel();
    }

    public LayersStackApplication lookupLayerStackApplication() {
        return (LayersStackApplication)this.getModelRoot();
    }

    public LayersStackApplication getLayerStackApplication() {
        LayersStackApplication application = (LayersStackApplication)this.getModelRoot();
        if (application != null) {
            return application;
        }
        application = LayersFactory.eINSTANCE.createLayersStackApplication();
        this.addModelRoot((EObject)application);
        return application;
    }

    public void removeRoot(LayersStackApplication application) {
        this.getResource().getContents().remove((Object)application);
    }

    public LayersStackAndApplicationLifeCycleEventNotifier getLayersStackLifeCycleEventNotifier() {
        if (this.layersStackAndApplicationLifeCycleEventNotifier == null) {
            this.layersStackAndApplicationLifeCycleEventNotifier = new LayersStackAndApplicationLifeCycleEventNotifier(this);
        }
        return this.layersStackAndApplicationLifeCycleEventNotifier;
    }
}

