/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rsa.wizard;

import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.papyrus.interoperability.rsa.Activator;
import org.eclipse.papyrus.interoperability.rsa.RSAToPapyrusParameters.Config;
import org.eclipse.papyrus.interoperability.rsa.internal.ConfigurationManager;
import org.eclipse.papyrus.interoperability.rsa.messages.Messages;
import org.eclipse.papyrus.interoperability.rsa.transformation.ImportTransformationLauncher;
import org.eclipse.papyrus.interoperability.rsa.wizard.pages.DialogData;
import org.eclipse.papyrus.interoperability.rsa.wizard.pages.TransformationConfigPage;
import org.eclipse.papyrus.interoperability.rsa.wizard.pages.TransformationSelectionPage;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class TransformationWizard
extends Wizard
implements IImportWizard {
    protected IWizardPage currentPage;
    protected DialogData dialogData = new DialogData();
    protected TransformationSelectionPage selectionPage = new TransformationSelectionPage(this.dialogData);
    protected TransformationConfigPage configPage = new TransformationConfigPage(this.dialogData);
    private ConfigurationManager configMan = new ConfigurationManager();

    public TransformationWizard() {
        this.setWindowTitle(Messages.TransformationWizard_Title);
        this.configMan.loadConfig(this.dialogData.getConfig());
    }

    public void dispose() {
        try {
            this.configMan.dispose();
        }
        finally {
            super.dispose();
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.selectionPage);
        this.addPage((IWizardPage)this.configPage);
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        if (currentPage == this.selectionPage) {
            this.currentPage = this.configPage;
            this.configPage.resetViewerInput();
            return this.configPage;
        }
        if (this.currentPage == this.configPage) {
            this.currentPage = this.selectionPage;
        }
        return null;
    }

    public boolean canFinish() {
        if (this.currentPage == this.configPage) {
            return super.canFinish();
        }
        return false;
    }

    public boolean performCancel() {
        this.removeWizardImportedProjects();
        return super.performCancel();
    }

    public boolean performFinish() {
        this.configMan.saveConfig(this.dialogData.getConfig());
        this.dialogData.setSelectionMap();
        this.importFiles();
        return true;
    }

    public void removeWizardImportedProjects() {
        if (this.dialogData.getImportedProjects() != null) {
            for (Object object : this.dialogData.getImportedProjects()) {
                if (!(object instanceof IProject)) continue;
                IProject project = (IProject)object;
                try {
                    project.delete(false, true, null);
                }
                catch (CoreException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
    }

    protected void importFiles() {
        Config config = this.dialogData.getConfig();
        if (config == null) {
            return;
        }
        LinkedList<URI> urisToImport = new LinkedList<URI>();
        for (Object selectedFile : this.dialogData.getTransformationFiles()) {
            String path = null;
            if (selectedFile instanceof IFile) {
                path = ((IFile)selectedFile).getFullPath().toString();
            }
            if (path == null) continue;
            URI uri = URI.createPlatformResourceURI((String)path, (boolean)true);
            urisToImport.add(uri);
        }
        ImportTransformationLauncher launcher = new ImportTransformationLauncher(config, (Control)this.getShell().getParent());
        launcher.run(urisToImport);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

