/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.opcua.di.opcuadiprofile.OPC_UA_DI_Library;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DeviceHealthEnumeration implements Enumerator
{
    NORMAL(1, "NORMAL", "NORMAL"),
    FAILURE(1, "FAILURE", "FAILURE"),
    CHECK_FUNCTION(2, "CHECK_FUNCTION", "CHECK_FUNCTION"),
    OFF_SPEC(3, "OFF_SPEC", "OFF_SPEC"),
    MAINTENANCE_REQUIRED(4, "MAINTENANCE_REQUIRED", "MAINTENANCE_REQUIRED");

    public static final int NORMAL_VALUE = 1;
    public static final int FAILURE_VALUE = 1;
    public static final int CHECK_FUNCTION_VALUE = 2;
    public static final int OFF_SPEC_VALUE = 3;
    public static final int MAINTENANCE_REQUIRED_VALUE = 4;
    private static final DeviceHealthEnumeration[] VALUES_ARRAY;
    public static final List<DeviceHealthEnumeration> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DeviceHealthEnumeration[]{NORMAL, FAILURE, CHECK_FUNCTION, OFF_SPEC, MAINTENANCE_REQUIRED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DeviceHealthEnumeration get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DeviceHealthEnumeration result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DeviceHealthEnumeration getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DeviceHealthEnumeration result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DeviceHealthEnumeration get(int value) {
        switch (value) {
            case 1: {
                return NORMAL;
            }
            case 2: {
                return CHECK_FUNCTION;
            }
            case 3: {
                return OFF_SPEC;
            }
            case 4: {
                return MAINTENANCE_REQUIRED;
            }
        }
        return null;
    }

    private DeviceHealthEnumeration(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

