/**
 * Copyright (c) 2018, 2020 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr
 */
package org.eclipse.papyrus.robotics.codegen.common.utils;

import java.util.Collections;
import java.util.List;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentDefinitionModel;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.util.UMLUtil;

@SuppressWarnings("all")
public class ComponentUtils {
  public static ComponentDefinitionModel getComponentDefinitionModel(final org.eclipse.uml2.uml.Class component) {
    final org.eclipse.uml2.uml.Package root = PackageUtil.getRootPackage(component);
    return UMLUtil.<ComponentDefinitionModel>getStereotypeApplication(root, ComponentDefinitionModel.class);
  }

  public static List<String> getDependsPackage(final org.eclipse.uml2.uml.Class component) {
    final ComponentDefinitionModel cdm = ComponentUtils.getComponentDefinitionModel(component);
    if ((cdm != null)) {
      return cdm.getDependsPackage();
    } else {
      return Collections.<String>emptyList();
    }
  }

  public static boolean isRegistered(final org.eclipse.uml2.uml.Class component) {
    final ComponentDefinitionModel cdm = ComponentUtils.getComponentDefinitionModel(component);
    if ((cdm != null)) {
      return cdm.isRegistered();
    }
    return false;
  }

  /**
   * Return true, if at least one of the passed components
   * is a registered component
   */
  public static boolean isRegistered(final List<org.eclipse.uml2.uml.Class> components) {
    for (final org.eclipse.uml2.uml.Class component : components) {
      boolean _isRegistered = ComponentUtils.isRegistered(component);
      if (_isRegistered) {
        return true;
      }
    }
    return false;
  }

  /**
   * Return the name of the variable holding the component instance.
   */
  public static String getInstName(final org.eclipse.uml2.uml.Class component) {
    return component.getName().toLowerCase();
  }
}
