/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.faultinjection.ui.menu.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;
import org.eclipse.papyrus.infra.emf.readonly.ReadOnlyManager;
import org.eclipse.papyrus.robotics.faultinjection.ui.Messages;
import org.eclipse.papyrus.robotics.faultinjection.ui.decoration.FIDecorationUtils;
import org.eclipse.papyrus.robotics.faultinjection.ui.utils.FaultInjectionUtils;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.uml2.uml.Element;

public class LoadExperimentHandler
extends CmdHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.updateSelectedEObject();
        if (this.selectedEObject instanceof Element) {
            Object selection;
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
            dialog.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof IFile) {
                        IFile file = (IFile)element;
                        return "faultinjection".equalsIgnoreCase(file.getFileExtension());
                    }
                    return true;
                }
            });
            dialog.setTitle(Messages.LoadExperimentHandler_LOAD_EXPERIMENT);
            dialog.setMessage(Messages.LoadExperimentHandler_SELECT_EXPERIMENT);
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            String path = this.selectedEObject.eResource().getURI().toPlatformString(false);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
            boolean t = file.exists();
            dialog.setInitialSelection((Object)file.getParent());
            if (dialog.open() == 0 && (selection = dialog.getFirstResult()) instanceof IFile) {
                IFile selectedFile = (IFile)selection;
                URI uri = URI.createPlatformResourceURI((String)selectedFile.getFullPath().toString(), (boolean)true);
                FaultInjectionUtils.removeFaultInjectionResource(this.selectedEObject);
                Resource sabotageResource = this.selectedEObject.eResource().getResourceSet().getResource(uri, true);
                ReadOnlyManager.getReadOnlyHandler((EditingDomain)TransactionUtil.getEditingDomain((EObject)this.selectedEObject)).makeWritable(ReadOnlyAxis.anyAxis(), (EObject)sabotageResource.getContents().get(0));
                FIDecorationUtils.removeDecorations((Element)this.selectedEObject, event);
                FIDecorationUtils.addDecorations(FaultInjectionUtils.getFaultList(sabotageResource), event);
            }
        }
        return null;
    }
}

