/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.python.component;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.designer.languages.common.base.file.IFileExists;
import org.eclipse.papyrus.designer.languages.common.base.file.IPFileSystemAccess;
import org.eclipse.papyrus.designer.languages.python.codegen.transformation.PythonModelElementsCreator;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.transformations.ExecuteTransformationChain;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.robotics.codegen.common.component.CodeSkeleton;
import org.eclipse.papyrus.robotics.ros2.codegen.python.component.ComponentHeader;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class RoboticsPythonCreator
extends PythonModelElementsCreator {
    static final String _SKEL = "_skel.";
    Package currentModel;

    public RoboticsPythonCreator(IProject project, IPFileSystemAccess fileAccess) {
        super(project, fileAccess);
    }

    public void createPackageableElement(PackageableElement element, IProgressMonitor monitor) {
        this.currentModel = PackageUtil.getRootPackage((Element)element);
        this.createPackageableElementFile((PackageableElement)this.currentModel, monitor);
        super.createPackageableElement(element, monitor);
    }

    protected void generateFile(String fileName, String content) {
        String postfix;
        if (TransformationContext.monitor.isCanceled()) {
            throw Exceptions.sneakyThrow((Throwable)new TransformationException(ExecuteTransformationChain.USER_CANCEL));
        }
        TransformationContext.monitor.subTask("generate file " + fileName);
        TransformationContext.monitor.worked(1);
        if (this.currentModel != null) {
            content = ComponentHeader.getHeader(this.currentModel) + content;
        }
        if (fileName.endsWith(postfix = String.valueOf(CodeSkeleton.POSTFIX) + "." + this.pythonExt)) {
            IFileExists existsFSA;
            String srcFileName = fileName;
            fileName = fileName.replace(postfix, String.valueOf(CodeSkeleton.POSTFIX) + _SKEL + this.pythonExt);
            if (this.fileSystemAccess instanceof IFileExists && !(existsFSA = (IFileExists)this.fileSystemAccess).existsFile(srcFileName)) {
                super.generateFile(srcFileName, content);
            }
        }
        super.generateFile(fileName, content);
    }

    public String getFileName(NamedElement element) {
        String fileName = super.getFileName(element);
        return fileName;
    }

    protected boolean useRelativeImports() {
        return false;
    }
}

