/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.RobotML;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Shade implements Enumerator
{
    WIREFRAME(0, "WIREFRAME", "WIREFRAME"),
    BOUNDBOX(1, "BOUNDBOX", "BOUNDBOX"),
    SOLID(2, "SOLID", "SOLID"),
    TEXTURED(3, "TEXTURED", "TEXTURED");

    public static final int WIREFRAME_VALUE = 0;
    public static final int BOUNDBOX_VALUE = 1;
    public static final int SOLID_VALUE = 2;
    public static final int TEXTURED_VALUE = 3;
    private static final Shade[] VALUES_ARRAY;
    public static final List<Shade> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Shade[]{WIREFRAME, BOUNDBOX, SOLID, TEXTURED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Shade get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Shade result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Shade getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Shade result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Shade get(int value) {
        switch (value) {
            case 0: {
                return WIREFRAME;
            }
            case 1: {
                return BOUNDBOX;
            }
            case 2: {
                return SOLID;
            }
            case 3: {
                return TEXTURED;
            }
        }
        return null;
    }

    private Shade(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

