/*****************************************************************************
 * Copyright (c) 2016 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Benoit Maggi (CEA LIST) benoit.maggi@cea.fr - Initial API and implementation
 *   
 *****************************************************************************/
package org.eclipse.papyrus.sysml14.validation.rules.requirements;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.papyrus.sysml14.requirements.Refine;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.NamedElement;
/**
 * 
 * 16.3.2.3 Refine (SysML 1.4)
 * [2]Dependencies with a Refine stereotype or one of its specializations applied must have exactly one client and one supplier.
 *
 */
public class RefineOneClientSupplierModelConstraint extends AbstractModelConstraint {


	/* (non-Javadoc)
	 * @see org.eclipse.emf.validation.AbstractModelConstraint#validate(org.eclipse.emf.validation.IValidationContext)
	 */
	@Override
	public IStatus validate(IValidationContext context) {
		Refine refine = (Refine) context.getTarget();
		Abstraction abstraction = refine.getBase_Abstraction();
		if (abstraction == null) {
			return context.createFailureStatus(context.getTarget());
		}
		EList<NamedElement> clients = abstraction.getClients();
		EList<NamedElement> suppliers = abstraction.getSuppliers();
		if (clients == null || clients.size()!= 1 || suppliers == null || suppliers.size() != 1) {
			return context.createFailureStatus(context.getTarget());
		}		
		return context.createSuccessStatus();
	}

}
