/*****************************************************************************
 * Copyright (c) 2016 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Benoit Maggi (CEA LIST) benoit.maggi@cea.fr - Initial API and implementation
 *   
 *****************************************************************************/
package org.eclipse.papyrus.sysml14.validation.rules.blocks;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.papyrus.sysml14.blocks.BoundReference;
import org.eclipse.papyrus.sysml14.blocks.EndPathMultiplicity;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLUtil;

/**
 * 8.3.2.10 EndPathMultiplicity [1] Properties to which EndPathMultiplicity is
 * applied must be related by redefinition to a property to which BoundReference
 * is applied.
 */
public class EndPathMultiplicityBoundReferencePropertyModelConstraint extends AbstractModelConstraint {

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.emf.validation.AbstractModelConstraint#validate(org.eclipse.
	 * emf.validation.IValidationContext)
	 */
	@Override
	public IStatus validate(IValidationContext context) {
		EndPathMultiplicity endPathMultiplicity = (EndPathMultiplicity) context.getTarget();
		Property property = endPathMultiplicity.getBase_Property();
		if (property != null) {
			EList<Property> redefinedProperties = property.getRedefinedProperties();
			for (Property redefinedProperty : redefinedProperties) {
				if (UMLUtil.getStereotypeApplication(redefinedProperty, BoundReference.class) == null) {
					return context.createFailureStatus(context.getTarget());
				}
			}
		}
		return context.createSuccessStatus();
	}

}
