/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.docx.internal.poi;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.docx.Activator;
import org.eclipse.papyrus.model2doc.docx.internal.poi.CustomXWPFGenericRelation;
import org.eclipse.papyrus.model2doc.docx.internal.poi.CustomXWPFParagraph;
import org.eclipse.papyrus.model2doc.docx.internal.poi.CustomXWPFPart;
import org.eclipse.papyrus.model2doc.docx.internal.poi.CustomXWPFTable;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSimpleField;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STOnOff;

public class CustomXWPFDocument
extends XWPFDocument {
    private static int fileIndex = 0;
    private static final List<String> TESTED_FILE_INSERTION = new ArrayList<String>(Arrays.asList("html", "docx", "txt"));
    private IOUtils utils;

    public CustomXWPFDocument() {
    }

    public CustomXWPFDocument(InputStream template) throws IOException {
        super(template);
    }

    public void createTOC() {
        XWPFParagraph paragraph = this.createParagraph();
        CTP ctP = paragraph.getCTP();
        CTSimpleField toc = ctP.addNewFldSimple();
        toc.setInstr("TOC \\o");
        toc.setDirty(STOnOff.TRUE);
    }

    public void createTOF() {
        XWPFParagraph paragraph = this.createParagraph();
        CTSimpleField toc = paragraph.getCTP().addNewFldSimple();
        toc.setInstr("TOC \\c \"figure\" \\* MERGEFORMAT");
        toc.setDirty(STOnOff.TRUE);
    }

    public XWPFTable createTable() {
        CustomXWPFTable table = new CustomXWPFTable(this.getDocument().getBody().addNewTbl(), (IBody)this);
        this.bodyElements.add(table);
        this.tables.add(table);
        return table;
    }

    public XWPFTable createTable(int rows, int cols) {
        CustomXWPFTable table = new CustomXWPFTable(this.getDocument().getBody().addNewTbl(), (IBody)this, rows, cols);
        this.bodyElements.add(table);
        this.tables.add(table);
        return table;
    }

    public XWPFParagraph createParagraph() {
        CustomXWPFParagraph p = new CustomXWPFParagraph(this.getDocument().getBody().addNewP(), (IBody)this);
        this.bodyElements.add(p);
        this.paragraphs.add(p);
        return p;
    }

    public String importFile(String filePath) throws IOException, InvalidFormatException {
        String fileExtension = this.getFileExtension(filePath);
        String id = "file" + fileIndex;
        ++fileIndex;
        StringBuilder partPathBuilder = new StringBuilder("/word/media/");
        partPathBuilder.append(id);
        partPathBuilder.append(".");
        partPathBuilder.append(fileExtension);
        OPCPackage opcPackage = this.getPackage();
        PackagePartName partName = PackagingURIHelper.createPartName((String)partPathBuilder.toString());
        String contentType = Files.probeContentType(Paths.get(filePath.replaceFirst("/", ""), new String[0]));
        if (contentType == null) {
            contentType = "text/plain";
        }
        PackagePart packagePart = opcPackage.createPart(partName, contentType);
        CustomXWPFPart part = new CustomXWPFPart(packagePart, id, filePath);
        this.addRelation(part.getId(), new CustomXWPFGenericRelation(contentType), part);
        return id;
    }

    public void insertFile(String filePath) {
        String fileExtension = this.getFileExtension(filePath);
        if (!this.isTestedFileExtension(fileExtension)) {
            Activator.log.warn(NLS.bind((String)"We only the insertion of {0} files are supported", TESTED_FILE_INSERTION));
            XWPFParagraph paragraph = this.createParagraph();
            XWPFRun run = paragraph.createRun();
            run.setText(NLS.bind((String)"[The file {0} cannot be inserted]", (Object)filePath));
            run.setColor("FF0000");
            run.setItalic(true);
            return;
        }
        try {
            String id = this.importFile(filePath);
            this.getDocument().getBody().addNewAltChunk().setId(id);
        }
        catch (IOException | InvalidFormatException e) {
            Activator.log.error(e);
        }
    }

    private boolean isTestedFileExtension(String extension) {
        return TESTED_FILE_INSERTION.stream().anyMatch(s -> s.equalsIgnoreCase(extension));
    }

    private String getFileExtension(String filePath) {
        String[] split = filePath.split("\\.");
        return split[split.length - 1];
    }
}

