/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.drop.diagrams;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.drop.IInternalSourceToRepresentationDropChecker;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityGroup;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExpansionNode;
import org.eclipse.uml2.uml.ExpansionRegion;
import org.eclipse.uml2.uml.InterruptibleActivityRegion;
import org.eclipse.uml2.uml.StructuredActivityNode;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ActivityInternalSourceToRepresentationDropChecker
implements IInternalSourceToRepresentationDropChecker {
    private static final String UNAUTHORIZED_DND_ERROR_MSG = "DnD is not authorized.";
    private static final String DROP_ERROR_MSG = "{0} can only be drag and drop on {1}.";
    private static final String COMA = ", ";

    @Override
    public CheckStatus canDragAndDrop(EObject elementToDrop, EObject newSemanticContainer) {
        return (CheckStatus)new ActivityDropOutsideRepresentationCheckerSwitch(newSemanticContainer).doSwitch(elementToDrop);
    }

    static class ActivityDropOutsideRepresentationCheckerSwitch
    extends UMLSwitch<CheckStatus> {
        private final EObject newSemanticContainer;

        ActivityDropOutsideRepresentationCheckerSwitch(EObject target) {
            this.newSemanticContainer = target;
        }

        public CheckStatus caseActivity(Activity activity) {
            CheckStatus result = this.newSemanticContainer instanceof Activity ? CheckStatus.YES : CheckStatus.no(MessageFormat.format(ActivityInternalSourceToRepresentationDropChecker.DROP_ERROR_MSG, activity.eClass().getName(), UMLPackage.eINSTANCE.getActivity().getName()));
            return result;
        }

        public CheckStatus caseActivityNode(ActivityNode activityNode) {
            CheckStatus result = null;
            result = this.newSemanticContainer instanceof Activity || this.newSemanticContainer instanceof ActivityGroup ? CheckStatus.YES : CheckStatus.no(MessageFormat.format(ActivityInternalSourceToRepresentationDropChecker.DROP_ERROR_MSG, activityNode.eClass().getName(), UMLPackage.eINSTANCE.getActivity().getName() + ActivityInternalSourceToRepresentationDropChecker.COMA + UMLPackage.eINSTANCE.getActivityGroup().getName()));
            return result;
        }

        public CheckStatus caseActivityParameterNode(ActivityParameterNode activityParameterNode) {
            CheckStatus result = this.newSemanticContainer instanceof Activity ? CheckStatus.YES : CheckStatus.no(MessageFormat.format(ActivityInternalSourceToRepresentationDropChecker.DROP_ERROR_MSG, activityParameterNode.eClass().getName(), UMLPackage.eINSTANCE.getActivity().getName()));
            return result;
        }

        public CheckStatus caseActivityPartition(ActivityPartition activityPartition) {
            CheckStatus result = this.newSemanticContainer instanceof Activity || this.newSemanticContainer instanceof ActivityPartition ? CheckStatus.YES : CheckStatus.no(MessageFormat.format(ActivityInternalSourceToRepresentationDropChecker.DROP_ERROR_MSG, activityPartition.eClass().getName(), UMLPackage.eINSTANCE.getActivity().getName() + ActivityInternalSourceToRepresentationDropChecker.COMA + UMLPackage.eINSTANCE.getActivityPartition().getName()));
            return result;
        }

        public CheckStatus caseComment(Comment comment) {
            CheckStatus result = this.newSemanticContainer instanceof ActivityGroup || this.newSemanticContainer instanceof Activity ? CheckStatus.YES : CheckStatus.no(MessageFormat.format(ActivityInternalSourceToRepresentationDropChecker.DROP_ERROR_MSG, comment.eClass().getName(), UMLPackage.eINSTANCE.getActivity().getName() + ActivityInternalSourceToRepresentationDropChecker.COMA + UMLPackage.eINSTANCE.getActivityGroup().getName()));
            return result;
        }

        public CheckStatus caseConstraint(Constraint constraint) {
            CheckStatus result = this.newSemanticContainer instanceof StructuredActivityNode || this.newSemanticContainer instanceof Activity ? CheckStatus.YES : CheckStatus.no(MessageFormat.format(ActivityInternalSourceToRepresentationDropChecker.DROP_ERROR_MSG, constraint.eClass().getName(), UMLPackage.eINSTANCE.getActivity().getName() + ActivityInternalSourceToRepresentationDropChecker.COMA + UMLPackage.eINSTANCE.getStructuredActivityNode().getName()));
            return result;
        }

        public CheckStatus caseElement(Element element) {
            return CheckStatus.no(ActivityInternalSourceToRepresentationDropChecker.UNAUTHORIZED_DND_ERROR_MSG);
        }

        public CheckStatus caseExpansionNode(ExpansionNode expansionNode) {
            CheckStatus result = this.newSemanticContainer instanceof ExpansionRegion ? CheckStatus.YES : CheckStatus.no(MessageFormat.format(ActivityInternalSourceToRepresentationDropChecker.DROP_ERROR_MSG, expansionNode.eClass().getName(), UMLPackage.eINSTANCE.getExpansionRegion().getName()));
            return result;
        }

        public CheckStatus caseInterruptibleActivityRegion(InterruptibleActivityRegion interruptibleActivityRegion) {
            CheckStatus result = this.newSemanticContainer instanceof Activity ? CheckStatus.YES : CheckStatus.no(MessageFormat.format(ActivityInternalSourceToRepresentationDropChecker.DROP_ERROR_MSG, interruptibleActivityRegion.eClass().getName()));
            return result;
        }
    }
}

