/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UpdateStereotypeValueCommand
extends RecordingCommand {
    private PapyrusClipboard<Object> papyrusClipboard;
    private Map<EObject, EObject> stereotypeApplicationMap;

    public UpdateStereotypeValueCommand(TransactionalEditingDomain domain, PapyrusClipboard<Object> papyrusClipboard, Map<EObject, EObject> stereotypeApplicationMap) {
        super(domain);
        this.papyrusClipboard = papyrusClipboard;
        this.stereotypeApplicationMap = stereotypeApplicationMap;
    }

    protected void doExecute() {
        for (Map.Entry<EObject, EObject> entry : this.stereotypeApplicationMap.entrySet()) {
            this.mapValues(entry.getKey(), entry.getValue());
        }
    }

    private void mapValues(EObject sourceSteAppl, EObject targetSteAppl) {
        Assert.isTrue((sourceSteAppl.eClass() == targetSteAppl.eClass() ? 1 : 0) != 0);
        for (EReference eRef : sourceSteAppl.eClass().getEAllReferences()) {
            if (eRef.getName().startsWith("base_") || !eRef.isChangeable() || eRef.isContainment()) continue;
            if (eRef.isMany()) {
                Collection sourceValues = (Collection)sourceSteAppl.eGet((EStructuralFeature)eRef);
                ArrayList<EObject> targetValues = new ArrayList<EObject>();
                for (Object currentSourceValue : sourceValues) {
                    if (!(currentSourceValue instanceof EObject)) continue;
                    EObject currentValue = (EObject)currentSourceValue;
                    targetValues.add(this.getTargetValue(currentValue));
                }
                targetSteAppl.eSet((EStructuralFeature)eRef, targetValues);
                continue;
            }
            EObject sourceValue = (EObject)sourceSteAppl.eGet((EStructuralFeature)eRef);
            EObject targetValue = this.getTargetValue(sourceValue);
            targetSteAppl.eSet((EStructuralFeature)eRef, (Object)targetValue);
        }
    }

    protected EObject getTargetValue(EObject sourceValue) {
        EObject returnedValue = null;
        if (this.isStereotypeApplication(sourceValue)) {
            EObject targetValue = this.stereotypeApplicationMap.get(sourceValue);
            returnedValue = targetValue == null ? sourceValue : targetValue;
        } else if (sourceValue instanceof Element) {
            EObject intermediateCopiedElement;
            Map internalClipboardToTargetCopy = this.papyrusClipboard.getInternalClipboardToTargetCopy();
            EObject realPastedElement = (EObject)internalClipboardToTargetCopy.get(intermediateCopiedElement = (EObject)this.papyrusClipboard.getSourceToInternalClipboard().get(sourceValue));
            returnedValue = realPastedElement == null ? sourceValue : realPastedElement;
        }
        return returnedValue;
    }

    private boolean isStereotypeApplication(EObject eobject) {
        return UMLUtil.getBaseElement((EObject)eobject) != null;
    }
}

