/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.assistant.internal.expressions;

import java.io.File;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.gmfdiag.assistant.internal.core.ModelingAssistantModelRegistry;

public class ResourcePropertyTester
extends PropertyTester {
    private static final String PROPERTY_IS_DEPLOYED = "isDeployed";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result = false;
        switch (property) {
            case "isDeployed": {
                URI uri = ResourcePropertyTester.getURI(receiver);
                if (uri == null) break;
                result = ModelingAssistantModelRegistry.getInstance().isRegistered(uri) == ResourcePropertyTester.asBoolean(expectedValue);
            }
        }
        return result;
    }

    static URI getURI(Object object) {
        URI result = null;
        if (object instanceof URI) {
            result = (URI)object;
        } else if (object instanceof Resource) {
            result = ((Resource)object).getURI();
        } else if (object instanceof EObject) {
            result = EcoreUtil.getURI((EObject)((EObject)object));
        } else if (object instanceof IFile) {
            result = URI.createPlatformResourceURI((String)((IFile)object).getFullPath().toString(), (boolean)true);
        } else if (object instanceof File) {
            result = URI.createFileURI((String)((File)object).getAbsolutePath());
        }
        return result;
    }

    static boolean asBoolean(Object expectedValue) {
        return expectedValue instanceof Boolean ? (Boolean)expectedValue : expectedValue == null || Boolean.parseBoolean(String.valueOf(expectedValue));
    }
}

