/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.assistant.internal.operations;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.IEditHelperContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.gmfdiag.assistant.AssistedElementTypeFilter;
import org.eclipse.papyrus.infra.gmfdiag.assistant.ModelingAssistantProvider;
import org.eclipse.papyrus.infra.gmfdiag.assistant.core.util.ModelingAssistantUtil;

public class AssistedElementTypeFilterOperations {
    protected AssistedElementTypeFilterOperations() {
    }

    public static boolean matches(AssistedElementTypeFilter assistedElementTypeFilter, Object input) {
        boolean result = false;
        ModelingAssistantProvider provider = assistedElementTypeFilter.getProvider();
        if (provider != null) {
            result = AssistedElementTypeFilterOperations.matchAnyElementType(provider, input);
        }
        return result;
    }

    protected static boolean matchAnyElementType(ModelingAssistantProvider provider, Object object) {
        ImmutableSet assisted;
        ImmutableSet types;
        boolean result = object instanceof IElementType ? provider.getElementTypes().contains(object) : (object instanceof IEditHelperContext && ((IEditHelperContext)object).getElementType() != null ? provider.getElementTypes().contains((Object)((IEditHelperContext)object).getElementType()) : !Sets.intersection((Set)(types = ImmutableSet.copyOf((Object[])ModelingAssistantUtil.getElementTypes(provider, object))), (Set)(assisted = ImmutableSet.copyOf(provider.getElementTypes()))).isEmpty());
        return result;
    }

    public static ModelingAssistantProvider getProvider(AssistedElementTypeFilter assistedElementTypeFilter) {
        ModelingAssistantProvider result = null;
        EObject container = assistedElementTypeFilter.eContainer();
        while (container != null && result == null) {
            if (container instanceof ModelingAssistantProvider) {
                result = (ModelingAssistantProvider)container;
            }
            container = container.eContainer();
        }
        return result;
    }
}

