/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.adapter.SemanticAdapter;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.helpers.Zone;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.statemachine.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.UMLPackage;

public class CustomFirstRegionInCompositeStateCreateElementCommand
extends AbstractTransactionalCommand {
    IAdaptable adaptable;
    IAdaptable adaptableForDropped = null;
    PreferencesHint prefHints;
    CreateViewRequest.ViewDescriptor viewDescriptor;
    String dropLocation = "";
    CreateElementRequest createElementRequest;
    protected Region umlRegion;

    public CustomFirstRegionInCompositeStateCreateElementCommand(IAdaptable adaptable, IAdaptable adaptableForDropped, PreferencesHint prefHints, TransactionalEditingDomain domain, String label, String dropLocation) {
        super(domain, label, null);
        this.adaptable = adaptable;
        this.adaptableForDropped = adaptableForDropped;
        this.prefHints = prefHints;
        this.viewDescriptor = new CreateViewRequest.ViewDescriptor(adaptable, prefHints);
        this.setResult(CommandResult.newOKCommandResult((Object)this.viewDescriptor));
        this.dropLocation = dropLocation;
        this.umlRegion = null;
    }

    public void useExistingRegion(Region umlRegion) {
        this.umlRegion = umlRegion;
    }

    public boolean canExecute() {
        View owner;
        State state;
        View compartment = (View)this.adaptable.getAdapter(View.class);
        return compartment.getChildren().isEmpty() && (state = (State)(owner = (View)compartment.eContainer()).getElement()).getSubmachine() == null;
    }

    @Deprecated
    protected void doConfigure(Region newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = this.createElementRequest.getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(this.createElementRequest.getClientContext());
        configureRequest.addParameters(this.createElementRequest.getParameters());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View compartment = (View)this.adaptable.getAdapter(View.class);
        View ownerView = (View)compartment.eContainer();
        int height = Zone.getHeight(ownerView);
        int width = Zone.getWidth(ownerView);
        if (height < 100) {
            height = 100;
            Zone.setHeight(ownerView, height);
        }
        if (width < 200) {
            width = 200;
            Zone.setWidth(ownerView, width);
        }
        if (this.adaptableForDropped == null) {
            State umlState = (State)ownerView.getElement();
            EList regions = umlState.getRegions();
            if (!regions.isEmpty()) {
                this.umlRegion = (Region)regions.get(0);
            }
            if (this.umlRegion == null) {
                CreateElementRequest request = new CreateElementRequest((EObject)umlState, (IElementType)org.eclipse.papyrus.uml.service.types.element.UMLElementTypes.REGION, UMLPackage.eINSTANCE.getState_Region());
                IElementEditService service = ElementEditServiceUtils.getCommandProvider((EObject)umlState);
                ICommand cmd = service.getEditCommand((IEditCommandRequest)request);
                cmd.execute((IProgressMonitor)new NullProgressMonitor(), null);
                this.umlRegion = (Region)request.getNewElement();
            }
            this.adaptableForDropped = new SemanticAdapter((EObject)this.umlRegion, null);
        }
        String semanticHint = ((IHintedType)UMLElementTypes.Region_Shape).getSemanticHint();
        Node newRegion = ViewService.getInstance().createNode(this.adaptableForDropped, compartment, semanticHint, -1, this.prefHints);
        Zone.createRegionDefaultAnnotation((View)newRegion);
        for (Object next : ownerView.getChildren()) {
            if (!(next instanceof Node)) continue;
            Node currentNode = (Node)next;
            if (currentNode.getLayoutConstraint() == null) {
                currentNode.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
            }
            if ("State_NameLabel".equals(UMLVisualIDRegistry.getVisualID(currentNode.getType()))) {
                Zone.setWidth((View)currentNode, width);
                Zone.setHeight((View)currentNode, 13);
                continue;
            }
            if (!"State_RegionCompartment".equals(UMLVisualIDRegistry.getVisualID(currentNode.getType()))) continue;
            Zone.setY((View)currentNode, 13);
            Zone.setWidth((View)currentNode, width);
            Zone.setHeight((View)currentNode, height - 13);
            for (Object subnext : currentNode.getChildren()) {
                if (!(subnext instanceof Node)) continue;
                Node subCurrentNode = (Node)subnext;
                if (subCurrentNode.getLayoutConstraint() == null) {
                    subCurrentNode.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
                }
                if (!"Region_Shape".equals(UMLVisualIDRegistry.getVisualID(subCurrentNode.getType()))) continue;
                Zone.setWidth((View)subCurrentNode, width);
                Zone.setHeight((View)subCurrentNode, height - 13);
            }
        }
        this.viewDescriptor.setView((View)newRegion);
        return CommandResult.newOKCommandResult(null);
    }
}

