/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.util.EvaluationMonitor;
import org.eclipse.m2m.qvt.oml.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecutionContextImpl
implements ExecutionContext {
    private Map<String, Object> fConfigProperties = new HashMap<String, Object>(5);
    private EvaluationMonitor fMonitor;
    private Log fLog = Log.NULL_LOG;

    public ExecutionContextImpl() {
        this.fMonitor = ExecutionContextImpl.createDefaultMonitor();
    }

    @Override
    public Object getConfigProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this.fConfigProperties.get(name);
    }

    public void setConfigProperty(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("null config property name");
        }
        this.fConfigProperties.put(name, value);
    }

    @Override
    public Set<String> getConfigPropertyNames() {
        return Collections.unmodifiableSet(this.fConfigProperties.keySet());
    }

    public void setLog(Log log) {
        if (log == null) {
            throw new IllegalArgumentException("Non-null logger required");
        }
        this.fLog = log;
    }

    @Override
    public Log getLog() {
        return this.fLog;
    }

    @Override
    public EvaluationMonitor getMonitor() {
        return this.fMonitor;
    }

    public void setMonitor(EvaluationMonitor monitor) {
        if (monitor == null) {
            throw new IllegalArgumentException("null monitor");
        }
        this.fMonitor = monitor;
    }

    private static EvaluationMonitor createDefaultMonitor() {
        return new EvaluationMonitor(){
            boolean myIsCancelled;

            public void cancel() {
                this.myIsCancelled = true;
            }

            public boolean isCanceled() {
                return this.myIsCancelled;
            }
        };
    }
}

