/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.util;

import com.google.common.base.Function;
import java.io.IOException;
import org.eclipse.jdt.internal.ui.javaeditor.ClipboardOperationAction;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.ui.util.SWTUtil;

public class ClipboardUtil {
    public static Object copy(final String data) {
        if (data == null) {
            return null;
        }
        return ClipboardUtil.clipboardOperation(new Function<Clipboard, Object>(){

            public Object apply(Clipboard clipboard) {
                clipboard.setContents(new Object[]{data}, new Transfer[]{TextTransfer.getInstance()});
                return null;
            }
        });
    }

    public static String getTextFromClipboard() {
        return ClipboardUtil.clipboardOperation(new Function<Clipboard, String>(){

            public String apply(Clipboard input) {
                return (String)input.getContents((Transfer)TextTransfer.getInstance());
            }
        });
    }

    public static <T> T clipboardOperation(Function<Clipboard, T> function) {
        Object contents;
        Clipboard clipboard = null;
        try {
            Display display = SWTUtil.getStandardDisplay();
            clipboard = new Clipboard(display);
            contents = function.apply((Object)clipboard);
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
        return (T)contents;
    }

    public static JavaImportData getJavaImportsContent() {
        return ClipboardUtil.clipboardOperation(new Function<Clipboard, JavaImportData>(){

            public JavaImportData apply(Clipboard clipboard) {
                int i = 0;
                while (i < clipboard.getAvailableTypeNames().length) {
                    String formatName = clipboard.getAvailableTypeNames()[i];
                    if (formatName.startsWith("source-with-imports-transfer-format")) {
                        TransferData transferData = clipboard.getAvailableTypes()[i];
                        Object content = clipboard.getContents((Transfer)new DynamicByteArrayTransfer(formatName, transferData));
                        if (content instanceof JavaImportData) {
                            return (JavaImportData)content;
                        }
                        return null;
                    }
                    ++i;
                }
                return null;
            }
        });
    }

    private static final class DynamicByteArrayTransfer
    extends ByteArrayTransfer {
        private final String formatName;
        private final TransferData transferData;

        private DynamicByteArrayTransfer(String formatName, TransferData transferData) {
            this.formatName = formatName;
            this.transferData = transferData;
        }

        protected String[] getTypeNames() {
            return new String[]{this.formatName};
        }

        protected int[] getTypeIds() {
            return new int[0];
        }

        public TransferData[] getSupportedTypes() {
            return new TransferData[]{this.transferData};
        }

        public boolean isSupportedType(TransferData transferData) {
            return transferData != null;
        }

        public Object nativeToJava(TransferData transferData) {
            byte[] bytes = (byte[])super.nativeToJava(transferData);
            if (bytes != null) {
                try {
                    return new JavaImportData(new ClipboardOperationAction.ClipboardData(bytes));
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }

    public static class JavaImportData {
        private String[] imports;
        private String[] staticImports;

        public JavaImportData(String[] imports, String[] staticImports) {
            this.imports = imports;
            this.staticImports = staticImports;
        }

        JavaImportData(ClipboardOperationAction.ClipboardData jdtClipboardData) {
            this.imports = jdtClipboardData.getTypeImports();
            this.staticImports = jdtClipboardData.getStaticImports();
        }

        public String[] getImports() {
            return this.imports;
        }

        public String[] getStaticImports() {
            return this.staticImports;
        }
    }
}

