/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.serializer.debug;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.formatting2.debug.TextRegionsToString;
import org.eclipse.xtext.ide.serializer.IEmfResourceChange;
import org.eclipse.xtext.ide.serializer.ITextDocumentChange;

public class TextDocumentChangeToString {
    private List<IEmfResourceChange> changes = Lists.newArrayList();

    public TextDocumentChangeToString add(IEmfResourceChange change) {
        this.changes.add(change);
        return this;
    }

    public TextDocumentChangeToString add(Collection<IEmfResourceChange> changes) {
        this.changes.addAll(changes);
        return this;
    }

    private String box(String title, String content) {
        int width = 80;
        int min = 3;
        int titleLength = title.length() + 2;
        int left = Math.max((80 - titleLength) / 2, 3);
        StringBuilder result = new StringBuilder();
        result.append(Strings.repeat((String)"-", (int)left));
        result.append(" ");
        result.append(title);
        result.append(" ");
        if (left > 3) {
            result.append(Strings.repeat((String)"-", (int)(80 - left - titleLength)));
        }
        result.append("\n");
        result.append(org.eclipse.xtext.util.Strings.trimTrailingLineBreak((CharSequence)content));
        result.append("\n");
        result.append(Strings.repeat((String)"-", (int)80));
        return result.toString();
    }

    public String toString() {
        ArrayList result = Lists.newArrayList();
        for (IEmfResourceChange c : this.changes) {
            String title = this.getTitle(c);
            if (c instanceof ITextDocumentChange) {
                ITextDocumentChange change = (ITextDocumentChange)c;
                TextRegionsToString textRegionsToString = new TextRegionsToString();
                textRegionsToString.addAllReplacements(change.getReplacements());
                textRegionsToString.setTitle(title);
                result.add(textRegionsToString.toString());
                continue;
            }
            String box = this.box(title, c.toString());
            result.add(box);
        }
        return Joiner.on((String)"\n").join((Iterable)result);
    }

    protected String getTitle(IEmfResourceChange change) {
        URI newUri = change.getNewURI();
        URI oldURI = change.getOldURI();
        if (oldURI == null && newUri == null) {
            return "error, both URIs are null";
        }
        if (newUri == null) {
            return "deleted " + oldURI;
        }
        if (oldURI == null) {
            return "created " + newUri;
        }
        if (oldURI.equals(newUri)) {
            return oldURI.toString();
        }
        return "renamed " + oldURI + " to " + newUri;
    }
}

