/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.concurrent;

import com.google.inject.Inject;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.xtext.ide.server.concurrent.Cancellable;
import org.eclipse.xtext.ide.server.concurrent.RequestCancelIndicator;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;

public class RequestManager {
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    @Inject
    private ExecutorService parallel;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    private final CopyOnWriteArrayList<Cancellable> toCancel = new CopyOnWriteArrayList();
    private CompletableFuture<Void> writePending = CompletableFuture.completedFuture(null);

    public void shutdown() {
        this.parallel.shutdown();
        this.cancel();
    }

    public <V> CompletableFuture<V> runRead(Functions.Function1<? super CancelIndicator, ? extends V> request) {
        CompletableFuture result = new CompletableFuture();
        Runnable _function = () -> {
            Callable<Boolean> _function_1 = () -> {
                boolean _xtrycatchfinallyexpression;
                boolean _xblockexpression;
                block6: {
                    _xblockexpression = false;
                    RequestCancelIndicator cancelIndicator = new RequestCancelIndicator(result);
                    _xtrycatchfinallyexpression = false;
                    try {
                        boolean _xblockexpression_1 = false;
                        this.r.lock();
                        this.toCancel.add(cancelIndicator);
                        cancelIndicator.checkCanceled();
                        _xtrycatchfinallyexpression = _xblockexpression_1 = result.complete(request.apply((Object)cancelIndicator));
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Throwable) {
                            Throwable e = _t;
                            _xtrycatchfinallyexpression = result.completeExceptionally(e);
                            break block6;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    finally {
                        this.toCancel.remove(cancelIndicator);
                        this.r.unlock();
                    }
                }
                _xblockexpression = _xtrycatchfinallyexpression;
                return _xblockexpression;
            };
            this.parallel.submit(_function_1);
        };
        this.writePending.thenRun(_function);
        return result;
    }

    public <U, V> CompletableFuture<V> runWrite(Functions.Function0<? extends U> nonCancellable, Functions.Function2<? super CancelIndicator, ? super U, ? extends V> request) {
        CompletableFuture result = new CompletableFuture();
        CompletableFuture localWritePending = new CompletableFuture();
        this.writePending = localWritePending;
        Callable<Boolean> _function = () -> {
            boolean _xtrycatchfinallyexpression;
            boolean _xblockexpression;
            block6: {
                _xblockexpression = false;
                RequestCancelIndicator cancelIndicator = new RequestCancelIndicator(result);
                _xtrycatchfinallyexpression = false;
                try {
                    boolean _xblockexpression_1 = false;
                    this.cancel();
                    this.w.lock();
                    localWritePending.complete(null);
                    Object intermediateResult = nonCancellable.apply();
                    this.toCancel.add(cancelIndicator);
                    cancelIndicator.checkCanceled();
                    _xtrycatchfinallyexpression = _xblockexpression_1 = result.complete(request.apply((Object)cancelIndicator, intermediateResult));
                }
                catch (Throwable _t) {
                    if (_t instanceof Throwable) {
                        Throwable e = _t;
                        _xtrycatchfinallyexpression = result.completeExceptionally(e);
                        break block6;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                finally {
                    this.toCancel.remove(cancelIndicator);
                    this.w.unlock();
                }
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        };
        this.parallel.submit(_function);
        return result;
    }

    protected void cancel() {
        for (Cancellable cancellable : this.toCancel) {
            cancellable.cancel();
            this.toCancel.remove(cancellable);
        }
    }

    protected boolean isCancelException(Throwable t) {
        if (t == null) {
            return false;
        }
        Throwable _xifexpression = null;
        _xifexpression = t instanceof CompletionException ? ((CompletionException)t).getCause() : t;
        Throwable cause = _xifexpression;
        return this.operationCanceledManager.isOperationCanceledException(cause);
    }
}

